/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.util.PmsUtil;
import com.zzsn.common.util.SpringContextUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelUtil.class);

    public static Result<?> imporReturnRes(int errorLines, int successLines, List<String> errorMessage) throws IOException {
        if (errorLines == 0) {
            return Result.ok("\u5171" + successLines + "\u884c\u6570\u636e\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01");
        }
        JSONObject result = new JSONObject(5);
        int totalCount = successLines + errorLines;
        result.put("totalCount", (Object)totalCount);
        result.put("errorCount", (Object)errorLines);
        result.put("successCount", (Object)successLines);
        result.put("msg", (Object)("\u603b\u4e0a\u4f20\u884c\u6570\uff1a" + totalCount + "\uff0c\u5df2\u5bfc\u5165\u884c\u6570\uff1a" + successLines + "\uff0c\u9519\u8bef\u884c\u6570\uff1a" + errorLines));
        String fileUrl = PmsUtil.saveErrorTxtByList(errorMessage, "userImportExcelErrorLog");
        int lastIndex = fileUrl.lastIndexOf(File.separator);
        String fileName = fileUrl.substring(lastIndex + 1);
        result.put("fileUrl", (Object)("/sys/common/static/" + fileUrl));
        result.put("fileName", (Object)fileName);
        Result<Object> res = Result.ok(result);
        res.setCode(201);
        res.setMessage("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff0c\u4f46\u6709\u9519\u8bef\u3002");
        return res;
    }

    public static List<String> importDateSave(List<Object> list, Class serviceClass, List<String> errorMessage, String errorFlag) {
        IService bean = (IService)SpringContextUtils.getBean(serviceClass);
        for (int i = 0; i < list.size(); ++i) {
            try {
                boolean save = bean.save(list.get(i));
                if (save) continue;
                throw new Exception(errorFlag);
            }
            catch (Exception e) {
                String message = e.getMessage();
                int lineNumber = i + 1;
                if (message.contains("uniq_sys_role_role_code")) {
                    errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u89d2\u8272\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                    continue;
                }
                if (message.contains("uniq_job_class_name")) {
                    errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u4efb\u52a1\u7c7b\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                    continue;
                }
                if (message.contains("uniq_code")) {
                    errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u804c\u52a1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                    continue;
                }
                if (message.contains("uniq_depart_org_code")) {
                    errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u90e8\u95e8\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                    continue;
                }
                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u5bfc\u5165");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return errorMessage;
    }

    public static List<String> importDateSaveOne(Object obj, Class serviceClass, List<String> errorMessage, int i, String errorFlag) {
        IService bean = (IService)SpringContextUtils.getBean(serviceClass);
        try {
            boolean save = bean.save(obj);
            if (!save) {
                throw new Exception(errorFlag);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            int lineNumber = i + 1;
            if (message.contains("uniq_sys_role_role_code")) {
                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u89d2\u8272\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
            }
            if (message.contains("uniq_job_class_name")) {
                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u4efb\u52a1\u7c7b\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
            }
            if (message.contains("uniq_code")) {
                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u804c\u52a1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
            }
            if (message.contains("uniq_depart_org_code")) {
                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u90e8\u95e8\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
            }
            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u5bfc\u5165");
            log.error(e.getMessage(), (Throwable)e);
        }
        return errorMessage;
    }
}

