/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.system.util;

import cn.hutool.crypto.SecureUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Joiner;
import com.zzsn.common.exception.JeecgBootException;
import com.zzsn.common.system.util.JeecgDataAutorUtils;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.common.system.vo.SysUserCacheInfo;
import com.zzsn.common.util.RedisUtil;
import com.zzsn.common.util.SpringContextUtils;
import com.zzsn.common.util.oConvertUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    public static final long EXPIRE_TIME = 43200000L;

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)SecureUtil.md5((String)secret));
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", username).build();
            DecodedJWT jwt = verifier.verify(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String sign(String username, String secret) {
        Date date = new Date(System.currentTimeMillis() + 43200000L);
        Algorithm algorithm = Algorithm.HMAC256((String)SecureUtil.md5((String)secret));
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static String getUserNameByToken(HttpServletRequest request) throws JeecgBootException {
        String accessToken = request.getHeader("X-Access-Token");
        String username = JwtUtil.getUsername(accessToken);
        if (oConvertUtils.isEmpty(username)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u7528\u6237");
        }
        return username;
    }

    public static LoginUser getLoginUser() throws JeecgBootException {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        if (request == null) {
            log.warn(" \u975erequest\u65b9\u5f0f\u8bbf\u95ee\uff01! ");
            return null;
        }
        String accessToken = request.getHeader("X-Access-Token");
        if (oConvertUtils.isEmpty(accessToken)) {
            return null;
        }
        String username = JwtUtil.getUsername(accessToken);
        if (oConvertUtils.isEmpty(username)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u7528\u6237");
        }
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getApplicationContext().getBean(RedisUtil.class);
        LoginUser sysUser = (LoginUser)redisUtil.get("sys:cache:user:jwt:" + username);
        return sysUser;
    }

    public static String getSessionData(String key) {
        String moshi = "";
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains("#{")) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (oConvertUtils.isNotEmpty(key)) {
            HttpSession session = SpringContextUtils.getHttpServletRequest().getSession();
            returnValue = (String)session.getAttribute(key);
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }

    public static String getUserSystemData(String key, SysUserCacheInfo user) {
        if (user == null) {
            user = JeecgDataAutorUtils.loadUserInfo();
        }
        LoginUser sysUser = JwtUtil.getLoginUser();
        String moshi = "";
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains("#{")) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (key.equals("sysUserCode") || key.toLowerCase().equals("sys_user_code")) {
            returnValue = user == null ? sysUser.getUsername() : user.getSysUserCode();
        } else if (key.equals("sysUserName") || key.toLowerCase().equals("sys_user_name")) {
            returnValue = user == null ? sysUser.getRealname() : user.getSysUserName();
        } else if (key.equals("sysOrgCode") || key.toLowerCase().equals("sys_org_code")) {
            returnValue = user == null ? sysUser.getOrgCode() : user.getSysOrgCode();
        } else if (key.equals("sysMultiOrgCode") || key.toLowerCase().equals("sys_multi_org_code")) {
            returnValue = user.isOneDepart() ? user.getSysMultiOrgCode().get(0) : Joiner.on((String)",").join(user.getSysMultiOrgCode());
        } else if (key.equals("sysDate") || key.toLowerCase().equals("sys_date")) {
            returnValue = user.getSysDate();
        } else if (key.equals("sysTime") || key.toLowerCase().equals("sys_time")) {
            returnValue = user.getSysTime();
        } else if (key.equals("bpmStatus") || key.toLowerCase().equals("bpm_status")) {
            returnValue = "1";
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }

    public static void main(String[] args) {
        String token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE1NjUzMzY1MTMsInVzZXJuYW1lIjoiYWRtaW4ifQ.xjhud_tWCNYBOg_aRlMgOdlZoWFFKB_givNElHNw3X0";
        System.out.println(JwtUtil.getUsername(token));
    }
}

