/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.es;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class ElasticsearchClientConfig
implements DisposableBean {
    @Value(value="${zzsn.es.host}")
    private String host;
    @Value(value="${zzsn.es.port}")
    private int port;
    @Value(value="${zzsn.es.url}")
    private String url;
    @Value(value="${zzsn.es.userName}")
    private String userName;
    @Value(value="${zzsn.es.passWord}")
    private String passWord;
    @Value(value="${zzsn.es.clusterIsStart}")
    private Boolean clusterIsStart;
    @Value(value="${zzsn.es.indexs}")
    private String indexs;
    private final String scheme = "http";
    private final int connectTimeOut = 5000;
    private final int socketTimeOut = 60000;
    private final int connectionRequestTimeOut = 1500;
    private final int maxConnectPerRoute = 10;
    private final int nodesNum = 3;
    private final int maxConnectNum = 30;
    private final boolean uniqueConnectTimeConfig = true;
    private final boolean uniqueConnectNumConfig = true;
    private RestClientBuilder builder;
    private RestHighLevelClient client;

    public String getIndexs() {
        return this.indexs;
    }

    public void setIndexs(String indexs) {
        this.indexs = indexs;
    }

    @Bean(value={"restHighLevelClientEs"})
    public RestHighLevelClient restHighLevelClient() {
        if (this.clusterIsStart.booleanValue()) {
            HttpHost[] httpHosts = null;
            if (this.url != null) {
                String[] urls = this.url.split(",");
                httpHosts = new HttpHost[urls.length];
                for (int i = 0; i < urls.length; ++i) {
                    String[] ipAndPort = urls[i].split(":");
                    httpHosts[i] = new HttpHost(ipAndPort[0], Integer.valueOf(ipAndPort[1]).intValue(), "http");
                }
            }
            this.builder = RestClient.builder(httpHosts);
        } else {
            HttpHost httpHost = new HttpHost(this.host, this.port, "http");
            this.builder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        }
        this.setConnectTimeOutConfig();
        this.setMutiConnectConfig();
        this.client = new RestHighLevelClient(this.builder);
        return this.client;
    }

    private void setMutiConnectConfig() {
        this.builder.setHttpClientConfigCallback(HttpClientBuilder -> {
            if (!StringUtils.isEmpty((Object)this.userName) && !StringUtils.isEmpty((Object)this.passWord)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.passWord));
                HttpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return HttpClientBuilder.setMaxConnTotal(30).setMaxConnPerRoute(10).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() << 1).build());
        });
    }

    private void setConnectTimeOutConfig() {
        this.builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(1500));
    }

    public void destroy() throws Exception {
        this.close();
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

