/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.common.es.ESBaseData;
import com.zzsn.common.es.ElasticsearchClientConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchClient {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchClient.class);
    @Resource
    ElasticsearchClientConfig elasticsearchClientConfig;
    @Resource(name="restHighLevelClientEs")
    RestHighLevelClient client;
    public static final String textExtract = "textExtract";

    public String getIndex() {
        return this.elasticsearchClientConfig.getIndexs();
    }

    public Map<String, Object> getEsInfo() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            MainResponse response = this.client.info(RequestOptions.DEFAULT);
            String clusterName = response.getClusterName();
            String clusterUuid = response.getClusterUuid();
            String nodeName = response.getNodeName();
            MainResponse.Version version = response.getVersion();
            String buildDate = version.getBuildDate();
            String buildFlavor = version.getBuildFlavor();
            String buildHash = version.getBuildHash();
            String buildType = version.getBuildType();
            String luceneVersion = version.getLuceneVersion();
            String minimumIndexCompatibilityVersion = version.getMinimumIndexCompatibilityVersion();
            String minimumWireCompatibilityVersion = version.getMinimumWireCompatibilityVersion();
            String number = version.getNumber();
            map.put("clusterName", clusterName);
            map.put("clusterUuid", clusterUuid);
            map.put("nodeName", nodeName);
            map.put("version", version);
            map.put("buildDate", buildDate);
            map.put("buildFlavor", buildFlavor);
            map.put("buildHash", buildHash);
            map.put("buildType", buildType);
            map.put("luceneVersion", luceneVersion);
            map.put("minimumIndexCompatibilityVersion", minimumIndexCompatibilityVersion);
            map.put("minimumWireCompatibilityVersion", minimumWireCompatibilityVersion);
            map.put("number", number);
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    public boolean indexCreate(String index) {
        try {
            if (!this.indexExist(index)) {
                CreateIndexRequest request = new CreateIndexRequest(index);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                log.info(createIndexResponse.isAcknowledged() ? "\u521b\u5efa\u7d22\u5f15[{}]\u6210\u529f" : "\u521b\u5efa\u7d22\u5f15[{}]\u5931\u8d25", (Object)index);
                return createIndexResponse.isAcknowledged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean indexExist(String ... indices) {
        GetIndexRequest request = new GetIndexRequest(indices);
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean deleteIndex(String index) {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        AcknowledgedResponse delete = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return delete.isAcknowledged();
    }

    public void docGet(String index, String id) {
        try {
            GetRequest getRequest = new GetRequest(index, id);
            GetResponse documentFields = this.client.get(getRequest, RequestOptions.DEFAULT);
            Map sourceAsMap = documentFields.getSourceAsMap();
            System.out.println(documentFields.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean docExists(String index, String id) {
        GetRequest request = new GetRequest(index, id);
        request.fetchSourceContext(new FetchSourceContext(false));
        request.storedFields(new String[]{"_none_"});
        boolean exists = this.client.exists(request, RequestOptions.DEFAULT);
        return exists;
    }

    public void docSavaBulk(String index, List<ESBaseData> list) {
        BulkRequest request = new BulkRequest();
        request.timeout(TimeValue.timeValueMinutes((long)10L));
        for (int i = 0; i < list.size(); ++i) {
            ESBaseData b = list.get(i);
            request.add(new IndexRequest(index).id(b.getId()).source(JSON.toJSONString((Object)list.get(i)), XContentType.JSON));
        }
        try {
            BulkResponse bulk = this.client.bulk(request, RequestOptions.DEFAULT);
            for (BulkItemResponse response : bulk.getItems()) {
                if (response.isFailed()) {
                    log.info("\u6279\u91cf\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", new Object[]{response.getIndex(), response.getId(), response.getFailureMessage()});
                    continue;
                }
                log.info("\u6279\u91cf\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u4fdd\u5b58\u6210\u529f,\u72b6\u6001[{}],version[{}]", new Object[]{response.getIndex(), response.getId(), response.status(), response.getVersion()});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u6279\u91cf[{}]\u4fdd\u5b58\u5931\u8d25", (Object)index);
        }
    }

    public void docSavaBulkAsync(final String index, List<ESBaseData> list) {
        BulkRequest request = new BulkRequest();
        request.timeout(TimeValue.timeValueMinutes((long)10L));
        for (int i = 0; i < list.size(); ++i) {
            ESBaseData b = list.get(i);
            request.add(new IndexRequest(index).id(b.getId()).source(JSON.toJSONString((Object)list.get(i)), XContentType.JSON));
        }
        this.client.bulkAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkItemResponses) {
                for (BulkItemResponse response : bulkItemResponses.getItems()) {
                    if (response.isFailed()) {
                        log.info("\u6279\u91cf\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", new Object[]{response.getIndex(), response.getId(), response.getFailureMessage()});
                        continue;
                    }
                    log.info("\u6279\u91cf\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u4fdd\u5b58\u6210\u529f,\u72b6\u6001[{}],version[{}]", new Object[]{response.getIndex(), response.getId(), response.status(), response.getVersion()});
                }
            }

            public void onFailure(Exception e) {
                log.warn("\u6279\u91cf[{}]\u4fdd\u5b58\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", (Object)index, (Object)e.getMessage());
            }
        });
    }

    public String docSavaByEntity(String index, String id, Object object) {
        return this.docSaveByJson(index, id, JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public void docSavaByEntityAsync(String index, String id, Object object) {
        this.docSaveByJsonAsync(index, id, JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public String docSaveByJson(String index, String id, String jsonStr) {
        try {
            IndexRequest request = new IndexRequest(index).id(id).source(jsonStr, XContentType.JSON);
            IndexResponse indexResponse = this.client.index(request, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (IOException e) {
            log.warn("\u540c\u6b65\u4fdd\u5b58doc\u5931\u8d25, _index=[{}], _id=[{}], _body=[{}]", new Object[]{index, id, jsonStr});
            e.printStackTrace();
            return index;
        }
    }

    public void docSaveByJsonAsync(final String index, final String id, final String jsonStr) {
        final IndexRequest request = new IndexRequest(index);
        request.id(id);
        request.source(jsonStr, XContentType.JSON);
        this.client.indexAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                log.info("\u4fdd\u5b58doc, _index=[{}], _id=[{}]\u6210\u529f, _version=[{}], _result=[{}]", new Object[]{index, indexResponse.getId(), indexResponse.getVersion(), indexResponse.getResult()});
            }

            public void onFailure(Exception e) {
                e.printStackTrace();
                log.warn("\u5f02\u6b65\u4fdd\u5b58\u5931\u8d25\uff0c\u5c1d\u8bd5\u540c\u6b65\u65b9\u5f0f\u4fdd\u5b58doc, ex=[{}]", (Object)e.getMessage());
                try {
                    IndexResponse response = ElasticSearchClient.this.client.index(request, RequestOptions.DEFAULT);
                    DocWriteResponse.Result result = response.getResult();
                    if (result != DocWriteResponse.Result.UPDATED && result != DocWriteResponse.Result.CREATED) {
                        log.warn("\u540c\u6b65\u4fdd\u5b58doc\u5931\u8d25,_index=[{}], _id=[{}], _body=[{}]", new Object[]{index, id, jsonStr});
                    }
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        });
    }

    public String docSaveByMap(String index, String id, Map<String, Object> map) {
        try {
            IndexRequest request = new IndexRequest(index).id(id).source(map);
            IndexResponse indexResponse = this.client.index(request, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return index;
        }
    }

    public String docSaveByJSIONObject(String index, String id, JSONObject object) {
        IndexRequest request = new IndexRequest(index);
        request.id(id);
        try {
            request.source(JSON.toJSONString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.client.index(request, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean docDeleteById(String index, String id) {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(index, id);
            DeleteResponse delete = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
            if (delete.status() == RestStatus.OK) {
                log.info("DELETE /{}/_doc/{}/\r\n", (Object)index, (Object)id);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void docDeleteByIdAsync(final String index, final String id) {
        DeleteRequest request = new DeleteRequest(index, id);
        try {
            this.client.deleteAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    log.info("\u5220\u9664doc\u6210\u529f, _index=[{}], _id=[{}]", (Object)index, (Object)deleteResponse.getId());
                }

                public void onFailure(Exception e) {
                    e.printStackTrace();
                    log.warn("\u5220\u9664doc\u5931\u8d25, _index=[{}], _id=[{}]", (Object)index, (Object)id);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void docDeleteBulk(String index, List<ESBaseData> list) {
        BulkRequest request = new BulkRequest();
        request.timeout(TimeValue.timeValueMinutes((long)10L));
        for (int i = 0; i < list.size(); ++i) {
            ESBaseData b = list.get(i);
            request.add(new DeleteRequest(index, b.getId()));
        }
        try {
            BulkResponse bulk = this.client.bulk(request, RequestOptions.DEFAULT);
            for (BulkItemResponse response : bulk.getItems()) {
                if (response.isFailed()) {
                    log.info("\u6279\u91cf\u5220\u9664[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", new Object[]{response.getIndex(), response.getId(), response.getFailureMessage()});
                    continue;
                }
                log.info("\u6279\u91cf\u5220\u9664[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u5220\u9664\u6210\u529f,\u72b6\u6001[{}],version[{}]", new Object[]{response.getIndex(), response.getId(), response.status(), response.getVersion()});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u6279\u91cf[{}]\u5220\u9664\u5931\u8d25", (Object)index);
        }
    }

    public void docDeleteBulkAsync(final String index, List<ESBaseData> list) {
        BulkRequest request = new BulkRequest();
        request.timeout(TimeValue.timeValueMinutes((long)10L));
        for (int i = 0; i < list.size(); ++i) {
            ESBaseData b = list.get(i);
            request.add(new DeleteRequest(index, b.getId()));
        }
        this.client.bulkAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkItemResponses) {
                for (BulkItemResponse response : bulkItemResponses.getItems()) {
                    if (response.isFailed()) {
                        log.info("\u5220\u9664\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", new Object[]{response.getIndex(), response.getId(), response.getFailureMessage()});
                        continue;
                    }
                    log.info("\u5220\u9664\u4fdd\u5b58[{}]\u8fc7\u7a0b\u4e2d,id\u4e3a[{}]\u7684\u5220\u9664\u6210\u529f,\u72b6\u6001[{}],version[{}]", new Object[]{response.getIndex(), response.getId(), response.status(), response.getVersion()});
                }
            }

            public void onFailure(Exception e) {
                log.warn("\u6279\u91cf[{}]\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0[{}]", (Object)index, (Object)e.getMessage());
            }
        });
    }

    public Long docDeleteByQuery(String index, QueryBuilder query) {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
            request.setQuery(query).setRefresh(true);
            BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
            return bulkByScrollResponse.getDeleted();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean docUpdateById(String index, String id, String jsonStr) {
        UpdateRequest request = new UpdateRequest(index, id);
        request.doc(jsonStr, XContentType.JSON);
        try {
            UpdateResponse response = this.client.update(request, RequestOptions.DEFAULT);
            return response.status() == RestStatus.OK;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u66f4\u65b0doc\u5931\u8d25, _index=[{}], _id=[{}],_jsonStr=[{}]", new Object[]{index, id, jsonStr});
            return false;
        }
    }

    public Map<String, Object> searchDoc(String index, String id) {
        try {
            GetRequest searchRequest = new GetRequest(index, id);
            GetResponse documentFields = this.client.get(searchRequest, RequestOptions.DEFAULT);
            Map sourceAsMap = documentFields.getSourceAsMap();
            return sourceAsMap;
        }
        catch (IOException e) {
            log.warn("\u67e5\u8be2doc\u5f02\u5e38\uff0cindex=[{}],id=[{}], ex=[{}]", new Object[]{index, id, e.getMessage()});
            return null;
        }
    }

    public Map<String, Object> searchByQuery(String index, int start, int size, QueryBuilder queryBuilder) {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            SearchRequest searchRequest = new SearchRequest(new String[]{index});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            if (queryBuilder != null) {
                searchSourceBuilder.query(queryBuilder);
            }
            if (start >= 0 && size >= 0) {
                searchSourceBuilder.from(start);
                searchSourceBuilder.size(size);
            }
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Long total = hits.getTotalHits().value;
            resultMap.put("total", total);
            SearchHit[] searchHits = hits.getHits();
            ArrayList<Map> mapList = new ArrayList<Map>(searchHits.length);
            for (SearchHit hit : searchHits) {
                Map sourceAsMap = hit.getSourceAsMap();
                sourceAsMap.put("score", Float.valueOf(hit.getScore()));
                mapList.add(sourceAsMap);
            }
            resultMap.put("data", mapList);
            return resultMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Page<Map<String, Object>> searchPageByQuery(String index, int pageNo, int pageSize, BoolQueryBuilder boolQueryBuilder) {
        try {
            HashMap resultMap = new HashMap();
            SearchRequest searchRequest = new SearchRequest(new String[]{index});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.trackTotalHits(true);
            if (boolQueryBuilder != null) {
                searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            }
            if (pageNo >= 0 && pageSize >= 0) {
                searchSourceBuilder.from((pageNo - 1) * pageSize);
                searchSourceBuilder.size(pageSize);
            }
            searchRequest.source(searchSourceBuilder);
            long t1 = System.currentTimeMillis();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            log.debug("\u5904\u7406\u67e5\u8be2\uff1a" + boolQueryBuilder.toString() + ";\n\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1));
            SearchHits hits = searchResponse.getHits();
            Long total = hits.getTotalHits().value;
            SearchHit[] searchHits = hits.getHits();
            ArrayList<Map> mapList = new ArrayList<Map>(searchHits.length);
            for (SearchHit hit : searchHits) {
                Map sourceAsMap = hit.getSourceAsMap();
                sourceAsMap.put("id", hit.getId());
                sourceAsMap.put("score", Float.valueOf(hit.getScore()));
                mapList.add(sourceAsMap);
            }
            resultMap.put("data", mapList);
            Page page = new Page((long)((pageNo - 1) * pageSize + 1), (long)pageSize);
            page.setTotal(total.longValue());
            page.setRecords(mapList);
            return page;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

