package com.zzsn.modules.kgj.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 网址分类中间表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Data
@TableName("CIS_ANA_CAM")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="CIS_ANA_CAM对象", description="事件聚合表")
@KeySequence("seq_caminfo")
public class CamInfo implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(value = "ID",type = IdType.INPUT)
    @ApiModelProperty(value = "主键")
    private Long id;

	@Excel(name = "事件名称", width = 255)
    @ApiModelProperty(value = "事件名称")
    @TableField("EVENT_NAME")
    private String eventName;

	@Excel(name = "资讯id", width = 4000)
    @ApiModelProperty(value = "资讯id")
    @TableField("EVENT_BID")
    private String eventBid;

	@Excel(name = "资讯数量", width = 255)
    @ApiModelProperty(value = "资讯数量")
    @TableField("EVENT_COUNT")
    private String eventCount;

    @Excel(name = "创建时间", width = 4000)
    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME")
    private String createTime;

}
