package com.zzsn.modules.kgj.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import com.zzsn.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 网址分类中间表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Data
@TableName("cis_col_site_type_mid")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="cis_col_site_type_mid对象", description="网址分类中间表")
@KeySequence("seq_cis_col_site_type_mid")
public class SiteTypeMid implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(value = "ID",type = IdType.INPUT)
    @ApiModelProperty(value = "主键")
    private Long id;
	/**网址ID*/
	@Excel(name = "网址ID", width = 15)
    @ApiModelProperty(value = "网址ID")
    @TableField("SITEID")
    private String siteId;
	/**网址类别ID*/
	@Excel(name = "网址类别ID", width = 15)
    @ApiModelProperty(value = "网址类别ID")
    @TableField("TYPEID")
    private Long typeId;
}
