package com.zzsn.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.entity.CesSysWeb;
import com.zzsn.mapper.CesSysWebMapper;
import com.zzsn.service.ICesSysWebService;
import org.springframework.stereotype.Service;

/**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
@Service
public class CesSysWebServiceImpl extends ServiceImpl<CesSysWebMapper, CesSysWeb> implements ICesSysWebService {

    @Override
    public boolean isExist(CesSysWeb cesSysWeb) {
        QueryWrapper<CesSysWeb> wrapper = new QueryWrapper<>();
        wrapper.eq("URL",cesSysWeb.getUrl());
        if (cesSysWeb.getId() != null) {
            wrapper.ne("id", cesSysWeb.getId());
        }
        int count = count(wrapper);
        return count(wrapper) > 0;
    }
}
