package com.zzsn.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

@Data
@TableName(value = "CIS_SUBJECT")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Subject implements Serializable {

    /*
    id
     */

    String id;
    /*
    专题名称
     */
    String title;
    /*
    专题动态
     */

    @TableField(value="suject_dy",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String sujectDy;
    /*
   观点分析
    */
    @TableField(value="point_analysis",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String pointAnalysis;
    /*
   事件脉络
    */
    @TableField(value="event_context",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String eventContext;
    /*
   传播路径
    */
    @TableField(value="propagation_path",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String propagationPath;
    /*
   统计分析
    */
    @TableField(value="statistic_analysis",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String statisticAnalysis;

    /*
    热词动态
    */
    @TableField(value="hot_words",exist = false,typeHandler = org.apache.ibatis.type.BlobTypeHandler.class)
    String hotWords;
}
