/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 0};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSetUTF(int n2) {
        super(n2);
        this.rep = 2;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, 0, nArray, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetUTF.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        return CharacterSetUTF.stringToUTF(string);
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        return CharacterSetUTF.stringToUTF(string);
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 2) {
            byArray2 = CharacterSetUTF.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSetUTF.stringToUTF(string);
        }
        return byArray2;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 >= n4) {
            CharacterSetUTF.failUTFConversion();
        }
        if ((n2 = CharacterSetUTF.getUTFByteLength(by = byArray[n3])) == 0 || n3 + (n2 - 1) >= n4) {
            CharacterSetUTF.failUTFConversion();
        }
        if (n2 == 3 && CharacterSetUTF.isHiSurrogate(by, byArray[n3 + 1]) && n3 + 5 < n4) {
            n2 = 6;
        }
        try {
            char[] cArray = new char[2];
            int[] nArray = new int[]{n2};
            int n5 = CharacterSet.convertUTFBytesToJavaChars(byArray, n3, cArray, 0, nArray, false);
            characterWalker.next += n2;
            if (n5 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (SQLException sQLException) {
            CharacterSetUTF.failUTFConversion();
            return 0;
        }
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3;
        if ((n2 & 0xFFFF0000) != 0) {
            CharacterSetUTF.need(characterBuffer, 6);
            char[] cArray = new char[]{(char)(n2 >>> 16), (char)n2};
            n3 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 2);
        } else {
            CharacterSetUTF.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            n3 = CharacterSet.convertJavaCharsToUTFBytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 1);
        }
        characterBuffer.next += n3;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    private static boolean isHiSurrogate(byte by, byte by2) {
        return by == -19 && by2 >= -96;
    }

    @Override
    public int encodedByteLength(String string) {
        return CharacterSet.stringUTFLength(string);
    }

    @Override
    public int encodedByteLength(char[] cArray) {
        return CharacterSet.charArrayUTF8Length(cArray);
    }
}

