package com.zzsn.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.*;
import java.util.Properties;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    /**
     * 获取resource下的文件内容
     *
     * @param path
     * @return
     */
    public static String getMaxId(String path) throws IOException {
        logger.info("从txt文件中获取上一次的ID最大值", path);
        //jar方式不行
//        File file = new File(ResourceUtils.getURL("classpath:").getPath());
//        String absolutePath = file.getAbsolutePath();
//        String s = absolutePath.replace("target\\classes","");
//        String s = new File(ResourceUtils.getURL("classpath:").getPath()).getParentFile().getParent();
        Properties properties = System.getProperties();
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>系统：" + properties.getProperty("os.name"));
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>根路径" + properties.getProperty("user.dir"));

        String s = properties.getProperty("user.dir");
        if (properties.getProperty("os.name").toLowerCase().contains("win")) {
            s += "\\";
        }else {
            s += "/";
        }
//        将符号“\\”和“\”替换成“/”,有时候便于统一的处理路径的分隔符,避免同一个路径出现两个或三种不同的分隔符
        path = (s+path).replace("\\", "/").replace("\\\\", "/");;
        logger.info("config.txt的path路径为{}",path);
        if (StringUtils.isBlank(path)) {
            logger.info("文件路径为空");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream =null;
        try {
//            ClassPathResource classPathResource = new ClassPathResource(path);
//            inputStream = classPathResource.getInputStream();
            inputStream = new FileInputStream(path);
            byte[] bytes = new byte[1024];
            int lenth;
            while ((lenth = inputStream.read(bytes)) != -1) {
                stringBuilder.append(new String(bytes, 0, lenth));
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("读取文件错误");
        }finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    /**
     * 更新文件内容
     *
     * @param path
     * @param content
     */
    public static void updateId(String path, String content) throws IOException {
        logger.info("更新txt中的maxId的值", content);
        if (StringUtils.isBlank(path)) {
            logger.info("文件路径为空");
        }
//        File file = new File(ResourceUtils.getURL("classpath:").getPath());
//        String absolutePath = file.getAbsolutePath();
//        String s = absolutePath.replace("target\\classes","");
//        String s = new File(ResourceUtils.getURL("classpath:").getPath()).getParentFile().getParent();
//        将符号“\\”和“\”替换成“/”,有时候便于统一的处理路径的分隔符,避免同一个路径出现两个或三种不同的分隔符
        Properties properties = System.getProperties();
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>系统：" + properties.getProperty("os.name"));
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>根路径" + properties.getProperty("user.dir"));

        String s = properties.getProperty("user.dir");
        if (properties.getProperty("os.name").toLowerCase().contains("win")) {
            s += "\\";
        }else {
            s += "/";
        }
        path = (s+path).replace("\\", "/").replace("\\\\", "/");;
        BufferedWriter bufferedWriter =null;
        try {
//            File file = new ClassPathResource(path).getFile();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
            bufferedWriter.write(content);

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("文件不存在");
        }finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }

    }

    public static void read(String path) throws IOException {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
//            inputStream= getClass().getClassLoader().getResourceAsStream("sensitiveWords.dat");
            inputStream = new ClassPathResource(path).getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String txt;
            while ((txt = bufferedReader.readLine()) != null) {
                // do more
            }
        } catch (Exception e) {
            logger.error("文件不存在", e);
        } finally {
            bufferedReader.close();
            inputStream.close();
        }
    }
}
