package com.zzsn.service.impl;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zzsn.constant.PageConstant;
import com.zzsn.entity.Basedata;
import com.zzsn.entity.BasedataType;
import com.zzsn.mapper.BaseDataTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class DataTypeSyncServiceImpl extends ServiceImpl<BaseDataTypeMapper, BasedataType>  {
    private Logger logger = LoggerFactory.getLogger(DataTypeSyncServiceImpl.class);
    @Autowired
    private BaseDataTypeMapper dataTypeMapper;

    /**
     * 同步数据
     */
    public List<BasedataType> processSync(Long maxId, List<String> repeatIDList, List<Basedata> data){
        logger.info("开始同步basedataType:maxId:[{}],重复数据：[{}]",maxId,repeatIDList);
        //2.查询数据库basedataType表新增的数据
        List<BasedataType> basedataList = query(maxId,data);
        if(!(basedataList.size()>0)){
            //如果新增加的数据为0，不处理，直接返回。
            return new ArrayList<>();
        }
        //3.先处理重复数据
        List<BasedataType> resultList = new ArrayList<>();
        if(repeatIDList !=null && repeatIDList.size()>0){
            Map<Long, BasedataType> map = basedataList.stream()
                    .collect(Collectors.toMap(BasedataType::getBid, BasedataType -> BasedataType));
            for (String s : repeatIDList) {
                map.remove(new Long(s));
            }
            resultList = new ArrayList<>(map.values());
        }else{
            resultList = basedataList;
        }
        //去重ID


        return resultList;
    }

    /**
     * 插入数据到科工局数据库中
     * @param list
     */
//    @DS("slave")
//    @Transactional()
//    public int insertBatch(List<BasedataType> list ){
//        logger.info("批量插入新的数据到科工局数据库中",list);
//        //批量插入新的数据到科工局数据库中
//        int i = dataTypeMapper.insertList(list);
//        return i;
//    }
    /**
     * 查询公司数据库中新增的数据
     * @param maxId
     * @param data
     * @return
     */
//    @DS("slave")
    public List<BasedataType> query(Long maxId, List<Basedata> data){
        logger.info("查询公司数据库basedataType新增数据{}",maxId);
//        PageHelper.startPage(PageConstant.page, PageConstant.pageSize);
        if(CollectionUtils.isEmpty(data)){
            return new ArrayList<BasedataType>();
        }
        //bid列表
        List<String> bidList = data.stream().map(basedata -> {
                return basedata.getId();
            }).collect(Collectors.toList());
        List<BasedataType> basedataList = dataTypeMapper.queryByCondition(maxId,bidList);
        return basedataList;
    }
}
