/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16LE
extends CharacterSet
implements CharacterRepConstants {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSetAL16UTF16LE(int n2) {
        super(n2);
        this.rep = 5;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray, n2, cArray, 0, n3, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray, n2, cArray, 0, n3, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetAL16UTF16LE.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 5) {
            byArray2 = CharacterSetAL16UTF16LE.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
        }
        return byArray2;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 + 2 >= n3) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        }
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        int n4 = by << 8 & 0xFF00 | by2;
        characterWalker.next = n2;
        return n4;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if (n2 > 65535) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        } else {
            CharacterSetAL16UTF16LE.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 & 0xFF);
        }
    }
}

