package com.zzsn.utils;

import lombok.extern.slf4j.Slf4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Slf4j
public class TimeUtil {

    private static SimpleDateFormat sdf;

    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");


    /**
     * 根据传入时间 获取前几天的开始时间
     *
     * @param date 时间
     * @param period 几
     * @return
     */
    public static String getYesterdayStartTime(Date date,int period) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DATE, - period);
        return format.format(cal.getTime()) + " 23:59:59";
    }

    /**
     * 根据传入时间 获取今天的结束时间
     *
     * @param date
     * @return
     */
    public static String getToDayEndTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return format.format(cal.getTime()) + " 23:59:59";
    }


    /**
     * 根据传入时间 获取前几周周一时间
     *
     * @param date
     * @param period
     * @return
     */
    private static String getBeforeWeekMonday(Date date, int period) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (1 == cal.get(Calendar.DAY_OF_WEEK)) {//判断当前日期是否为周末，因为周末是本周第一天，如果不向后推迟一天的到的将是下周一的零点，而不是本周周一零点
            cal.add(Calendar.DATE, -1);
        }
        cal.add(Calendar.DAY_OF_MONTH, -(7*period));//时间减去 7*period 天  表示前period周
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//Calendar.MONDAY 这个是周一的意思      想获取周几就更换这个

        return format.format(cal.getTime()) + " 00:00:00";
    }

    /**
     * 根据传入时间 获取上周周天时间
     *
     * @param date
     * @return
     */
    private static String getBeforeWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (1 == cal.get(Calendar.DAY_OF_WEEK)) {//判断当前日期是否为周末，因为周末是本周第一天，如果不向后推迟一天的到的将是下周一的零点，而不是本周周一零点
            cal.add(Calendar.DATE, -1);
        }
        cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
        return format.format(cal.getTime()) + " 23:59:59";
    }


    /**
     * 根据传入时间 获取前几月第一天的时间
     *
     * @param date
     * @param period
     * @return
     */
    public static String getBeforeMonthFirstDate(Date date, int period) {
        Calendar c = Calendar.getInstance();
        //设置为指定日期
        c.setTime(date);
        //指定日期月份减去period 表示前period月
        c.add(Calendar.MONTH, -period);
        //指定日期月份减去一后的 获取第一天
        c.set(Calendar.DAY_OF_MONTH, c.getActualMinimum(Calendar.DAY_OF_MONTH));
        //获取最终的时间
        Date lastDateOfPrevMonth = c.getTime();
        return format.format(lastDateOfPrevMonth) + " 00:00:00";
    }

    /**
     * 根据传入时间 获取上月最后一天一时间
     *
     * @param date
     * @return
     */
    public static String getBeforeMonthEndDate(Date date) {
        Calendar c = Calendar.getInstance();
        //设置为指定日期
        c.setTime(date);
        c.set(Calendar.DAY_OF_MONTH, 0);
        Date beforeDay = c.getTime();
        return format.format(beforeDay) + " 23:59:59";
    }

    /**
     * 字符串转换成日期
     *
     * @param string
     * @return
     * @throws ParseException
     */
    public static Date stringToDate(String string) throws ParseException {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(string);
    }

    /**
     * 日期转换成字符串
     *
     * @param date
     * @return
     */
    public static String dateToString(Date date) {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    /**
     * 获取时间的日期
     *
     * @param date
     * @return
     */
    public static String getDate(Date date){
        return format.format(date);
    }

    /**
     * 获取某一时间的小时
     * @param date 某一时间
     * @return 小时
     */
    public static int getHour(String date) throws ParseException {
        Calendar c = Calendar.getInstance();
        //设置为指定日期
        c.setTime(sdf.parse(date));
        int hour = c.get(Calendar.HOUR_OF_DAY);
        return hour;
    }

    /**
     * 获取两个日期之间的天数
     * @param earlyDateStr
     * @param lateDateStr
     * @return
     * @throws ParseException
     */
    private static int daysBetween(String earlyDateStr, String lateDateStr) throws ParseException {
        Date earlyDate = stringToDate(earlyDateStr);
        Date lateDate = stringToDate(lateDateStr);
        Calendar early = Calendar.getInstance();
        Calendar late = Calendar.getInstance();
        early.setTime(earlyDate);
        late.setTime(lateDate);
        early.set(Calendar.HOUR_OF_DAY, 0);
        early.set(Calendar.MINUTE, 0);
        early.set(Calendar.SECOND, 0);
        late.set(Calendar.HOUR_OF_DAY, 24);
        late.set(Calendar.MINUTE, 0);
        late.set(Calendar.SECOND, 0);
        //得到两个日期相差的天数
//         int days = ((int) (caled.getTime().getTime() / 1000) - (int) (calst
//                .getTime().getTime() / 1000)) / 3600 / 24;
        //得到两个日期相差的 毫秒
        return (int) (late.getTime().getTime() - early.getTime().getTime());
    }

    /**
     * 获取传入日期几天后的日期时间
     * @param date：传入日期
     * @param day：往后推的天数
     * @return
     */
    public static Date afterDate(Date date, int day){
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(Calendar.DATE,instance.get(Calendar.DATE)+day);
        return instance.getTime();
    }
    /**
     * 获取传入日期几天后的日期时间
     * @param date：传入日期
     * @param day：往后推的天数
     * @param format：格式化，如：yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static String afterDate(Date date, int day, String format){
        SimpleDateFormat simpleFormat= new SimpleDateFormat(format);
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(Calendar.DATE,instance.get(Calendar.DATE)+day);
        return simpleFormat.format(instance.getTime());
    }
}
