package com.zzsn.test;

import com.zzsn.constant.PageConstant;
import com.zzsn.entity.*;
import com.zzsn.mapper.BaseDataImageMapper;
import com.zzsn.mapper.CesSysSecretMapper;
import com.zzsn.service.ICesSysWebService;
import com.zzsn.service.impl.DataSyncServiceImpl;
import com.zzsn.service.impl.DataTypeSyncServiceImpl;
import com.zzsn.utils.FileUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@RestController
public class Test {
    private Logger logger =  LoggerFactory.getLogger(Test.class);
    @Autowired
    private DataSyncServiceImpl dataSyncService;
    @Autowired
    private DataTypeSyncServiceImpl dataTypeSyncService;
    @Autowired
    private BaseDataImageMapper imageMapper;
    @Autowired
    private CesSysSecretMapper cesSysSecretMapper;
    @Autowired
    private ICesSysWebService webService;
    @GetMapping("/test")
    public void test() throws IOException {
        String jar_parent = new File(ResourceUtils.getURL("classpath:").getPath()).getParentFile().getParentFile().getParent();
        System.out.println(jar_parent);
        //1.获取上一次的ID最大值
        String s = FileUtil.getMaxId(PageConstant.path);
        String str = s.substring(s.lastIndexOf("=")+1);
        Long maxId = new Long(str);
        if(maxId == null){
            logger.info("txt文件中最大值ID错误");
            throw new RuntimeException("配置文件中的最大值ID错误");
        }
        //2.获取basedata表重复的数据和表中要插入的数据
        Map<String, Object> map = dataSyncService.repeat(maxId);

        //重复数据
        List<String> repeatList = (List<String>) map.get("repeat");


        //3.获取basedataType要同步到数据库的数据
        List<BasedataType> typeList = dataTypeSyncService.processSync(maxId, repeatList, null);

        //4.通过密点库对要插入到basedata的信息进行过滤
        Map<String, Object> secretMap =  dataSyncService.secret((List<Basedata>) map.get("data"),typeList);

        //5.插入之前对basedata中的内容包涵图片的进行base64转码
//        List<Basedata> baseData = dataSyncService.imgHandler((List<Basedata>) secretMap.get("data"));


        //6.插入到科工局数据库
        dataSyncService.insertBatch((List<Basedata>) secretMap.get("data"), (List<BasedataType>) secretMap.get("typeData"),null,null,null,null);

        //7.同步到es库中
//        dataSyncService.syncEsData((List<Basedata>) secretMap.get("data"));

        //8.更改txt文件中maxId的值
        if(!StringUtils.isBlank((String) map.get("newMaxId"))){
            String content = "maxId="+map.get("newMaxId");
            logger.info("更新txt文件{}",content);
            FileUtil.updateId(PageConstant.path,content);
        }
    }
    @GetMapping("/content")
    public String getContent(){
        Basedata basedata = dataSyncService.getContent();
        return basedata.getContent();
    }
    @GetMapping("/test2")
    public void test2() throws FileNotFoundException {
        String jar_parent = new File(ResourceUtils.getURL("classpath:").getPath()).getParentFile().getParent();
        System.out.println(jar_parent);
        String path1 = ResourceUtils.getURL("classpath:").getPath();
        System.out.println(path1);
        ClassPathResource classPathResource = new ClassPathResource("application.yml");
        String path = classPathResource.getPath();
        File file = new File(ResourceUtils.getURL("classpath:").getPath());
        String absolutePath = file.getAbsolutePath();
        System.out.println(absolutePath);
        System.out.println(path);


    }
    @GetMapping("/test3")
    public ResultModel get(){
        List<CesSysSecret> secretList = cesSysSecretMapper.selectByMap(new HashMap<>());
        return ResultModel.OK(secretList);
    }
    @GetMapping("/image")
    public ResultModel getImage(@RequestParam("id") String id){
        return ResultModel.OK(imageMapper.queryById(id));
    }

    public static void main(String[] args) throws IOException {
//        DataSyncServiceImpl dataSyncService = new DataSyncServiceImpl();
//        DataTypeSyncServiceImpl dataTypeSyncService = new DataTypeSyncServiceImpl();
//        String path ="config.txt";
//        //1.获取上一次的最大值
//        String s = FileUtil.getMaxId(path);
//        String maxId = s.substring(s.lastIndexOf("="));
//        if(StringUtils.isBlank(maxId)){
////            logger.info("最大值ID错误");
//            throw new RuntimeException("配置文件中的最大值ID错误");
//        }
//        //获取重复的数据和basedata表中要插入的数据
//        Map<String, Object> map = dataSyncService.repeat(maxId);
//        //重复数据
//        List<String> repeatList = (List<String>) map.get("repeat");
//        //basedata表中的数据
//        List<Basedata> data = (List<Basedata>) map.get("data");
//        //获取basedataType要同步到数据库的数据
//        List<BasedataType> typeList = dataTypeSyncService.processSync(maxId, repeatList);
//        //插入到科工局数据库
////        dataSyncService.insertBatch(data, typeList);
//        //更改txt文件中maxId的值
//        if(!StringUtils.isBlank((String) map.get("newMaxId"))){
//            String content = "maxId="+map.get("newMaxId");
//            FileUtil.updateId(path,content);
//        }
    }
}
