package com.zzsn.utils;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/**
 * 获取正文中的图片或者文件
 * 创建人：李东亮
 * 创建时间：2016-8-30 下午5:25:04
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0
 *
 */
public class ContentFileFinder {
    /**
     * 获取父路径
     * 创建人:  李东亮
     * 创建时间:  2015-7-6 下午3:17:44
     * @version 1.0
     * @param path
     * @return
     * @throws IOException
     */
    public static String getDirPath(String path) {
        path = path.substring(0, path.lastIndexOf("/")) ;
        return path;
    }

    /**
     * 去除路径中的./
     * 创建人:  李东亮
     * 创建时间:  2015-7-6 下午3:43:00
     * @version 1.0
     * @param currentPageURL,imgPath
     * @return
     * @throws IOException
     */
    public static String formatPath(String currentPageURL,String imgPath) {
        String start="";
        if(currentPageURL.indexOf("http://")!=-1){
            start = "http://";
        }else if(currentPageURL.indexOf("https://")!=-1){
            start = "https://";
        }
        //绝对路径
        if(imgPath.startsWith("/")){
        	//add lihuawei 增加双斜杠判断图片   如果开始时双斜杠就增加http:
        	if(imgPath.startsWith("//")){

                return start+imgPath.replace("//", "");
        	}
            currentPageURL = currentPageURL.replace(start, "");
            int subIndex = currentPageURL.indexOf("/");
            if(subIndex==-1){
                subIndex = currentPageURL.length();
            }
            String domain = currentPageURL.substring(0, subIndex);
            return start+domain+imgPath;
        }

        //相对路径
        String path = currentPageURL+"/"+imgPath;

        path = path.replaceAll(start, "D:/");
        File f = new File(path);
        String filePath="";
        try {
            filePath = f.getCanonicalPath();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        String result = filePath.replaceAll("D:\\\\", start);
        result = result.replaceAll("\\\\", "/");
        return result;
    }
    public static String formatPath1(String currentPageURL,String imgPath) {
        String start="";
        if(currentPageURL.indexOf("http://")!=-1){
            start = "http://";
        }else if(currentPageURL.indexOf("https://")!=-1){
            start = "https://";
        }
        //绝对路径
        if(imgPath.startsWith("/")){
        	//add lihuawei 增加双斜杠判断图片   如果开始时双斜杠就增加http:
        	if(imgPath.startsWith("//")){

                return start+imgPath.replace("//", "");
        	}
            currentPageURL = currentPageURL.replace(start, "");
            int subIndex = currentPageURL.indexOf("/");
            if(subIndex==-1){
                subIndex = currentPageURL.length();
            }
            String domain = currentPageURL.substring(0, subIndex);
            return start+domain+imgPath;
        }

        //相对路径
        String path = currentPageURL+"/"+imgPath;

        path = path.replaceAll(start, "D:/");
        File f = new File(path);
        String filePath="";
        try {
            filePath = f.getCanonicalPath();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        String result = filePath.replaceAll("D:\\\\", start);
        result = result.replaceAll("\\\\", "/");
        return result;
    }

    /**
     * 生成图片文件保存路径
     * 创建人:  李东亮
     * 创建时间:  2016-3-23 下午2:50:33
     * @version 1.0
     * @return
     */
   private static String genImgFileName(String suffix){
       String dir = DateUtil.format(new Date(), "yyyy-MM-dd");
       String uuid = UUID.randomUUID().toString();
       return dir+"/"+uuid+suffix;
   }

   /**
    * 确保有src属性并且src属性指向正确的图片地址
    * 创建人:  李东亮
    * 创建时间:  2016-6-6 下午1:46:03
    * @version 1.0
    * @param imgTag
    * @return
    */
   public static Element ensureSrc(Element imgTag){
      // Document doc =  Jsoup.parseBodyFragment(rawTag);
       String firstSrcAtt=null;
       if(imgTag.hasAttr("original")){
           firstSrcAtt = "original";
       }else if(imgTag.hasAttr("data-src")){
           firstSrcAtt = "data-src";
       }else if(imgTag.hasAttr("_src")){
           firstSrcAtt = "_src";
       }else if(imgTag.hasAttr("src")){
           firstSrcAtt ="src";
       }
       if(firstSrcAtt==null){
           return null;
       }
       imgTag.attr("src", imgTag.attr(firstSrcAtt));
       return imgTag;
   }

  /**
   * 获取图片的绝对路径
   * 创建人:  李东亮
   * 创建时间:  2016-6-6 下午2:05:02
   * @version 1.0
   * @param element
   * @param uri
   * @return
   */
   private static String getAbsolutePath(Element element,String uri,String linkAtt){
       if(element ==null){
           return null;
       }
      String absolutePath = element.attr(linkAtt);
       if(absolutePath.startsWith("data:image")){
           return null;
       }
       if(absolutePath.startsWith("file:")){
           return null;
       }
       if (absolutePath.matches("(?i)^javascript.*|#")) {
           return null;
       }
       if(!absolutePath.startsWith("http://")&&!absolutePath.startsWith("https://")&&uri!=null){
    	   //add lihuawei  jsoup有图片补全功能直接使用，这样拿到的链接都是正确的
    	   element.setBaseUri(uri);
    	   String absolutePath1=         element.absUrl(linkAtt);

           //String puriDir = getDirPath(uri);
           //absolutePath = formatPath(puriDir,absolutePath1);
           return absolutePath1;
       }
       return absolutePath;
   }

   /**
    * 获取后缀名
    * 创建人:  李东亮
    * 创建时间:  2016-8-30 下午5:00:39
    * @version 1.0
    * @param uri
    * @return
    */
   public static String getSuffix(String uri){
       String suffix="";
       uri = uri.replaceAll("http://|https://", "");
       Pattern p = Pattern.compile("/.+(\\.\\w{1,4})$");
       Matcher m =  p.matcher(uri);
       if(m.find()){
           suffix= m.group(1);
       }
       if(uri.contains(".jpg")){
           suffix=".jpg";
       }
       if(uri.contains(".png")){
           suffix=".png";
       }
       if(uri.contains(".jpeg")){
           suffix=".jpeg";
       }
       if(uri.contains(".gif")){
           suffix=".gif";
       }
       return suffix;
   }

    /**
     * 获取正文中的文件标签，包含正文中的图片和附件
     * 创建人:  李东亮
     * 创建时间:  2016-9-8 下午3:01:09
     * @version 1.0
     * @param content
     * @param sourceaddress
     * @return
     */
    public static Map<String,FileTag> getContentFileTag(String content,String sourceaddress){
        Map<String,FileTag> imgMap = new HashMap<String,FileTag>();
        if(content==null||content.length()==0){
            return imgMap;
        }
        String rawTag;
        String absolutePath;
        FileTag fileTag;
        String savePath;
        Document doc = Jsoup.parse(content);
//        Elements imgTags = doc.select("img,a");
//        Elements imgTags = doc.select("img,");
        Elements imgTags = doc.select("img");
        Element imgTag;
        String suffix = "";
        String filePathAttr;
        String preFixPath;
        for (Iterator<Element> iterator = imgTags.iterator(); iterator.hasNext();) {
            fileTag = new FileTag();
            imgTag =  iterator.next();
            rawTag = imgTag.outerHtml();
            if(imgTag.tagName().toLowerCase().equals("img")){
                filePathAttr = "src";
                //使src指向正确的图片显示路径
                imgTag = ensureSrc(imgTag);
                preFixPath="IMG_SERVER/";
            }else
            {
                filePathAttr="href";
                fileTag.setFileName(imgTag.text());
                preFixPath="FILE_SERVER/";
            }
            //获取图片的绝对路径，并且使src指向图片的绝对路径
            absolutePath = getAbsolutePath(imgTag,sourceaddress,filePathAttr);
            if(absolutePath==null){
                continue;
            }
            imgTag.attr(filePathAttr,absolutePath);
            fileTag.setAbsolutePath(absolutePath);
            fileTag.setAbsoluteTag(imgTag.outerHtml());
            //图片保存路径
            suffix = ContentFileFinder.getSuffix(absolutePath);
//            fileTag.setSuffix(suffix.substring(1));
            if(StringUtils.isNotBlank(suffix)){
                fileTag.setSuffix(suffix.substring(1));
            }else{
                fileTag.setSuffix("");
                continue;
            }
            savePath = genImgFileName(suffix);
            fileTag.setSavePath(savePath);
            //图片保存标签
            imgTag.attr(filePathAttr,preFixPath+fileTag.getSavePath());
            fileTag.setSaveTag(imgTag.outerHtml());
            //key为图片完整路径
            imgMap.put(rawTag, fileTag);
        }
        return imgMap;
    }

    /**
     * 获取正文中的文件标签，包含正文中的图片和附件
     * 创建人:  李东亮
     * 创建时间:  2016-9-8 下午3:01:09
     * @version 1.0
     * @param content
     * @param sourceaddress
     * @return
     */
    public static Map<String,FileTag> getContentVideoFileTag(String content,String sourceaddress){
        Map<String,FileTag> videoMap = new HashMap<String,FileTag>();
        if(content==null||content.length()==0){
            return videoMap;
        }
        String rawTag;
        String absolutePath;
        FileTag fileTag;
        String savePath;
        Document doc = Jsoup.parse(content);
        Elements videoTags = doc.select("video");
        Element videoTag;
        String suffix = "";
        String filePathAttr;
        String preFixPath;
        for (Iterator<Element> iterator = videoTags.iterator(); iterator.hasNext();) {
            fileTag = new FileTag();
            videoTag =  iterator.next();
            rawTag = videoTag.outerHtml();
            if(videoTag.tagName().toLowerCase().equals("video")){
                filePathAttr = "src";
                //使src指向正确的图片显示路径
                videoTag = ensureSrc(videoTag);
                preFixPath="IMG_SERVER/";
            }else
            {
                filePathAttr="href";
                fileTag.setFileName(videoTag.text());
                preFixPath="FILE_SERVER/";
            }
            //获取图片的绝对路径，并且使src指向图片的绝对路径
            absolutePath = getAbsolutePath(videoTag,sourceaddress,filePathAttr);
            if(absolutePath==null){
                continue;
            }
            videoTag.attr(filePathAttr,absolutePath);
            fileTag.setAbsolutePath(absolutePath);
            fileTag.setAbsoluteTag(videoTag.outerHtml());
            //图片保存路径
            suffix = ContentFileFinder.getSuffix(absolutePath);
            fileTag.setSuffix(suffix.substring(1));
//            if(StringUtils.isNotBlank(suffix)){
//                fileTag.setSuffix(suffix.substring(1));
//            }else{
//                fileTag.setSuffix("");
//            }
            savePath = genImgFileName(suffix);
            fileTag.setSavePath(savePath);
            //图片保存标签
            videoTag.attr(filePathAttr,preFixPath+fileTag.getSavePath());
            fileTag.setSaveTag(videoTag.outerHtml());
            //key为图片完整路径
            videoMap.put(rawTag, fileTag);
        }
        return videoMap;
    }

    public static void main(String[] args) {
//        String content ="<div> \n" +
//                " <p>    1月3日，中国船舶集团有限公司党组成员、副总经理、中国重工董事长姜仁锋在集团总部会见中国国新控股有限责任公司党委委员、总会计师刘学诗一行。双方围绕继续加强沟通对接和开展有关项目合作进行了座谈交流。 </p> \n" +
//                " <p><img border=\"0\" alt=\"姜仁锋会见中国国新党委委员、总会计师刘学诗 \" src=\"http://www.csicl.com.cn/n332/n337/c16002/part/14810.jpg\"></p> \n" +
//                " <p>    姜仁锋对刘学诗一行的到访表示欢迎，对中国国新为中国船舶集团提供的支持和帮助表示感谢，并简要介绍了中国船舶集团有关产业发展情况。他指出，中国船舶集团正按照高质量发展的要求，聚焦主业实业，聚焦效率效益，努力建设具有国际竞争力的世界一流船舶集团。中国国新是国有资本市场化运作的专业平台，着力支持中央企业深化改革和创新发展。希望双方继续加强沟通对接，发挥各自优势，共同为国有资产保值增值作出更大贡献。 <br> 刘学诗介绍了中国国新有关投资项目的情况。他指出，中国船舶集团是我国船舶工业发展的主力军，发展前景广阔。双方有着良好的合作基础，希望进一步深化有关项目合作，中国国新将发挥自身优势，为中国船舶集团提供更好的服务。 <br>     双方有关部门和单位负责人参加会见。 <br> </p> \n" +
//                "</div>";
//        String content1 ="haha";
//        String url ="http://www.csicl.com.cn/n332/n337/c16002/content.html";
//        Map<String, FileTag> contentFileTag = ContentFileFinder.getContentFileTag(content, url);
////        System.out.println(contentFileTag);
//        FileTag fileTag = contentFileTag.get("<img border=\"0\" alt=\"姜仁锋会见中国国新党委委员、总会计师刘学诗 \" src=\"http://www.csicl.com.cn/n332/n337/c16002/part/14810.jpg\">");
//        String imgUrlToBase64 = ImgBaseUtil.getImgUrlToBase64(fileTag.getAbsolutePath());
////        System.out.println(imgUrlToBase64);
//        String s = HtmlUtils.replaceHtmlTag(content, "img", "src", "src=\"data:image/" + fileTag.getSuffix() + ";base64,", "\"", imgUrlToBase64);
//        System.out.println(s);
//        System.out.println(ContentFileFinder.getSuffix("http://www.baidu.com//a.xls"));
        String s = "<strong>1船试航凯旋</strong> </font><br> <img border=\"0\" alt=\"\" src=\"http://www.csicl.com.cn/n332/n334/c16543/part/15932.jpg\"></p> \n" +
                " <p>    3月23日，武船集团北船重工为工银金融租赁有限公司";

        String s1 ="http://www.csicl.com.cn/n332/n334/c16543/part/15932.jpg";
        String s2="<img src=\""+s1+"\">";
        String replace = s.replace("<img border=\"0\" alt=\"\" src=\"http://www.csicl.com.cn/n332/n334/c16543/part/15932.jpg\">", s2);
        System.out.println(replace);
    }
}
