package com.zzsn.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.zzsn.constant.PageConstant;
import com.zzsn.entity.*;
import com.zzsn.mapper.BaseDataMapper;
import com.zzsn.mapper.BaseDataTypeMapper;
import com.zzsn.mapper.SubjectMapper;
import com.zzsn.service.BaseDataService;
import com.zzsn.service.SubjectService;
import com.zzsn.service.impl.DataSyncServiceImpl;
import com.zzsn.service.impl.DataTypeSyncServiceImpl;
import com.zzsn.utils.DateUtil;
import com.zzsn.utils.FileUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.client.RestTemplate;

@Component
@EnableScheduling
//@Async
public class DataSyncTask {
    private Logger logger = LoggerFactory.getLogger(DataSyncTask.class);
    @Autowired
    private DataSyncServiceImpl dataSyncService;

    @Autowired
    private DataTypeSyncServiceImpl dataTypeSyncService;


    @Autowired
    private BaseDataService baseDataService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private SubjectMapper subjectMapper;

    @Autowired
    private BaseDataMapper dataMapper;
    @Autowired
    private BaseDataTypeMapper dataTypeMapper;

    @Value("excelpath")
    String excelpath;
    @Autowired
    private Environment environment;
    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        return new PropertySourcesPlaceholderConfigurer();//  //使spring能够识别 ${cron}
    }
    /**
     * 默认是fixedDelay 上一次执行完毕时间后执行下一轮
     */
    @Scheduled(cron = "${cron}")
    public void run() throws InterruptedException, IOException {
        logger.info("开始同步数据------------------------>");
        //1.获取上一次的ID最大值
        String s = FileUtil.getMaxId(PageConstant.path).replace("\r\n","");
        String str = s.substring(s.lastIndexOf("=")+1);
        Long maxId = new Long(str);
        if(maxId == null){
            logger.info("txt文件中最大值ID错误");
            throw new RuntimeException("配置文件中的最大值ID错误");
        }
        //2.获取basedata表重复的数据和表中要插入的数据
         Map<String, Object> map = dataSyncService.repeat(maxId);

        //重复数据
        List<String> repeatList = (List<String>) map.get("repeat");

        //basedata表中的数据
        List<Basedata> data = (List<Basedata>) map.get("data");
        try{
            //3.获取basedataType要同步到数据库的数据
            List<BasedataType> typeList = dataTypeSyncService.processSync(maxId, repeatList,data);

            //重新复制ID
            for (Basedata basedata : data) {
                String bid = this.baseDataService.getserialno().toString();
                logger.info("生成的bid"+bid);
                for (BasedataType basedataType : typeList) {
                    if (basedataType.getBid().compareTo(Long.valueOf(basedata.getId())) == 0) {
                        basedataType.setBid(Long.valueOf(bid));
                    }
                }
                basedata.setId(bid);
            }


            //4.插入之前对basedata中的内容包含图片的进行base64转码，先不改变原content中src的内容
            Map<String, Object> map1 = dataSyncService.imgHandler((List<Basedata>) map.get("data"));
            //插入之前对basedata中的内容包含视频的进行base64转码，先不改变原content中src的内容
            //对视频进行下载，在表里记录id，视频路径，资讯id 视频是通过aria2c 来进行下载 异步下载
//            Map<String, Object> map2 = dataSyncService.videoHandler((List<Basedata>) map1.get("basedata"));
            Map<String, Object> map2 = dataSyncService.videoHandler(map1);

            //5.通过密点库对要插入到basedata的信息进行过滤
//            Map<String, Object> secretMap =  dataSyncService.secret((List<Basedata>) map2.get("basedata"),typeList);
//            Map<String, Object> secretMap =  dataSyncService.secret((List<Basedata>) map1.get("basedata"),typeList);

            //6.对文章内容中的地区进行抽取
            logger.info("6.对文章内容中的地区进行抽取[{}]",maxId);
//            Map<String, Object> localMap = dataSyncService.getLocal((List<Basedata>) secretMap.get("data"),(Map<String,Long>)secretMap.get("secretLevelMap"));
//            List<Basedata> list = (List<Basedata>)secretMap.get("data");
//            List<BasedataType> basedataTypeList = (List<BasedataType>)secretMap.get("typeData");

//            for (Basedata basedata : list) {
//                String bid = this.baseDataService.getserialno().toString();
//                for (BasedataType basedataType : basedataTypeList) {
//                    if (basedataType.getBid().compareTo(Long.valueOf(basedata.getId())) == 0) {
//                        basedataType.setBid(Long.valueOf(bid));
//                    }
//                }
//                basedata.setId(bid);
//            }
            //7.插入到科工局数据库
            logger.info("7.插入到科工局数据库[{}]",maxId);
            try {
//                dataSyncService.insertBatch((List<Basedata>) secretMap.get("data"), (List<BasedataType>) secretMap.get("typeData"),
//                        (List<BaseDataImage>) map1.get("imageList"), (List<CesSysWeb>) localMap.get("exitWebList")
//                        , (List<CesSysWeb>) localMap.get("newWebList"), (List<BaseDataWebMid>) localMap.get("baseDataWebList"));
                //同步图片
//                dataSyncService.insertBatch((List<Basedata>) map1.get("basedata"), typeList,
//                        (List<BaseDataImage>) map1.get("imageList"), null
//                        , null, null);
                //同步视频
                dataSyncService.insertBatch((List<Basedata>) map2.get("basedata"), typeList,
                        (List<BaseDataImage>) map2.get("imageList"), null
                        , null, null);

            }catch (Exception e){

            }
            //8.同步到es库中
//            dataSyncService.syncEsData((List<Basedata>) secretMap.get("data"));

        }catch (Exception e){
            logger.info("同步数据库出错，上一次最大ID是：[{}],错误是：[{}]",maxId,e.getMessage());
        }
        //8.更改txt文件中maxId的值
        if(!StringUtils.isBlank((String) map.get("newMaxId"))){
            String content = "maxId="+map.get("newMaxId");
            logger.info("更新txt文件{}",content);
            FileUtil.updateId(PageConstant.path,content);
        }
        logger.info("同步结束-------------------------------------->");
    }
    /**fixedRate:上一次开始执行时间点之后5秒再执行*/
//    @Scheduled(fixedRate = 5000)
//    @Scheduled(cron = "${cron}")
    public void run1() throws InterruptedException {
//        Thread.sleep(6000);
//        System.out.println(Thread.currentThread().getName()+"=====>>>>>使用fixedRate  {}"+(System.currentTimeMillis()/1000));
        logger.info("开始同步数据------------------------>");
        //1.获取上一次的ID最大值
        Long maxId = new Long("20092800063268");
        if(maxId == null){
            logger.info("txt文件中最大值ID错误");
            throw new RuntimeException("配置文件中的最大值ID错误");
        }
        //basedata表中的数据
        List<Basedata> data =dataSyncService.query(maxId);
        try{
            //8.同步到es库中
            dataSyncService.syncEsData(data);

        }catch (Exception e){
            logger.info("同步数据库出错，上一次最大ID是：[{}],错误是：[{}]",maxId,e.getMessage());
        }
        logger.info("同步结束-------------------------------------->");
    }

    /**fixedDelay:上一次执行完毕时间点之后5秒再执行*/
//    @Scheduled(fixedDelay = 1000*60*60*24)
    public void run2() throws InterruptedException {
        Thread.sleep(6000);
        String userid = "1627977335177150466";
        //        专题列表
        String sujectUrl = "http://118.190.174.120:8082/api/subject/authList?userId=" + userid;
        String sujectResult = restTemplate.getForObject(sujectUrl, String.class);
        JSONObject data = JSONObject.parseObject(sujectResult);//获取jsonobject对象
        JSONArray jsonArr = data.getJSONArray("result");
        for (int i = 0; i < jsonArr.size(); i++) {
            JSONObject jsonObject = jsonArr.getJSONObject(i);
            String subjectid = jsonObject.getString("id");
            String subjectName = jsonObject.getString("subjectName");
            try {
                //        专题动态
                String sujectDyUrl = "http://118.190.174.120:8082/analysis/queryInfoListBySid?id=" + subjectid;
                String sujectDyResult = restTemplate.getForObject(sujectDyUrl, String.class);
//                String sujectDyResult = "{\"success\":true,\"message\":\"操作成功!\",\"code\":200,\"result\":{\"records\":[],\"total\":0,\"size\":10,\"current\":1,\"orders\":[],\"optimizeCountSql\":true,\"hitCount\":false,\"searchCount\":true,\"pages\":0},\"timestamp\":1670392606313}";
                //        观点分析
                String analysisUrl = "http://118.190.174.120:8082/analysis/viewPointAnalysis?subjectId=" + subjectid;
                String analysisResult = restTemplate.getForObject(analysisUrl, String.class);
                //        事件脉络
                String eventUrl = "http://118.190.174.120:8082/analysis/eventContext?subjectId=" + subjectid;
                String eventResult = restTemplate.getForObject(eventUrl, String.class);
                //        传播路径
                String propagationPathUrl = "http://118.190.174.120:8082/analysis/propagationPath?subjectId=" + subjectid;
                String propagationPathResult = restTemplate.getForObject(propagationPathUrl, String.class);
                //        统计分析
                String statisticAnalysisUrl = "http://118.190.174.120:8082/analysis/statisticAnalysis?subjectId=" + subjectid;
                String statisticAnalysisResult = restTemplate.getForObject(statisticAnalysisUrl, String.class);

                //       热词词云 http://114.115.236.206:9988/datapull/subjectAnalysis/hotWordsList?_t=1678247079&id=1582917778130546690
                String hotWordsUrl = "http://114.115.236.206:9988/datapull/subjectAnalysis/hotWordsList?_t=1678247079&id=" + subjectid;
                String hotWordsResult = restTemplate.getForObject(hotWordsUrl, String.class);

                Subject subject = new Subject();
                subject.setId(subjectid);
                subject.setTitle(subjectName);
                subject.setSujectDy(sujectDyResult);
                subject.setPointAnalysis(analysisResult);
                subject.setEventContext(eventResult);
                subject.setPropagationPath(propagationPathResult);
                subject.setStatisticAnalysis(statisticAnalysisResult);
                subject.setHotWords(hotWordsResult);

                QueryWrapper<Subject> wrapper = new QueryWrapper<>();
                wrapper.eq("id", subjectid);
                //                subjectService.saveOrUpdate(subject);
                try {
                    int count = subjectService.count(wrapper);
                    if (count < 1) {
//                        subjectService.save(subject);
                        subjectMapper.insertMsg(subject);
//                subjectService.saveOrUpdate(subject);
                    } else {
                        subjectService.updateById(subject);
                    }
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            } catch (Exception e2) {
                System.out.println(e2.getMessage());
            }
        }
    }

    /**第一次延迟2秒后执行，之后按fixedDelay的规则每5秒执行一次*/
//    @Scheduled(initialDelay = 2000, fixedDelay = 5000)
    //数据表信息同步将库表数据同步到另一个库表中
//    @Scheduled(fixedDelay = 1000*60*60*24)
    public void run3(){
//        System.out.println(Thread.currentThread().getName()+"=====>>>>>使用initialDelay  {}"+(System.currentTimeMillis()/1000));


    }

    /**第一次延迟2秒后执行，之后按fixedDelay的规则每5秒执行一次
     * 同步excel数据到表中 test_detail
     *
     * */
//    @Scheduled(fixedDelay = 1000*60*60*24)
    public void run4() throws  Exception{
        logger.info("开始同步数据------------------------>");
        // 读取Excel文件
        excelpath =environment.getProperty("excelpath");
        System.out.println("读取文件名："+excelpath);
        File file = new File(excelpath);
        FileInputStream fis = new FileInputStream(file);
        Sheet sheet=null;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(fis);
            sheet = workbook.getSheetAt(0);
        }catch (Exception e){

        }
        if(sheet==null){
            try {
                XSSFWorkbook workbook = new XSSFWorkbook(fis);
                sheet = workbook.getSheetAt(0);
            }catch (Exception e){

            }
        }
        if(sheet==null){
            System.out.println("文件加载异常");
        }
        // 获取有数据的列数
        int lastRowNum = sheet.getLastRowNum();
        int lastCellNum = 0;
        for (int i = 0; i <= lastRowNum; i++) {
            Row row = sheet.getRow(i);
            if (row != null) {
                int rowLastCellNum = row.getLastCellNum();
                if (rowLastCellNum > lastCellNum) {
                    lastCellNum = rowLastCellNum;
                }
            }
        }
        int numColumnsWithData = lastCellNum + 1;
        for (int i = 1; i < lastRowNum+1; i++) {
            try {
                Row row = sheet.getRow(i);

                Basedata basedata=new Basedata();
                String bid = this.baseDataService.getserialno().toString();
                Long idl =Long.parseLong(bid);
                basedata.setId(idl + "");
                if(row.getCell(1).toString().length()>100){
                    basedata.setTitle(row.getCell(1).toString().substring(0,100));
                }else {
                    basedata.setTitle(row.getCell(1).toString());

                }
                basedata.setContent(row.getCell(9).toString());
                basedata.setSourceaddress(row.getCell(3).toString()+"/2023");
                String date = DateUtil.format(new Date(), "YYYY-MM-dd HH:MM:ss");
                basedata.setPublishDate(date);
                basedata.setCreateDate(date);
                basedata.setContentNoTag(row.getCell(9).toString());
                dataMapper.save(basedata);
                logger.info("导入资讯id："+basedata.getId()+ "导入资讯标题："+basedata.getTitle());
                BasedataType basedataType = new BasedataType();

                basedataType.setId(Long.parseLong(bid+"11"));
                basedataType.setBid(idl);
                basedataType.setTid(1001l);
                basedataType.setOrgId(1002l);
//                basedataType.setPublishDate(row.getCell(4).toString());
                basedataType.setPublishDate(date);
                basedataType.setCreateDate(date);
                basedataType.setDelflag(2l);
                basedataType.setRelevance(0l);
                dataTypeMapper.insert(basedataType);
                logger.info("导入资讯类型id："+basedataType.getId());

            }catch (Exception e){
                logger.info("保存解析异常！！！");
            }
        }

        logger.info("同步结束-------------------------------------->");
    }

    /**第一次延迟2秒后执行，之后按fixedDelay的规则每5秒执行一次
     * 同步excel数据到表中 test_detail
     *
     * */
//    @Scheduled(fixedDelay = 1000*30)
    public void run5() throws  Exception{
        logger.info("开始同步处理数据------------------------>");
        // 读取Excel文件
        excelpath =environment.getProperty("excelpath");
        System.out.println("处理信息路径 ："+excelpath);
        File file = new File(excelpath);
        FileInputStream fis = new FileInputStream(file);
        Sheet sheet=null;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(fis);
            sheet = workbook.getSheetAt(0);
        }catch (Exception e){

        }
        if(sheet==null){
            try {
                XSSFWorkbook workbook = new XSSFWorkbook(fis);
                sheet = workbook.getSheetAt(0);
            }catch (Exception e){

            }
        }
        if(sheet==null){
            System.out.println("文件加载异常");
        }
        // 获取有数据的列数
        int lastRowNum = sheet.getLastRowNum();
        int lastCellNum = 0;
        for (int i = 0; i <= lastRowNum; i++) {
            Row row = sheet.getRow(i);
            if (row != null) {
                int rowLastCellNum = row.getLastCellNum();
                if (rowLastCellNum > lastCellNum) {
                    lastCellNum = rowLastCellNum;
                }
            }
        }
        int numColumnsWithData = lastCellNum + 1;
        logger.info("采集到信息的条数"+lastRowNum);
        int k=1;
        for (int i = 1; i < lastRowNum+1; i++) {
            try {
                Row row = sheet.getRow(i);

                Basedata basedata=new Basedata();
                String bid="123400011";
                try {
                    bid = this.baseDataService.getserialno().toString();
                    System.out.println("生成的信息id" + bid);
                }catch (Exception e){
                    logger.info("生成id异常！");
                }
                Long idl =Long.parseLong(bid);
                basedata.setId(idl + "");
                if(row.getCell(1).toString().length()>100){
                    basedata.setTitle(row.getCell(1).toString().substring(0,100));
                }else {
                    basedata.setTitle(row.getCell(1).toString());

                }
                basedata.setSummary(row.getCell(9).toString());
                basedata.setKeywords(row.getCell(17).toString());
                basedata.setAuthor(row.getCell(7).toString());
                basedata.setSourcesite(row.getCell(4).toString());
                basedata.setSourceaddress(row.getCell(3).toString());
                basedata.setType(row.getCell(6).toString());
//                basedata.setPublishDate(row.getCell(9).toString());
//                basedata.setCreateDate(row.getCell(11).toString());
                basedata.setContent(row.getCell(9).toString());
                basedata.setSid(1111l);
//                basedata.setLang(row.getCell(13).toString());
                basedata.setIsBrief(row.getCell(14).toString().replace(".0",""));
                basedata.setOrigin(row.getCell(15).toString());
                basedata.setContentNoTag(row.getCell(9).toString());
//                basedata.setOrientation(row.getCell(22).toString());
//                basedata.setSourceType(row.getCell(23).toString());
                basedata.setContentImgCvtTag(row.getCell(9).toString());
//                basedata.setReprintCount(row.getCell(27).toString().replace(".0",""));
                basedata.setFromWhere(row.getCell(6).toString());
                basedata.setDelflag(2l);
                String date = DateUtil.format(new Date(), "YYYY-MM-dd HH:MM:ss");
                basedata.setPublishDate(row.getCell(5).toString());
                basedata.setCreateDate(date);
                basedata.setIsdelete(0);
                try {
                    dataMapper.save(basedata);
                }catch (Exception e){
                    logger.info("basedata保存失败");
                }

                logger.info("保存资讯id："+basedata.getId()+ " 资讯标题："+basedata.getTitle());
                BasedataType basedataType = new BasedataType();
                basedataType.setId(Long.parseLong(bid.replace("0000","")));
                basedataType.setBid(idl);
                basedataType.setTid(16865l);
                basedataType.setOrgId(3942l);
                basedataType.setPublishDate(date);
                basedataType.setCreateDate(date);
                basedataType.setDelflag(2l);
                basedataType.setRelevance(0l);
                try {
                    dataTypeMapper.insert(basedataType);
                }catch (Exception e){
                    logger.info("basedataType保存失败");
                }

                logger.info("资讯类型id："+basedataType.getId());
                k++;
            }catch (Exception e){
                logger.info("保存解析异常！！！");
            }
        }

        logger.info("数据插入到表中数量："+k);
        logger.info("同步结束-------------------------------------->");
    }

//    @Scheduled(fixedDelay = 1000*60*60)
    public void run6() throws  Exception{
        logger.info("开始同步处理数据------------------------>");
        // 读取Excel文件
        excelpath =environment.getProperty("excelpath");
        System.out.println("处理信息路径 ："+excelpath);
        File file = new File(excelpath);
        FileInputStream fis = new FileInputStream(file);
        Sheet sheet=null;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(fis);
            sheet = workbook.getSheetAt(0);
        }catch (Exception e){

        }
        if(sheet==null){
            try {
                XSSFWorkbook workbook = new XSSFWorkbook(fis);
                sheet = workbook.getSheetAt(0);
            }catch (Exception e){

            }
        }
        if(sheet==null){
            System.out.println("文件加载异常");
        }
        // 获取有数据的列数
        int lastRowNum = sheet.getLastRowNum();
        int lastCellNum = 0;
        for (int i = 0; i <= lastRowNum; i++) {
            Row row = sheet.getRow(i);
            if (row != null) {
                int rowLastCellNum = row.getLastCellNum();
                if (rowLastCellNum > lastCellNum) {
                    lastCellNum = rowLastCellNum;
                }
            }
        }
        int numColumnsWithData = lastCellNum + 1;
        logger.info("采集到信息的条数"+lastRowNum);
        for (int i = 1; i < lastRowNum+1; i++) {
            try {
                Row row = sheet.getRow(i);

                Basedata basedata=new Basedata();
                String bid = this.baseDataService.getserialno().toString();
                Long idl =Long.parseLong(bid);
                basedata.setId(idl + "");
                if(row.getCell(1).toString().length()>100){
                    basedata.setTitle(row.getCell(1).toString().substring(0,100));
                }else {
                    basedata.setTitle(row.getCell(1).toString());

                }
                basedata.setSummary(row.getCell(9).toString());
                basedata.setKeywords(row.getCell(17).toString());
                basedata.setAuthor(row.getCell(7).toString());
//                basedata.setSourcesite(row.getCell(4).toString());
                basedata.setSourcesite("测试7");
                basedata.setSourceaddress(row.getCell(3).toString());
                basedata.setType(row.getCell(6).toString());
//                basedata.setPublishDate(row.getCell(9).toString());
//                basedata.setCreateDate(row.getCell(11).toString());
                basedata.setContent(row.getCell(9).toString());
                basedata.setSid(290622l);
//                basedata.setLang(row.getCell(13).toString());
                basedata.setIsBrief(row.getCell(14).toString().replace(".0",""));
//                basedata.setOrigin(row.getCell(15).toString());
                basedata.setOrigin("测试7");
                basedata.setContentNoTag(row.getCell(9).toString());
//                basedata.setOrientation(row.getCell(22).toString());
//                basedata.setSourceType(row.getCell(23).toString());
                basedata.setContentImgCvtTag(row.getCell(9).toString());
//                basedata.setReprintCount(row.getCell(27).toString().replace(".0",""));
                basedata.setFromWhere(row.getCell(6).toString());
                basedata.setDelflag(2l);
                String date = DateUtil.format(new Date(), "YYYY-MM-dd HH:MM:ss");
                basedata.setPublishDate(row.getCell(5).toString());
                basedata.setCreateDate(date);
                basedata.setIsdelete(0);
                dataMapper.save(basedata);
                logger.info("保存资讯id："+basedata.getId()+ " 资讯标题："+basedata.getTitle());
                BasedataType basedataType = new BasedataType();

                basedataType.setId(Long.parseLong(bid.replace("0000","")));
                basedataType.setBid(idl);
                basedataType.setTid(16865l);
                basedataType.setOrgId(3942l);
                basedataType.setPublishDate(date);
                basedataType.setCreateDate(date);
                basedataType.setDelflag(2l);
                basedataType.setRelevance(0l);
                dataTypeMapper.insert(basedataType);
                logger.info("资讯类型id："+basedataType.getId());

            }catch (Exception e){
                logger.info("保存解析异常！！！");
            }
        }

        logger.info("同步结束-------------------------------------->");
    }
}
