package com.zzsn.controller;

import com.zzsn.entity.*;
import com.zzsn.service.BaseDataService;
import com.zzsn.service.impl.DataSyncServiceImpl;
import com.zzsn.utils.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@RestController
@RequestMapping("/basedata")
public class BaseDataController {


    @Autowired
    private BaseDataService baseDataService;

    @Autowired
    private DataSyncServiceImpl dataSyncService;
    @RequestMapping(value ="/test", method = RequestMethod.GET)
    @ResponseBody
    public String  test(){
        return "hello!";
    }

    /**
     * 新增或修改
     * @param basedata 数据对象
     * @return 结果
     */
    @PostMapping("/save")
    public ResultModel saveOrUpdate (@RequestBody Basedatavo basedata){

        String date = DateUtil.format(new Date(), "YYYY-MM-dd HH:MM:ss");
        String title = basedata.getTitle();
        String publishDate = basedata.getPublishDate()==null?date:basedata.getPublishDate();
        String sourceaddress = basedata.getSourceaddress();
        String content = basedata.getContent();
        String contentNoTag = basedata.getContentNoTag();
        String summary = basedata.getSummary();
        String origin = basedata.getOrigin()==null?"":basedata.getOrigin();
        String orientation = basedata.getOrientation()==null?"1":basedata.getOrientation();

        Map<String, Object> map=new HashMap<>();
        Basedata bsdata = new Basedata();
        bsdata.setTitle(title);
        bsdata.setPublishDate(publishDate);
        bsdata.setSourceaddress(sourceaddress);
        bsdata.setContent(content);
        bsdata.setContentNoTag(contentNoTag);
        bsdata.setSummary(summary);
        bsdata.setOrigin(origin);
        bsdata.setOrientation(orientation);
//        bsdata.setKeywords(keywords);
        String bid = this.baseDataService.getserialno().toString();
        Long idl =Long.parseLong(bid);
        bsdata.setId(idl + "");
        bsdata.setSid(290622l);
        bsdata.setDelflag(2l);
        bsdata.setIsdelete(0);
        bsdata.setSourceType("news");
        bsdata.setFromWhere("接口录入");

        bsdata.setCreateDate(date);
        List<Basedata> bsDataList=new ArrayList<>();
        bsDataList.add(bsdata);
        map.put("data",bsDataList);

        BasedataType basedataType = new BasedataType();
        basedataType.setId(Long.parseLong(bid.replace("0000","")));
        basedataType.setBid(idl);
        basedataType.setTid(16865l);
        basedataType.setOrgId(3942l);
        basedataType.setPublishDate(publishDate);
        basedataType.setCreateDate(date);
        basedataType.setDelflag(2l);
        basedataType.setRelevance(0l);
        List<BasedataType> typeList=new ArrayList<>();
        typeList.add(basedataType);
        //4.插入之前对basedata中的内容包含图片的进行base64转码，先不改变原content中src的内容
        Map<String, Object> map1 = dataSyncService.imgHandler((List<Basedata>) map.get("data"));
        try {
//                dataSyncService.insertBatch((List<Basedata>) secretMap.get("data"), (List<BasedataType>) secretMap.get("typeData"),
//                        (List<BaseDataImage>) map1.get("imageList"), (List<CesSysWeb>) localMap.get("exitWebList")
//                        , (List<CesSysWeb>) localMap.get("newWebList"), (List<BaseDataWebMid>) localMap.get("baseDataWebList"));
            dataSyncService.insertBatch((List<Basedata>) map.get("data"), typeList,
                    (List<BaseDataImage>) map1.get("imageList"), null
                    , null, null);

        }catch (Exception e){
            return ResultModel.OK("插入失败");
        }
        String id="插入数据的id: "+bid;
        return ResultModel.OK(id);
    }




}
