/**
Requires jQuery
*/
//加载开始时的动画
function loadBegin(){
	jQuery.blockUI({
	 message: '<h2><img src="/mrbis/images/ajax-loader.gif" /> 正在加载数据，请稍候 ...</h2>',
	 css: { 
           border: 'none', 
           padding: '5px', 
           backgroundColor: '#333333', 
           '-webkit-border-radius': '10px', 
           '-moz-border-radius': '10px', 
           opacity: '.5', 
           color: '#fff'
       },
       overlayCSS: {
       	 backgroundColor: '#E6E6E6' 
        }  
    }); 	
}
//加载结束时的动画
function loadClose(){
	jQuery.unblockUI();
}
	
var start;
window.onload = function () {
	loadBegin();
 	start = setInterval('updateImg()', 1000);
}
function updateImg() {
	if (document.readyState == 'complete') {
		try{
			loadClose();
			clearInterval(start);//执行成功，清除监听
		}catch(err){return true;}
	}
}

//删除子行，废弃，
function removeChildrenRowsOnlyTwo(data){
	var i=0;
	while(1){
		var id = (data.id+"_"+i++);	//子行id
		if($('#'+id).children().html()){
			$('#'+id).remove();		//删除子行
			if($('#'+id+'_0').children().html()){//如果子行还有子行
				var j=0;
				while(1){
					var idd = (id+"_"+j++);	//子行的子行id
					if($('#'+idd).children().html()){
						$('#'+idd).remove();
					}else break;
				}
			}
		}else break;
	}
}

//递归删除任意行的子行
function removeChildrenRows(data){
	var _id = data.id;
	var i=0;
	while(1){
		var id = (_id+"_"+i++);	//子行id
		if($('#'+id).children().html()){
			$('#'+id).remove();		//删除子行
			if($('#'+id+'_0').children().html()){
				//如果子行还有子行,递归删除
				removeChildrenRows({id:id});
			}
		}else break;
	}
//	alert(_id+'---a'+$('img','#'+_id).attr('src'));
	changeImg({$target:$('#'+_id)});
}
 
function setTrBgColor(data){
	//设置隔行背景色
	$('#'+data.target).children(':even').css('background-color',data.even)
		.end().children(':odd').css('background-color',data.odd)
		.end().children().each(function(){
			$(this).data('bgcolor',$(this).css('background-color'));
		});
	
	//设置焦点悬浮背景色
	$('#'+data.target).children().hover(function(){
		$(this).css('background-color',data.hover);
	},function(){
		$(this).css('background-color',$(this).data('bgcolor'));
	});
}
	
 //删除数据表格的所有子行
 function removeTableChildrenRow(){
 	var tbody = $id("datatable_tbody");
 	for(var i=0; i<tbody.children.length; i++){
 		removeChildrenRows(tbody.children[i]);
 	}
 }

	
//改变箭头方向
function changeImg(data){
	var firstChildId = data.$target.attr('id')+'_0';
	var $img = data.$target.children().find('img');
	if( $('#'+firstChildId).html() ){//如果存在子节点
		$img.attr('src','/mras/images/toggle-collapse-dark.png');
		$img.parent().attr('title','点击查询');
	}else{
		$img.attr('src','/mras/images/toggle-expand-dark.png');
		$img.parent().attr('title','点击收起');
	}
}
    
//添加事件
function addEvent(obj,evt,fn){	
	if(obj.addEventListener){		
		obj.addEventListener(evt,fn,false);	
	}else if(obj.attachEvent){			
		obj.attachEvent('on'+evt,fn);	
	}
}

function reverseArray(data){
	var len = 0;
	try{len = data.length;}catch(e){}
	if(len==0||len==1)return data;
	var ret = new Array();
	for(var i=data.length-1; i>=0; i--){
		ret.push(data[i]);
	}
	return ret;
}  

//拼接普通的单元格
function makeTd(data){
	if(data.width && data.width !== '' && data.width!=='undefined') return '<td width="'+data.width+'">'+data.value+'</td>';
	else return '<td>'+data.value+'</td>';
}

//拼接用于查看详细数据的单元格
function makeTdShowData(data){
	return '<td class="data_clickable" idname="'+data.label+'" title="点击查看详细数据"><a class="underline">'+data.value+'</a></td>';
}