package com.zzsn.service.impl;

import com.zzsn.dao.SiteDao;
import com.zzsn.entity.Site;
import com.zzsn.service.SiteService;
import com.zzsn.util.Pager;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SiteServiceImpl extends ServiceImpl<SiteDao, Site>  implements SiteService {
    @Autowired
    SiteDao siteDao;


    @Override
    public Pager<Site> listByPage(long offSet, long pageSize, Site site) throws Exception {
        List<Site> siteList = siteDao.pagerData(offSet, pageSize, site);
        Pager<Site> sitePager=new Pager<>();
        sitePager.setRows(siteList);
        sitePager.setOffset(0L);
        sitePager.setPagesize(10L);
        return sitePager;
    }
}
