/*
**  小挂件
*/
EBOS.widget = (function(){
	return {
		/*
		**  创建挂件
		**  自定义挂件：EBOS.widget.createTemp({url,width,height,left,top});
		**      示例：EBOS.widget.createTemp({url:"http://www.baidu.com",width:800,height:400,left:100,top:100});
		*/
		createTemp : function(obj){
			$('.popup-menu').hide();
			$('.quick_view_container').remove();
			var type = 'widget', appid = obj.appid == null ? Date.parse(new Date()) : obj.appid;
			//判断窗口是否已打开
			var iswidgetopen = false;
			$('#desk .widget').each(function(){
				if($(this).attr('appid') == appid){
					iswidgetopen = true;
				}
			});
			//如果没有打开，则进行创建
			if(iswidgetopen == false){
				function nextDo(options){
					$('#desk').append(EBOS.widget.getTemp(options));
					var widgetId = '#w_' + options.appid;
					//绑定小挂件上各个按钮事件
					EBOS.widget.handle($(widgetId));
					//绑定小挂件移动
					EBOS.widget.move($(widgetId));
				}
				nextDo({
					appid : appid,
					url : obj.url,
					width : obj.width,
					height : obj.height,
					top : obj.top == null ? 0 : obj.top,
					left : obj.left == null ? 0 : obj.left
				});
			}
		},
		//创建widget
		create2 : function(widget){
			var $desk = $('#desk-'+widget.desk);
			var appid = widget['appid'];
			//判断窗口是否已打开
			var iswidgetopen = false;
			$('.widget',$desk).each(function(){
				if($(this).attr('appid') == appid){
					iswidgetopen = true;
				}
			});
			//如果没有打开，则进行创建
			if(iswidgetopen == false && $('#d_' + appid).attr('opening') != 1){
				$('#d_' + appid).attr('opening', 1);
				function nextDo(options){
					//创建外围component
					$desk.append(EBOS.widget.getTemp(options));
					var widgetId = '#w_' + options.appid;
					//绑定小挂件上各个按钮事件
					EBOS.widget.handle($(widgetId));
					//绑定小挂件移动
					EBOS.widget.move($(widgetId));
					EBOS.deskTop.widgetResize();
					
					randDataToChart({id: options.appid, type: options.type,opt:options}); // 获取数据
				}
				ZENG.msgbox.show('小挂件正在加载中，请耐心等待...', 6, 100000);
					if(widget != null){
						if(widget['error'] == 'E100'){
							ZENG.msgbox.show('应用不存在，建议删除', 5, 2000);
						}else{
							ZENG.msgbox._hide();
							nextDo(widget);
						}
					}else{
						ZENG.msgbox.show('小挂件加载失败', 5, 2000);
					}
					$('#d_' + appid).attr('opening', 0);
			}
		},
		//创建widget
		create : function(appid, obj){
			//判断窗口是否已打开
			var iswidgetopen = false;
			$('#desk .widget').each(function(){
				if($(this).attr('appid') == appid){
					iswidgetopen = true;
				}
			});
			//如果没有打开，则进行创建
			if(iswidgetopen == false && $('#d_' + appid).attr('opening') != 1){
				$('#d_' + appid).attr('opening', 1);
				function nextDo(options){
					//创建外围component
					$('#desk').append(EBOS.widget.getTemp(options));
					var widgetId = '#w_' + options.appid;
					//绑定小挂件上各个按钮事件
					EBOS.widget.handle($(widgetId));
					//绑定小挂件移动
					EBOS.widget.move($(widgetId));
					EBOS.deskTop.widgetResize();
					
					randDataToChart({id: options.appid, type: options.type}); // 获取数据
				}
				ZENG.msgbox.show('小挂件正在加载中，请耐心等待...', 6, 100000);
				$.getJSON(URL + 'ajaxMyAppById.action?widgetId=' + appid, function(widget){
					widget = EBOS.widget.getStaticData({'appid':appid});
					if(widget != null){
						if(widget['error'] == 'E100'){
							ZENG.msgbox.show('应用不存在，建议删除', 5, 2000);
						}else{
							ZENG.msgbox._hide();
							var options = {
								appid : widget['appid'],
								realappid : widget['realappid'],
								url : widget['url'],
								width : widget['width'],
								height : widget['height'],
								sort : widget['sort'],
								type : 'spark',
								figrueId : ''
							};
							nextDo(widget);
						}
					}else{
						ZENG.msgbox.show('小挂件加载失败', 5, 2000);
					}
					$('#d_' + appid).attr('opening', 0);
				});
			}
		},
		//添加到桌面
		add : function(id, type,callback){
			//判断添加到哪个桌面，迭代当前桌面后面的桌面，注意上面a标签的样式，借鉴desktop中的方法。
			var desk = EBOS.widget.getDesk(type);
			EBOS.navbar.switchDesk(desk);
			$.ajax({
				type : 'POST',
				url : ctx+'/portal/widget!addWidget.action',
				data : {widgetId : id,desk:desk},
				success : function(){
					callback && callback(id,'true');
					EBOS.app.get();
				}
			}); 
		},
		/**
		 * 计算确定添加的组件放置到哪个桌面上，按照添加tab分为三类：link ，major， widget。
		 * link按照grid布局计算空间
		 * major每个页面判断只有一个，没有计算空间
		 * widget按照最大的高端计算空间
		 */
		getDesk : function(type){
			var desk = EBOS.CONFIG.desk;
			var top = EBOS.CONFIG.widgetTop;
			var	right = EBOS.CONFIG.widgetRight;
			var grid = EBOS.grid.getAppGrid();
			if(type == 'link'){//添加的为左侧的app链接
				for(var i=EBOS.CONFIG.desk;i<=EBOS.CONFIG.deskSize;i++){
					if(i==EBOS.CONFIG.deskSize){
						return i;//不判断最后一个桌面空间，直接放置
					}
					var maxLeft = grid[($('#desk-'+i+' li a').length-1)]['endX'];
					var maxY = grid[($('#desk-'+i+' li a').length-1)]['endY'];
					var width = $('#desk-'+i).width();
					var height = $('#desk-'+i).height();
					if(height >= grid[$('#desk-'+i+' li a').length]['endY']){
						return i;
					}else{
						var rightLast =  praseInt($('#desk-'+i+' div.right-widget:last').css('left')) || width ;
						var middle = $('#desk-'+i+' div.mid-widget').width() || 0;
						var _w = grid[0]['endX']-grid[0]['startX'];
						if(rightLast-grid[($('#desk-'+i+' li a').length)]['endX'] >= middle){
							return i;
						}
					}
				}
			}else if(type == 'major'){//中间大组件，每个桌面最多放置一个
				for(var i=EBOS.CONFIG.desk;i<=EBOS.CONFIG.deskSize;i++){
					if(i==EBOS.CONFIG.deskSize){
						return i;//不判断最后一个桌面空间，直接放置
					}
					if($('#desk-'+i+' div.mid-widget') && $('#desk-'+i+' div.mid-widget').size()>0){
						
					}else{
						return i;
					}
				}
			}else{//右侧组件，按照最大高度168计算
				for(var i=EBOS.CONFIG.desk;i<=EBOS.CONFIG.deskSize;i++){
					if(i==EBOS.CONFIG.deskSize){
						return i;//不判断最后一个桌面空间，直接放置
					}
					var objHeight = 168,objWidth = 206;
					var maxLeft = (parseInt($('#desk-'+i+' div.mid-widget').css('left'))+ $('#desk-'+i+' div.mid-widget').width()) || grid[($('#desk-'+i+' li a').length-1)]['endX'];
					var maxHeight = (parseInt($('#desk-'+i+' div.right-widget:last').css('top'))+ parseInt($('#desk-'+i+' div.right-widget:last').height())) || top;
					var height = $('#desk-'+i).height();
					if(height >= (objHeight+maxHeight)){
						return i;
					}else{
						if(maxLeft + objWidth <=parseInt($('#desk-'+i+' div.right-widget:last').css('left')) ){
							return i;
						}
					}
				}
			}
		
		},
		//
		init : function(sc){
			$(sc).each(function(i,n){
				n.desk = sc.desk;
				EBOS.widget.create2(n);
			})
		},
		//还原上次退出系统时widget的状态
		reduction : function(){
			// 暂不调用
			return;
			$.getJSON(ajaxUrl + 'widget!ajaxUserWidgets.action', function(sc){
				sc=[];
				sc[0] = {'appId':'22'};
				sc[1] = {'appId':'23'};
				sc[2] = {'appId':'24'};
				sc[3] = {'appId':'25'};
				sc[4] = {'appId':'26'};
				$(sc).each(function(i,n){
					EBOS.widget.create(n.appId, {'left' : n.left, 'top' : n.top});
				})
			});
		},
		move : function(obj){
			obj.on('mousedown', '.move', function(e){
				var oldTop = parseInt(obj.css('top'));
				var oldRight = parseInt(obj.css('right'));
				oldZIndex = obj.css('z-index') == NaN ? 0: obj.css('z-index');
				//obj.css({'z-index':9000});
				var lay, x, y;
				var leftPad = 0;
				var  cx, cy, dx, dy;
				dx = cx = e.clientX;
				dy = cy = e.clientY;
				x = e.clientX - obj.offset().left+100;//相对div左侧的偏移
				y = e.clientY - obj.offset().top;
				//消除拖动过程中，padding和margin看起来超出可视范围
				var _w = obj.width()+parseInt(obj.css('padding-left'))+parseInt(obj.css('padding-right'));
				var _h = obj.height()+parseInt(obj.css('padding-top'))+parseInt(obj.css('padding-bottom'));
				var $navBar = $('#nav-bar'),
					_left = parseInt($navBar.css('left')),
					_top= parseInt($navBar.css('top'));
				//绑定鼠标移动事件
				lay = EBOS.maskBox.widget();
				//lay.show();
				$(document).on('mousemove', function(e){
					//100 为左侧一条的距离
					cx = e.clientX - x > $("#desk-"+EBOS.CONFIG.desk).width() - _w? $("#desk-"+EBOS.CONFIG.desk).width() - _w-leftPad  <= leftPad ? leftPad :  $("#desk-"+EBOS.CONFIG.desk).width() - _w-leftPad : e.clientX - x <= leftPad ? leftPad : e.clientX - x ;
					cy = e.clientY - y > $(document).height() - _h ? $(document).height() - _h <= 47 ? 47 :$(document).height() - _h : e.clientY - y <= 47 ? 47 :e.clientY - y;
					
					if((e.clientX>=_left && e.clientX<=(_left+$navBar.width())) && (e.clientY>=_top&& e.clientY<=(_top+$navBar.height()))){
						//console.log('e: '+e.clientY	);
						lay.hide();
						obj.css('z-index',-10);
						obj.find('*').css('z-index',-10);
					}else{
						lay.hide();
					};
					obj.css({
						left :cx,
						top : cy
					});
				}).on('mouseup', function(){
					obj.css({'z-index':oldZIndex});
					$(this).off('mousemove').off('mouseup');
					if(typeof(lay) !== 'undefined'){
						lay.hide();
					}
					//没有移动，判定为click 事件 ，不做任何事
					if(dx == cx && dy == cy){
						return false;
					}
					//debug 移动效果
					//根据拖动位置，改变元素在文档流中的位置，进行排序，不与原自身位置比较
					var _top = parseInt(obj.css('top'));
					var _left = parseInt(obj.css('left'));
					$('#desk div.right-widget').each(function(i,n){
						if($(n).attr('id') != obj.attr('id')){
							var _thisTop = parseInt($(n).css('top'));
							/**var _thisLeft = parseInt($(n).css('left'));
							if((_top < _thisTop || _left > _thisLeft) && (oldTop > _thisTop || _left < _thisLeft)){
								 $(n).before(obj);
								 return false;
							}
							if ((_top > _thisTop || _left < _thisLeft) && (oldTop <_thisTop || _left > _thisLeft)){
								 $(n).after(obj);
							}*/
							if((_top < _thisTop ) && (oldTop > _thisTop )){
								 $(n).before(obj);
								 return false;
							}else if ((_top > _thisTop ) && (oldTop <_thisTop )){
								 $(n).after(obj);
							}
						}
					});
					//EBOS.deskTop.widgetResize();
				});
			});
		},
		close : function(appid){
			var widgetId = '#w_' + appid;
			$(widgetId).empty().remove();
			$.ajax({
				type : 'POST',
				url : ctx+'/portal/widget!deleteWidget.action',
				data : {widgetId : appid},
				success : function(){
					EBOS.deskTop.widgetResize();
					
					// 调用iframe内部的js函数刷新列表
					var iframeId = "w_ebos_yysc_iframe";
					if ($("#w_ebos_yysc_iframe")[0] != null) {
						$("#w_ebos_yysc_iframe")[0].contentWindow.refreshAppList();
					}
				}
			}); 
			
		},
		handle : function(obj){
			obj.on('click', '.close', function(){
				EBOS.widget.close(obj.attr('appid'));
			});
		},
		getTemp : function(options,callback){
			var widgetTemp;
			switch(options.type){
				case 'spark': 
					widgetTemp=sparkWidgetTemp({
						'type' : options.type	,
						'id' : 'w_' + options.appid,
						'appid' : options.appid,
						'realappid' : 0,
						'name' : options.name,
						'recordDay' : options.recordDay,
						'figureId' : options.figureId,
						'ratioclazz' : options.ratioclazz,
						'ratio' : options.ratio,
						'data' : options.data
					}); 
					break;
				case 'dashbord':
					widgetTemp=dashbordWidgetTemp({
						'type' : options.type	,
						'id' : 'w_' + options.appid,
						'appid' : options.appid,
						'realappid' : 0,
						'name' : options.name,
						'recordDay' : options.recordDay,
						'figureId' : options.figureId,
						'ratio' : options.ratio
					}); 
					break;
				case 'hbullet':
					widgetTemp=hbulletWidgetTemp({
						'type' : options.type	,
						'id' : 'w_' + options.appid,
						'appid' : options.appid,
						'realappid' : 0,
						'name' : options.name,
						'recordDay' : options.recordDay,
						'figureId' : options.figureId,
						'ratio' : options.ratio
					}); 
					break;
				case 'HLinearGauge':
					widgetTemp=hLinearGaugeWidgetTemp({
						'type' : options.type	,
						'id' : 'w_' + options.appid,
						'appid' : options.appid,
						'realappid' : 0,
						'name' : options.name,
						'recordDay' : options.recordDay,
						'figureId' : options.figureId,
						'ratio' : options.ratio
					}); 
					break;
				case 'major':
					options['id']='w_'+options.appid;
					widgetTemp = operatotsTemple(options); 
					break;
				case 'pvAnalysis':
					options['id']='w_'+options.appid;
					widgetTemp = pvAnalysisWidgetTemp(options); 
					break;
				case 'fccom2dtable':
					options['id']='w_'+options.appid;
					widgetTemp = fcCom2DTableTemp(options); 
					break;
				default: ;
			}
			callback && callback();
			return widgetTemp;
		},
		getStaticData : function(options,callback){
			var widget = {};
			switch(options.appid){
				case '22':
					widget={
						'type' : 'spark',
						'appid' : '22',
						'title' : '当月付费用户数',
						'recordDay' : '截止到12月28日',
						'figureId' : 'spark',
						'ratioclazz' : 'down',
						'ratio' : '17',
						'data' : '1,129,764'
					};break;
				case '23':
					widget={
						'type' : 'spark',
						'appid' : '23',
						'title' : '当月高价值用户数',
						'recordDay' : '截止到12月28日',
						'figureId' : 'spark',
						'ratioclazz' : 'up',
						'ratio' : '20',
						'data' : '718,170'
					};break;
				case '24':
					widget={
						'type' : 'dashbord',
						'appid' : '24',
						'title' : '高价值用户活跃度',
						'recordDay' : '截止到12月28日',
						'figureId' : 'dashbord',
						'ratio' : '29.50',
						'data' : '1,129,764'
					};break;
				case '25':
					widget={
						'type' : 'dashbord',
						'appid' : '25',
						'title' : '高价值用户保级率',
						'recordDay' : '截止到12月28日',
						'figureId' : 'dashbord',
						'ratio' : '11.49',
						'data' : '1,129,764'
					};break;
				case '26':
					widget = {
							type:'major',
							appid : '26',
							clazz : 'operatots',
							title : '运营部核心关注指标一览',
							recordDay : '截止到12月28日',
							top : 97,
							left :375
						};
				default : ;
			}
			return widget;
		}
	}
})();