/*
**  桌面
*/
EBOS.deskTop = (function(){
	return {
		/*
		**  处理浏览器改变大小后的事件
		*/
		resize : function(time){
			//使用doTimeout插件，防止出现resize两次的bug
			$.doTimeout('resize', time, function(){
				if($('#desktop').css('display') !== 'none'){
					//更新码头位置
					EBOS.dock.setPos();
					//更新图标定位
					EBOS.deskTop.appresize();
					//更新窗口定位
					EBOS.deskTop.windowresize();
					//更新滚动条
					EBOS.app.getScrollbar();
				}else{
					EBOS.appmanage.resize();
				}
				EBOS.wallpaper.set(false);
			});
		},
		/*
		**  重新排列图标
		*/
		appresize : function(){
			var grid = EBOS.grid.getAppGrid(), dockGrid = EBOS.grid.getDockAppGrid();
			$('#dock-bar .dock-applist li').each(function(i){
				$(this).animate({
					'left' : dockGrid[i]['startX'],
					'top' : dockGrid[i]['startY']
				}, 500);
			});
			for(var j = 1; j <= 5; j++){
				$('#desk-' + j + ' li a').each(function(i){
					$(this).animate({
						'left' : grid[i]['startX'] + 16,
						'top' : grid[i]['startY'] + 7
					}, 500);
				});
			}
			//更新widget
			EBOS.deskTop.widgetResize();
		},
		/*
		**  重新排列widget
		*/
		widgetResize : function(opt){
			for(var j = 1; j <= 5; j++){
				var top , right , width, height,maxWidth = 0;
				var maxLeft = 0 , minRight = $('#desk-'+j).width() ;
				var maxY = 0;
				var grid = EBOS.grid.getAppGrid();
				if(!($('#desk-'+j+' li a') && $('#desk-'+j+' li a').length>0)){
					return false;
				}
				maxLeft = grid[($('#desk-'+j+' li a').length-1)]['endX'];
				maxY = grid[($('#desk-'+j+' li a').length-1)]['endY'];
				top = EBOS.CONFIG.widgetTop;
				right = EBOS.CONFIG.widgetRight;
				width = $('#desk-'+j).width();
				height = $('#desk-'+j).height();
				
				$('#desk-'+j+' div.right-widget').each(function(i,n){
					var _width = $(this).width();
					if(parseInt(top + $(this).height()) >= parseInt(height)){
						right += maxWidth +30;
						top = EBOS.CONFIG.widgetTop;
					}
					maxWidth = maxWidth > _width ? maxWidth : _width;
					var _left = width - right - _width;//定左侧点 
					//距顶部10px
					$(this).animate({
						'left' : _left,
						'top' : top
					}, 500);
					top += $(this).height()+EBOS.CONFIG.widgetSpace;
					minRight = _left;
				});
				
				//debug
				$('#desk-'+j+' div.mid-widget').each(function(i,n){
					var _left = parseInt($(n).css('left'))+$(n).width()>minRight ?
							( minRight- $(n).width()<maxLeft ? maxLeft:minRight-20- $(n).width()):
								parseInt($(n).css('left')) <= maxLeft ? maxLeft+10 :  parseInt($(n).css('left'));
					$(n).animate({
						'left' : _left
					}, 500);
	//				if(parseInt($(n).css('left')) <= parseInt(maxLeft)){
	//					if(parseInt($(n).css('top')) <= maxY && maxY+$(this).width()<height){
	//						$(n).animate({
	//							'top' : maxY
	//						}, 500);
	//					}else if(parseInt($(n).css('top')) >= maxY && parseInt($(n).css('top'))+$(this).width()<height){
	//						console.log('dont move');
	//					}else{
	//						console.log('left');
	//						$(n).animate({
	//							'left' : maxLeft
	//						}, 500);
	//					}
	//				}
				});
			}
		},
		/*
		**  重新定位窗口位置
		*/
		windowresize : function(){
			$('#desk div.window-container').each(function(){
				var windowdata = $(this).data('info');
				currentW = $(window).width() - $(this).width();
				currentH = $(window).height() - $(this).height();
				_l = windowdata['left'] / windowdata['emptyW'] * currentW >= currentW ? currentW : windowdata['left'] / windowdata['emptyW'] * currentW;
				_l = _l <= 0 ? 0 : _l;
				_t = windowdata['top'] / windowdata['emptyH'] * currentH >= currentH ? currentH : windowdata['top'] / windowdata['emptyH'] * currentH;
				_t = _t <= 0 ? 0 : _t;
				if($(this).attr('state') != 'hide'){
					$(this).animate({
						'left' : _l,
						'top' : _t
					}, 500, function(){
						windowdata['left'] = _l;
						windowdata['top'] = _t;
						windowdata['emptyW'] = $(window).width() - $(this).width();
						windowdata['emptyH'] = $(window).height() - $(this).height();
					});
				}else{
					windowdata['left'] = _l;
					windowdata['top'] = _t;
					windowdata['emptyW'] = $(window).width() - $(this).width();
					windowdata['emptyH'] = $(window).height() - $(this).height();
				}
			});
		}
	}
})();