/**
Requires jQuery
*/
/**
 * 使用对话框进行删改查
 * @param	dId	对话框ID
 * @param	html	
 * @param	height 高度
 * @param	width	宽度
 * @param	title	标题
 * @param	ids		渠道编号
 * @param	buttons		按钮
 * @param	callback	回调函数
 */
function openDialog(opt){
	var d=new Date();
	var dId = opt.dId || 'eb-dialog-'+d.getTime();
	var html = '<div id="'+dId+'" style="padding: 0px;overflow:no;">'+opt.html+'</div>';
	$('#'+dId).remove();
	$('body').append(html);
	
	if( !opt.buttons ){
		opt.buttons = [];
	}
	opt.buttons['关闭'] = function(){
		$('#'+dId).dialog({closed: true});
	};
			
	$('#'+dId).dialog({
		height: opt.height,
		width: opt.width,
		shadow: false,
		modal: true,
		closed: false,
		resizable: false,
		title: opt.title,
		destroyOnClose: true,
		buttons: opt.buttons,
		onClose: function(){
			$('#'+dId).remove();
		}
	});
	
	if( opt.callback ){
		opt.callback();
	}
}


/**
 * 关闭对话框
 */
function closeDialog(opt){
	$('#'+opt.dId).dialog({
		closed: true
	});
}

//自助取数dialog(去掉dialog最下面的按钮工具层)
function openDialogForSelfExtract(opt){
		var dId = opt.dId;
		var html = '<div id="'+dId+'" style="padding: 0px;overflow-y:hidden;">'+opt.html+'</div>';
		
		$('#'+dId).remove();
		$('body').append(html);
		
		$('#'+dId).dialog({
			height: opt.height,
			width: opt.width,
			shadow: false,
			modal: true,
			hide: true,
			show: true,
			resizable: false,
			autoOpen:false,
			title: opt.title,
			destroyOnClose: false,
			onClose: function(){

			}
		});
		
		if( opt.callback ){
			opt.callback();
		}
}
//重写openDialog 去除dialog中的滚动条
function openTopDialog(opt){
	var d=new Date();
	var dId = opt.dId || 'eb-dialog-'+d.getTime();
	var html = '<div id="'+dId+'" style="padding: 0px;overflow:hidden;">'+opt.html+'</div>';
	$('#'+dId).remove();
	$('body').append(html);
	
	if( !opt.buttons ){
		opt.buttons = [];
	
		opt.buttons['关闭'] = function(){
			$('#'+dId).dialog({closed: true});
		};
	}		
	$('#'+dId).dialog({
		height: opt.height,
		width: opt.width,
		shadow: false,
		modal: true,
		closed: false,
		resizable: false,
		title: opt.title,
		destroyOnClose: true,
		buttons: opt.buttons,
		onClose: function(){
			$('#'+dId).remove();
		}
	});
	
	if( opt.callback ){
		opt.callback();
	}
}
