package com.zzsn.generation;

import com.zzsn.generation.segment.SegmentUtil;
import com.zzsn.generation.test.KeyExtractor;
import com.zzsn.generation.test.MyUtility;
import com.hankcs.hanlp.HanLP;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class GenHandler {

    public static String getSummary(String str){
        HashMap<String, List<String>> cleanWordMap = SegmentUtil.segmentCleanHanlp(str);
        List<String> wordList = cleanWordMap.get(SegmentUtil.SEGMENT_WORD);
        wordList = SegmentUtil.cleanResult(wordList);
        KeyExtractor k = new KeyExtractor();
        List<String> keywordList = HanLP.extractKeyword(str, 5);
        System.out.println(keywordList);

        wordList.retainAll(keywordList);
        LinkedHashMap<String,Double> featureMap  =  k.keyExtract(wordList, "cn", 200);

        Integer wholeSize = featureMap.keySet().size();
        String[] wholeKeywordArray = new String[wholeSize];
        featureMap.keySet().toArray(wholeKeywordArray);
        Integer  wantSize =10;
        String[]  keywordArray = null;
        if(wholeKeywordArray.length>0){
            if(wantSize>wholeSize){
                wantSize = wholeSize;
            }
            keywordArray = new String[wantSize];
            for(int i= 0 ; i <wantSize;i++){
                keywordArray[i] = wholeKeywordArray[i];
            }
        }
        String keyword = MyUtility.connectArray(keywordArray);
        String summary1 = GenSummaryUtil.autoSummary(str, keyword);

        return summary1;
    }
}
