/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.ner.CMMClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;

public class ClassifierCombiner<IN extends CoreMap & HasWord>
extends AbstractSequenceClassifier<IN> {
    private static final boolean DEBUG = false;
    private List<AbstractSequenceClassifier<IN>> baseClassifiers;
    private static final String DEFAULT_AUX_CLASSIFIER_PATH = "/u/nlp/data/ner/goodClassifiers/english.muc.7class.distsim.crf.ser.gz";
    private static final String DEFAULT_CLASSIFIER_PATH = "/u/nlp/data/ner/goodClassifiers/english.all.3class.distsim.crf.ser.gz";

    public ClassifierCombiner(Properties p) throws FileNotFoundException {
        super(p);
        String loadPath2;
        ArrayList<String> paths = new ArrayList<String>();
        String loadPath1 = p.getProperty("loadClassifier1");
        if (loadPath1 != null && (loadPath2 = p.getProperty("loadClassifier2")) != null) {
            paths.add(loadPath1);
            paths.add(loadPath2);
            for (int i = 3; i <= 10; ++i) {
                String path = p.getProperty("loadClassifier" + i);
                if (path == null) continue;
                paths.add(path);
            }
            this.loadClassifiers(paths);
        } else {
            loadPath1 = p.getProperty("loadClassifier");
            if (loadPath1 != null && (loadPath2 = p.getProperty("loadAuxClassifier")) != null) {
                paths.add(loadPath1);
                paths.add(loadPath2);
                this.loadClassifiers(paths);
            } else {
                paths.add(DEFAULT_CLASSIFIER_PATH);
                paths.add(DEFAULT_AUX_CLASSIFIER_PATH);
                this.loadClassifiers(paths);
            }
        }
    }

    public ClassifierCombiner(String ... loadPaths) throws FileNotFoundException {
        super(new Properties());
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(loadPaths));
        this.loadClassifiers(paths);
    }

    public ClassifierCombiner(AbstractSequenceClassifier<IN> ... classifiers) {
        super(new Properties());
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>(Arrays.asList(classifiers));
        this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
    }

    private void loadClassifiers(List<String> paths) throws FileNotFoundException {
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>();
        for (String path : paths) {
            AbstractSequenceClassifier cls = ClassifierCombiner.loadClassifierFromPath(path);
            this.baseClassifiers.add(cls);
        }
        if (this.baseClassifiers.size() > 0) {
            this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        }
    }

    public static <INN extends CoreMap & HasWord> AbstractSequenceClassifier<INN> loadClassifierFromPath(String path) throws FileNotFoundException {
        try {
            return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CRFClassifier.getClassifier(path));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CMMClassifier.getClassifier(path));
            }
            catch (Exception e2) {
                FileNotFoundException fnfe = new FileNotFoundException();
                fnfe.initCause(e2);
                throw fnfe;
            }
        }
    }

    @Override
    public Set<String> labels() {
        Set<String> labs = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> cls : this.baseClassifiers) {
            labs.addAll(cls.labels());
        }
        return labs;
    }

    private List<IN> mergeDocuments(List<List<IN>> baseDocuments) {
        assert (!this.baseClassifiers.isEmpty() && !baseDocuments.isEmpty());
        for (int i = 1; i < baseDocuments.size(); ++i) {
            assert (baseDocuments.get(0).size() == baseDocuments.get(i).size());
        }
        ArrayList<Set<String>> baseLabels = new ArrayList<Set<String>>();
        Set<String> seenLabels = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> baseClassifier : this.baseClassifiers) {
            Set<String> labs = baseClassifier.labels();
            labs.removeAll(seenLabels);
            seenLabels.addAll(labs);
            baseLabels.add(labs);
        }
        String background = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        List<IN> mainDocument = baseDocuments.get(0);
        for (int i = 1; i < baseDocuments.size(); ++i) {
            ClassifierCombiner.mergeTwoDocuments(mainDocument, baseDocuments.get(i), (Set)baseLabels.get(i), background);
        }
        return mainDocument;
    }

    static <INN extends CoreMap & HasWord> void mergeTwoDocuments(List<INN> mainDocument, List<INN> auxDocument, Set<String> auxLabels, String background) {
        boolean insideAuxTag = false;
        boolean auxTagValid = true;
        String prevAnswer = background;
        ArrayList<CoreMap> constituents = new ArrayList<CoreMap>();
        ListIterator<INN> auxIterator = auxDocument.listIterator();
        for (CoreMap wMain : mainDocument) {
            boolean insideMainTag;
            String mainAnswer = (String)wMain.get(CoreAnnotations.AnswerAnnotation.class);
            CoreMap wAux = (CoreMap)auxIterator.next();
            String auxAnswer = (String)wAux.get(CoreAnnotations.AnswerAnnotation.class);
            boolean bl = insideMainTag = !mainAnswer.equals(background);
            if (auxLabels.contains(auxAnswer)) {
                if (!prevAnswer.equals(auxAnswer) && !prevAnswer.equals(background)) {
                    if (auxTagValid) {
                        for (CoreMap wi : constituents) {
                            wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                        }
                    }
                    auxTagValid = true;
                    constituents = new ArrayList();
                }
                insideAuxTag = true;
                if (insideMainTag) {
                    auxTagValid = false;
                }
                prevAnswer = auxAnswer;
                constituents.add(wMain);
                continue;
            }
            if (insideAuxTag) {
                if (auxTagValid) {
                    for (CoreMap wi : constituents) {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                    }
                }
                constituents = new ArrayList();
            }
            insideAuxTag = false;
            auxTagValid = true;
            prevAnswer = background;
        }
        if (auxTagValid) {
            for (CoreMap wi : constituents) {
                wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
            }
        }
    }

    @Override
    public List<IN> classify(List<IN> tokens) {
        int i;
        if (this.baseClassifiers.isEmpty()) {
            return tokens;
        }
        ArrayList<List<IN>> baseOutputs = new ArrayList<List<IN>>();
        List<IN> output = this.baseClassifiers.get(0).classifySentence(tokens);
        int sz = output.size();
        for (i = 0; i < sz; ++i) {
            ((CoreMap)tokens.get(i)).set(CoreAnnotations.AnswerAnnotation.class, ((CoreMap)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class));
        }
        baseOutputs.add(tokens);
        sz = this.baseClassifiers.size();
        for (i = 1; i < sz; ++i) {
            output = this.baseClassifiers.get(i).classifySentence(tokens);
            baseOutputs.add(output);
        }
        assert (baseOutputs.size() == this.baseClassifiers.size());
        List<IN> finalAnswer = this.mergeDocuments(baseOutputs);
        return finalAnswer;
    }

    @Override
    public void train(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printProbsDocument(List<IN> document) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serializeClassifier(String serializePath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        ClassifierCombiner ec = new ClassifierCombiner(props);
        System.err.println(ec.classifyToString("Marketing : Sony Hopes to Win Much Bigger Market For Wide Range of Small-Video Products --- By Andrew B. Cohen Staff Reporter of The Wall Street Journal"));
    }
}

