/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.corpus;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLLoader;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.item.Item;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TestDependencyCorpus
extends TestCase {
    public void testConvert() throws Exception {
        LinkedList<CoNLLSentence> coNLLSentences = CoNLLLoader.loadSentenceList("D:\\Doc\\\u8bed\u6599\u5e93\\\u4f9d\u5b58\u5206\u6790\u8bad\u7ec3\u6570\u636e\\THU\\dev.conll.fixed.txt");
    }

    public void testPosTag() throws Exception {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        LinkedList<CoNLLSentence> coNLLSentences = CoNLLLoader.loadSentenceList("D:\\Doc\\\u8bed\u6599\u5e93\\\u4f9d\u5b58\u5206\u6790\u8bad\u7ec3\u6570\u636e\\THU\\dev.conll.fixed.txt");
        for (CoNLLSentence coNLLSentence : coNLLSentences) {
            CoNLLWord[] coNLLWordArray = coNLLSentence.word;
            int n = coNLLSentence.word.length;
            int n2 = 0;
            while (n2 < n) {
                CoNLLWord coNLLWord = coNLLWordArray[n2];
                dictionaryMaker.add(new Item(coNLLWord.POSTAG, coNLLWord.CPOSTAG));
                ++n2;
            }
        }
        System.out.println(dictionaryMaker.entrySet());
    }

    public void testMakeCRF() throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("D:\\Tools\\CRF++-0.58\\example\\dependency\\dev.txt")));
        LinkedList<CoNLLSentence> coNLLSentences = CoNLLLoader.loadSentenceList("D:\\Doc\\\u8bed\u6599\u5e93\\\u4f9d\u5b58\u5206\u6790\u8bad\u7ec3\u6570\u636e\\THU\\dev.conll.fixed.txt");
        for (CoNLLSentence coNLLSentence : coNLLSentences) {
            CoNLLWord[] coNLLWordArray = coNLLSentence.word;
            int n = coNLLSentence.word.length;
            int n2 = 0;
            while (n2 < n) {
                int i;
                CoNLLWord coNLLWord = coNLLWordArray[n2];
                bw.write(coNLLWord.NAME);
                bw.write(9);
                bw.write(coNLLWord.CPOSTAG);
                bw.write(9);
                bw.write(coNLLWord.POSTAG);
                bw.write(9);
                int d = coNLLWord.HEAD.ID - coNLLWord.ID;
                int posDistance = 1;
                if (d > 0) {
                    i = 1;
                    while (i < d) {
                        if (coNLLSentence.word[coNLLWord.ID - 1 + i].CPOSTAG.equals(coNLLWord.HEAD.CPOSTAG)) {
                            ++posDistance;
                        }
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i < -d) {
                        if (coNLLSentence.word[coNLLWord.ID - 1 - i].CPOSTAG.equals(coNLLWord.HEAD.CPOSTAG)) {
                            ++posDistance;
                        }
                        ++i;
                    }
                }
                bw.write(String.valueOf(d > 0 ? "+" : "-") + posDistance + "_" + coNLLWord.HEAD.CPOSTAG);
                bw.newLine();
                ++n2;
            }
            bw.newLine();
        }
        bw.close();
    }

    public void testMakeCRFTemplate() throws Exception {
        int j;
        LinkedHashSet<String> templateList = new LinkedHashSet<String>();
        int maxDistance = 4;
        int i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",0]");
            ++i;
        }
        i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",1]");
            ++i;
        }
        i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",2]");
            ++i;
        }
        String[] before = new String[maxDistance + 1];
        String[] after = new String[maxDistance + 1];
        before[0] = "%x[0,0]";
        after[0] = "";
        int i2 = 1;
        while (i2 <= maxDistance) {
            before[i2] = "%x[-" + i2 + ",0]/" + before[i2 - 1];
            after[i2] = String.valueOf(after[i2 - 1]) + "/%x[" + i2 + ",0]";
            ++i2;
        }
        i2 = 0;
        while (i2 <= maxDistance) {
            j = 0;
            while (j <= maxDistance) {
                templateList.add(String.valueOf(before[i2]) + after[j]);
                ++j;
            }
            ++i2;
        }
        before[0] = "%x[0,1]";
        after[0] = "";
        i2 = 1;
        while (i2 <= maxDistance) {
            before[i2] = "%x[-" + i2 + ",1]/" + before[i2 - 1];
            after[i2] = String.valueOf(after[i2 - 1]) + "/%x[" + i2 + ",1]";
            ++i2;
        }
        i2 = 0;
        while (i2 <= maxDistance) {
            j = 0;
            while (j <= maxDistance) {
                templateList.add(String.valueOf(before[i2]) + after[j]);
                ++j;
            }
            ++i2;
        }
        before[0] = "%x[0,2]";
        after[0] = "";
        i2 = 1;
        while (i2 <= maxDistance) {
            before[i2] = "%x[-" + i2 + ",2]/" + before[i2 - 1];
            after[i2] = String.valueOf(after[i2 - 1]) + "/%x[" + i2 + ",2]";
            ++i2;
        }
        i2 = 0;
        while (i2 <= maxDistance) {
            j = 0;
            while (j <= maxDistance) {
                templateList.add(String.valueOf(before[i2]) + after[j]);
                ++j;
            }
            ++i2;
        }
        int id = 0;
        StringBuilder sb = new StringBuilder();
        for (String template : templateList) {
            sb.append(String.format("U%d:%s\n", id, template));
            ++id;
        }
        System.out.println(sb.toString());
        IOUtil.saveTxt("D:\\Tools\\CRF++-0.58\\example\\dependency\\template.txt", sb);
    }

    public void testMakeSimpleCRFTemplate() throws Exception {
        LinkedHashSet<String> templateList = new LinkedHashSet<String>();
        int maxDistance = 4;
        int i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",0]");
            ++i;
        }
        i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",1]");
            ++i;
        }
        i = -maxDistance;
        while (i <= maxDistance) {
            templateList.add("%x[" + i + ",2]");
            ++i;
        }
        i = 1;
        while (i <= maxDistance) {
            templateList.add("%x[-" + i + ",0]/" + "%x[0,0]");
            templateList.add("%x[0,0]/%x[" + i + ",0]");
            templateList.add("%x[-" + i + ",1]/" + "%x[0,1]");
            templateList.add("%x[0,1]/%x[" + i + ",1]");
            templateList.add("%x[-" + i + ",2]/" + "%x[0,2]");
            templateList.add("%x[0,2]/%x[" + i + ",2]");
            ++i;
        }
        int id = 0;
        StringBuilder sb = new StringBuilder();
        for (String template : templateList) {
            sb.append(String.format("U%d:%s\n", id, template));
            ++id;
        }
        System.out.println(sb.toString());
        IOUtil.saveTxt("D:\\Tools\\CRF++-0.58\\example\\dependency\\template.txt", sb);
    }
}

