/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.dictionary.BiGramDictionary;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import java.util.TreeMap;
import junit.framework.TestCase;

public class TestDAT
extends TestCase {
    public void testSaveWithLessDisk() throws Exception {
        System.out.println(BiGramDictionary.getBiFrequency("\u7ecf\u6d4e@\u5efa\u8bbe"));
    }

    public void testTransmit() throws Exception {
        DoubleArrayTrie<CoreDictionary.Attribute> dat = CustomDictionary.dat;
        int index = dat.transition("\u9f99", 1);
        System.out.println(dat.output(index));
        index = dat.transition("\u7a9d", index);
        System.out.println(dat.output(index));
    }

    public void testCombine() throws Exception {
        DoubleArrayTrie<CoreDictionary.Attribute> dat = CustomDictionary.dat;
        String[] wordNet = new String[]{"\u4ed6", "\u4e00", "\u4e01", "\u4e0d", "\u8bc6", "\u4e00", "\u4e01", "\u5440"};
        int i = 0;
        while (i < wordNet.length) {
            int state = 1;
            if ((state = dat.transition(wordNet[i], state)) > 0) {
                int start = i;
                int to = i + 1;
                int end = -1;
                CoreDictionary.Attribute value = null;
                while (to < wordNet.length) {
                    if ((state = dat.transition(wordNet[to], state)) < 0) break;
                    CoreDictionary.Attribute output = dat.output(state);
                    if (output != null) {
                        value = output;
                        end = to + 1;
                    }
                    ++to;
                }
                if (value != null) {
                    StringBuilder sbTerm = new StringBuilder();
                    int j = start;
                    while (j < end) {
                        sbTerm.append(wordNet[j]);
                        ++j;
                    }
                    System.out.println(String.valueOf(sbTerm.toString()) + "/" + value);
                    i = end - 1;
                }
            }
            ++i;
        }
    }

    public void testHandleEmptyString() throws Exception {
        String emptyString = "";
        DoubleArrayTrie dat = new DoubleArrayTrie();
        TreeMap<String, String> dictionary = new TreeMap<String, String>();
        dictionary.put("bug", "\u95ee\u9898");
        dat.build(dictionary);
        DoubleArrayTrie.Searcher searcher = dat.getSearcher(emptyString, 0);
        while (searcher.next()) {
        }
    }
}

