/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.collection.MDAG.MDAGNode;
import com.hankcs.hanlp.collection.MDAG.MDAGSet;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

public class MDAGSetTest
extends TestCase {
    private static final String DATA_TEST_OUT_BIN = "data/test/out.bin";
    Set<String> validKeySet;
    Set<String> invalidKeySet;
    MDAGSet mdagSet;

    public void setUp() throws Exception {
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/custom/CustomDictionary.txt");
        this.validKeySet = new TreeSet<String>();
        while (iterator.hasNext()) {
            this.validKeySet.add(iterator.next().split("\\s")[0]);
        }
        this.mdagSet = new MDAGSet(this.validKeySet);
    }

    public void testSize() throws Exception {
        MDAGSetTest.assertEquals((int)this.validKeySet.size(), (int)this.mdagSet.size());
    }

    public void testContains() throws Exception {
        for (String key : this.validKeySet) {
            assert (this.mdagSet.contains(key)) : "\u672c\u6765\u5e94\u8be5\u6709 " + key;
        }
    }

    public void testNotContains() throws Exception {
        this.invalidKeySet = new TreeSet<String>();
        Random random = new Random(System.currentTimeMillis());
        this.mdagSet.simplify();
        this.mdagSet.unSimplify();
        while (this.invalidKeySet.size() < this.validKeySet.size()) {
            int length = random.nextInt(10) + 1;
            StringBuilder key = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                key.append(random.nextInt(65535));
                ++i;
            }
            if (this.validKeySet.contains(key.toString())) continue;
            this.invalidKeySet.add(key.toString());
        }
        for (String key : this.invalidKeySet) {
            MDAGSetTest.assertEquals((boolean)false, (boolean)this.mdagSet.contains(key));
        }
    }

    public void testToArray() throws Exception {
        String[] keyArray = this.mdagSet.toArray(new String[0]);
        MDAGSetTest.assertEquals((int)this.validKeySet.size(), (int)keyArray.length);
        String[] stringArray = keyArray;
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            MDAGSetTest.assertEquals((boolean)true, (boolean)this.mdagSet.contains(key));
            ++n2;
        }
    }

    public void testRemove() throws Exception {
        String[] keyArray;
        String[] stringArray = keyArray = this.mdagSet.toArray(new String[0]);
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.mdagSet.remove(key);
            MDAGSetTest.assertEquals((boolean)false, (boolean)this.mdagSet.contains(key));
            ++n2;
        }
    }

    public void testAdd() throws Exception {
        MDAGSetTest.assertEquals((boolean)true, (boolean)this.mdagSet.add("\u6210\u529f\u5566"));
        MDAGSetTest.assertEquals((boolean)true, (boolean)this.mdagSet.contains("\u6210\u529f\u5566"));
    }

    public void testSimplify() throws Exception {
        HashMap<MDAGNode, MDAGNode> equivalenceClassMDAGNodeHashMapBefore = this.mdagSet._getEquivalenceClassMDAGNodeHashMap();
        this.mdagSet.simplify();
        this.mdagSet.unSimplify();
        HashMap<MDAGNode, MDAGNode> equivalenceClassMDAGNodeHashMapAfter = this.mdagSet._getEquivalenceClassMDAGNodeHashMap();
        MDAGSetTest.assertEquals(equivalenceClassMDAGNodeHashMapBefore, equivalenceClassMDAGNodeHashMapAfter);
    }

    public void testSimplifyAndContains() throws Exception {
        this.mdagSet.simplify();
        this.testContains();
        this.testNotContains();
    }

    public void testSaveAndLoad() throws Exception {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(DATA_TEST_OUT_BIN));
        this.mdagSet.save(out);
        out.close();
        this.mdagSet = new MDAGSet();
        this.mdagSet.load(ByteArray.createByteArray(DATA_TEST_OUT_BIN));
        this.testContains();
        this.testNotContains();
    }

    public void testSingle() throws Exception {
        this.mdagSet.simplify();
        System.out.println(this.mdagSet.contains("\u7897\u53e3"));
    }

    public void testBenchmark() throws Exception {
        BinTrie<Boolean> binTrie = new BinTrie<Boolean>();
        for (String key : this.validKeySet) {
            binTrie.put(key, Boolean.valueOf(true));
        }
        long start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            MDAGSetTest.assertEquals((boolean)true, (boolean)((Boolean)binTrie.get(key)));
        }
        System.out.printf("binTrie\u7528\u65f6 %d ms\n", System.currentTimeMillis() - start);
        this.mdagSet.simplify();
        start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            MDAGSetTest.assertEquals((boolean)true, (boolean)this.mdagSet.contains(key));
        }
        System.out.printf("mdagSet\u7528\u65f6 %d ms\n", System.currentTimeMillis() - start);
    }

    public void testCommPrefix() throws Exception {
        MDAGSet setTwo = new MDAGSet(this.validKeySet);
        setTwo.simplify();
        for (String key : this.validKeySet) {
            MDAGSetTest.assertEquals(this.mdagSet.getStringsStartingWith(key), setTwo.getStringsStartingWith(key));
        }
    }
}

