/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.algoritm.MaxHeap;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.KeywordExtractor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextRankKeyword
extends KeywordExtractor {
    int nKeyword = 10;
    static final float d = 0.85f;
    static final int max_iter = 200;
    static final float min_diff = 0.001f;

    public static List<String> getKeywordList(String document, int size) {
        TextRankKeyword textRankKeyword = new TextRankKeyword();
        textRankKeyword.nKeyword = size;
        return textRankKeyword.getKeyword(document);
    }

    public List<String> getKeyword(String content) {
        Set<Map.Entry<String, Float>> entrySet = this.getTermAndRank(content, this.nKeyword).entrySet();
        ArrayList<String> result = new ArrayList<String>(entrySet.size());
        for (Map.Entry<String, Float> entry : entrySet) {
            result.add(entry.getKey());
        }
        return result;
    }

    public Map<String, Float> getTermAndRank(String content) {
        assert (content != null);
        List<Term> termList = this.defaultSegment.seg(content);
        return this.getRank(termList);
    }

    public Map<String, Float> getTermAndRank(String content, Integer size) {
        Map<String, Float> map = this.getTermAndRank(content);
        LinkedHashMap<String, Float> result = new LinkedHashMap<String, Float>();
        for (Map.Entry<String, Float> entry : new MaxHeap<Map.Entry<String, Float>>(size, new Comparator<Map.Entry<String, Float>>(){

            @Override
            public int compare(Map.Entry<String, Float> o1, Map.Entry<String, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }).addAll(map.entrySet()).toList()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, Float> getRank(List<Term> termList) {
        ArrayList<String> wordList = new ArrayList<String>(termList.size());
        for (Term t : termList) {
            if (!this.shouldInclude(t)) continue;
            wordList.add(t.word);
        }
        TreeMap words = new TreeMap();
        LinkedList<String> que = new LinkedList<String>();
        for (String w : wordList) {
            if (!words.containsKey(w)) {
                words.put(w, new TreeSet());
            }
            que.offer(w);
            if (que.size() > 5) {
                que.poll();
            }
            for (String w1 : que) {
                for (String w2 : que) {
                    if (w1.equals(w2)) continue;
                    ((Set)words.get(w1)).add(w2);
                    ((Set)words.get(w2)).add(w1);
                }
            }
        }
        HashMap<String, Float> score = new HashMap<String, Float>();
        int i = 0;
        while (i < 200) {
            HashMap<String, Float> m = new HashMap<String, Float>();
            float max_diff = 0.0f;
            for (Map.Entry entry : words.entrySet()) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                m.put(key, Float.valueOf(0.14999998f));
                for (String element : value) {
                    int size = ((Set)words.get(element)).size();
                    if (key.equals(element) || size == 0) continue;
                    m.put(key, Float.valueOf(((Float)m.get(key)).floatValue() + 0.85f / (float)size * (score.get(element) == null ? 0.0f : ((Float)score.get(element)).floatValue())));
                }
                max_diff = Math.max(max_diff, Math.abs(((Float)m.get(key)).floatValue() - (score.get(key) == null ? 0.0f : ((Float)score.get(key)).floatValue())));
            }
            score = m;
            if (max_diff <= 0.001f) break;
            ++i;
        }
        return score;
    }
}

