/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.bigram;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.dependency.model.WordNatureWeightModelMaker;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.TreeMap;

public class BigramDependencyModel {
    static DoubleArrayTrie<String> trie;

    static {
        long start = System.currentTimeMillis();
        if (BigramDependencyModel.load(HanLP.Config.WordNatureModelPath)) {
            Predefine.logger.info("\u52a0\u8f7d\u4f9d\u5b58\u53e5\u6cd5\u4e8c\u5143\u6a21\u578b" + HanLP.Config.WordNatureModelPath + "\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
        } else {
            Predefine.logger.warning("\u52a0\u8f7d\u4f9d\u5b58\u53e5\u6cd5\u4e8c\u5143\u6a21\u578b" + HanLP.Config.WordNatureModelPath + "\u5931\u8d25\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
        }
    }

    static boolean load(String path) {
        trie = new DoubleArrayTrie();
        if (BigramDependencyModel.loadDat(String.valueOf(path) + ".bi" + ".bin")) {
            return true;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String line : IOUtil.readLineListWithLessMemory(path)) {
            String[] param = line.split(" ");
            if (param[0].endsWith("@")) continue;
            String dependency = param[1];
            map.put(param[0], dependency);
        }
        if (map.size() == 0) {
            return false;
        }
        trie.build(map);
        if (!BigramDependencyModel.saveDat(path, map)) {
            Predefine.logger.warning("\u7f13\u5b58" + path + ".bin" + "\u5931\u8d25");
        }
        return true;
    }

    private static boolean loadDat(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path);
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        String[] valueArray = new String[size];
        int i = 0;
        while (i < valueArray.length) {
            valueArray[i] = byteArray.nextUTF();
            ++i;
        }
        return trie.load(byteArray, (String[])valueArray);
    }

    static boolean saveDat(String path, TreeMap<String, String> map) {
        DataOutputStream out;
        block4: {
            Collection<String> dependencyList = map.values();
            try {
                out = new DataOutputStream(new FileOutputStream(String.valueOf(path) + ".bi" + ".bin"));
                out.writeInt(dependencyList.size());
                for (String dependency : dependencyList) {
                    out.writeUTF(dependency);
                }
                if (trie.save(out)) break block4;
                return false;
            }
            catch (Exception e) {
                Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
                return false;
            }
        }
        out.close();
        return true;
    }

    public static String get(String key) {
        return trie.get(key);
    }

    public static String get(String fromWord, String fromPos, String toWord, String toPos) {
        String dependency = BigramDependencyModel.get(String.valueOf(fromWord) + "@" + toWord);
        if (dependency == null) {
            dependency = BigramDependencyModel.get(String.valueOf(fromWord) + "@" + WordNatureWeightModelMaker.wrapTag(toPos));
        }
        if (dependency == null) {
            dependency = BigramDependencyModel.get(String.valueOf(WordNatureWeightModelMaker.wrapTag(fromPos)) + "@" + toWord);
        }
        if (dependency == null) {
            dependency = BigramDependencyModel.get(String.valueOf(WordNatureWeightModelMaker.wrapTag(fromPos)) + "@" + WordNatureWeightModelMaker.wrapTag(toPos));
        }
        if (dependency == null) {
            dependency = "\u672a\u77e5";
        }
        return dependency;
    }
}

