/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.utility.Predefine;
import java.util.LinkedList;

public final class CRFSegmentModel
extends CRFModel {
    public static CRFModel crfModel;
    private static final int idM;
    private static final int idE;
    private static final int idS;

    static {
        Predefine.logger.info("CRF\u5206\u8bcd\u6a21\u578b\u6b63\u5728\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath);
        long start = System.currentTimeMillis();
        crfModel = CRFModel.loadTxt(HanLP.Config.CRFSegmentModelPath, new CRFSegmentModel(new BinTrie<FeatureFunction>()));
        if (crfModel == null) {
            Predefine.logger.severe("CRF\u5206\u8bcd\u6a21\u578b\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath + " \u5931\u8d25\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
            System.exit(-1);
        } else {
            Predefine.logger.info("CRF\u5206\u8bcd\u6a21\u578b\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath + " \u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        }
        idM = crfModel.getTagId("M");
        idE = crfModel.getTagId("E");
        idS = crfModel.getTagId("S");
    }

    private CRFSegmentModel() {
    }

    public CRFSegmentModel(ITrie<FeatureFunction> featureFunctionTrie) {
        super(featureFunctionTrie);
    }

    @Override
    public void tag(Table table) {
        int size = table.size();
        if (size == 1) {
            table.setLast(0, "S");
            return;
        }
        double[][] net = new double[size][4];
        int i = 0;
        while (i < size) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            int tag = 0;
            while (tag < 4) {
                net[i][tag] = CRFSegmentModel.computeScore(scoreList, tag);
                ++tag;
            }
            ++i;
        }
        net[0][CRFSegmentModel.idM] = -1000.0;
        net[0][CRFSegmentModel.idE] = -1000.0;
        int[][] from = new int[size][4];
        int i2 = 1;
        while (i2 < size) {
            int now = 0;
            while (now < 4) {
                double maxScore = -1.0E10;
                int pre = 0;
                while (pre < 4) {
                    double score = net[i2 - 1][pre] + this.matrix[pre][now] + net[i2][now];
                    if (score > maxScore) {
                        maxScore = score;
                        from[i2][now] = pre;
                    }
                    ++pre;
                }
                net[i2][now] = maxScore;
                ++now;
            }
            ++i2;
        }
        int maxTag = net[size - 1][idS] > net[size - 1][idE] ? idS : idE;
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        int i3 = size - 2;
        while (i3 > 0) {
            table.setLast(i3, this.id2tag[maxTag]);
            maxTag = from[i3][maxTag];
            --i3;
        }
        table.setLast(0, this.id2tag[maxTag]);
    }
}

