/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.common.Edge;
import com.hankcs.hanlp.dependency.common.Node;
import com.hankcs.hanlp.dependency.common.State;
import com.hankcs.hanlp.seg.common.Term;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public abstract class MinimumSpanningTreeParser
extends AbstractDependencyParser {
    @Override
    public CoNLLSentence parse(List<Term> termList) {
        if (termList == null || termList.size() == 0) {
            return null;
        }
        termList.add(0, new Term("##\u6838\u5fc3##", Nature.begin));
        Node[] nodeArray = new Node[termList.size()];
        Iterator<Term> iterator = termList.iterator();
        int i = 0;
        while (i < nodeArray.length) {
            nodeArray[i] = new Node(iterator.next(), i);
            ++i;
        }
        Edge[][] edges = new Edge[nodeArray.length][nodeArray.length];
        int i2 = 0;
        while (i2 < edges.length) {
            int j = 0;
            while (j < edges[i2].length) {
                if (i2 != j) {
                    edges[j][i2] = this.makeEdge(nodeArray, i2, j);
                }
                ++j;
            }
            ++i2;
        }
        int max_v = nodeArray.length * (nodeArray.length - 1);
        float[] mincost = new float[max_v];
        Arrays.fill(mincost, 1.1342745E38f);
        boolean[] used = new boolean[max_v];
        Arrays.fill(used, false);
        used[0] = true;
        PriorityQueue<State> que = new PriorityQueue<State>();
        float minCostToRoot = Float.MAX_VALUE;
        Edge firstEdge = null;
        Edge[] edgeResult = new Edge[termList.size() - 1];
        Edge[] edgeArray = edges[0];
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge = edgeArray[n2];
            if (edge != null && minCostToRoot > edge.cost) {
                firstEdge = edge;
                minCostToRoot = edge.cost;
            }
            ++n2;
        }
        if (firstEdge == null) {
            return null;
        }
        que.add(new State(minCostToRoot, firstEdge.from, firstEdge));
        while (!que.isEmpty()) {
            State p = (State)que.poll();
            int v = p.id;
            if (used[v] || p.cost > mincost[v]) continue;
            used[v] = true;
            if (p.edge != null) {
                edgeResult[p.edge.from - 1] = p.edge;
            }
            Edge[] edgeArray2 = edges[v];
            int n3 = edgeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Edge e = edgeArray2[n4];
                if (e != null && mincost[e.from] > e.cost) {
                    mincost[e.from] = e.cost;
                    que.add(new State(mincost[e.from], e.from, e));
                }
                ++n4;
            }
        }
        CoNLLWord[] wordArray = new CoNLLWord[termList.size() - 1];
        int i3 = 0;
        while (i3 < wordArray.length) {
            wordArray[i3] = new CoNLLWord(i3 + 1, nodeArray[i3 + 1].word, nodeArray[i3 + 1].label);
            wordArray[i3].DEPREL = edgeResult[i3].label;
            ++i3;
        }
        i3 = 0;
        while (i3 < edgeResult.length) {
            int index = edgeResult[i3].to - 1;
            wordArray[i3].HEAD = index < 0 ? CoNLLWord.ROOT : wordArray[index];
            ++i3;
        }
        return new CoNLLSentence(wordArray);
    }

    protected abstract Edge makeEdge(Node[] var1, int var2, int var3);
}

