/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone;

import com.hankcs.hanlp.collection.dartsclone.DoubleArray;
import com.hankcs.hanlp.collection.dartsclone.Pair;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DartMap<V>
extends DoubleArray
implements Map<String, V>,
ITrie<V> {
    V[] valueArray;

    public DartMap(List<String> keyList, V[] valueArray) {
        int[] indexArray = new int[valueArray.length];
        int i = 0;
        while (i < indexArray.length) {
            indexArray[i] = i;
            ++i;
        }
        this.valueArray = valueArray;
        this.build(keyList, indexArray);
    }

    public DartMap(TreeMap<String, V> map) {
        this.build(map);
    }

    public DartMap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key.toString());
    }

    @Override
    public boolean containsKey(String key) {
        return this.exactMatchSearch(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public V get(Object key) {
        return this.get(key.toString());
    }

    @Override
    public int build(TreeMap<String, V> keyValueMap) {
        int size = keyValueMap.size();
        int[] indexArray = new int[size];
        this.valueArray = keyValueMap.values().toArray();
        ArrayList<String> keyList = new ArrayList<String>(size);
        int i = 0;
        for (Map.Entry<String, V> entry : keyValueMap.entrySet()) {
            indexArray[i] = i;
            this.valueArray[i] = entry.getValue();
            keyList.add(entry.getKey());
            ++i;
        }
        this.build(keyList, indexArray);
        return 0;
    }

    @Override
    public boolean save(DataOutputStream out) {
        return false;
    }

    @Override
    public boolean load(ByteArray byteArray, V[] value) {
        return false;
    }

    @Override
    public V get(char[] key) {
        return this.get(new String(key));
    }

    @Override
    public V get(String key) {
        int id = this.exactMatchSearch(key);
        if (id == -1) {
            return null;
        }
        return this.valueArray[id];
    }

    @Override
    public V[] getValueArray(V[] a) {
        return this.valueArray;
    }

    public ArrayList<Pair<String, V>> commonPrefixSearch(String key, int offset, int maxResults) {
        byte[] keyBytes = key.getBytes(utf8);
        List<Pair<Integer, Integer>> pairList = this.commonPrefixSearch(keyBytes, offset, maxResults);
        ArrayList<Pair<String, V>> resultList = new ArrayList<Pair<String, V>>(pairList.size());
        for (Pair<Integer, Integer> pair : pairList) {
            resultList.add(new Pair<String, V>(new String(keyBytes, 0, (int)((Integer)pair.first)), this.valueArray[(Integer)pair.second]));
        }
        return resultList;
    }

    public ArrayList<Pair<String, V>> commonPrefixSearch(String key) {
        return this.commonPrefixSearch(key, 0, Integer.MAX_VALUE);
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u589e\u91cf\u5f0f\u63d2\u5165");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u5220\u9664");
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301\u589e\u91cf\u5f0f\u63d2\u5165");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }

    @Override
    public Collection<V> values() {
        return Arrays.asList(this.valueArray);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException("\u53cc\u6570\u7ec4\u4e0d\u652f\u6301");
    }
}

