/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.demo;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.common.Term;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class DemoSegment {
    public static void main(String[] args) {
        String[] testCase = new String[]{"\u5546\u54c1\u548c\u670d\u52a1", "\u7ed3\u5a5a\u7684\u548c\u5c1a\u672a\u7ed3\u5a5a\u7684\u786e\u5b9e\u5728\u5e72\u6270\u5206\u8bcd\u554a", "\u4e70\u6c34\u679c\u7136\u540e\u6765\u4e16\u535a\u56ed\u6700\u540e\u53bb\u4e16\u535a\u4f1a", "\u4e2d\u56fd\u7684\u9996\u90fd\u662f\u5317\u4eac", "\u6b22\u8fce\u65b0\u8001\u5e08\u751f\u524d\u6765\u5c31\u9910", "\u5de5\u4fe1\u5904\u5973\u5e72\u4e8b\u6bcf\u6708\u7ecf\u8fc7\u4e0b\u5c5e\u79d1\u5ba4\u90fd\u8981\u4eb2\u53e3\u4ea4\u4ee324\u53e3\u4ea4\u6362\u673a\u7b49\u6280\u672f\u6027\u5668\u4ef6\u7684\u5b89\u88c5\u5de5\u4f5c", "\u968f\u7740\u9875\u6e38\u5174\u8d77\u5230\u73b0\u5728\u7684\u9875\u6e38\u7e41\u76db\uff0c\u4f9d\u8d56\u4e8e\u5b58\u6863\u8fdb\u884c\u903b\u8f91\u5224\u65ad\u7684\u8bbe\u8ba1\u51cf\u5c11\u4e86\uff0c\u4f46\u8fd9\u5757\u4e5f\u4e0d\u80fd\u5b8c\u5168\u5ffd\u7565\u6389\u3002", "\u4e2d\u56fd\u94c1\u5efa\u80a1\u4efd\u6709\u9650\u516c\u53f8\u4eca\u5e74\u5b8c\u6210\u9500\u552e\u989d5\u5343\u4ebf\u4eba\u6c11\u5e01\uff0c\u4f46\u662f\u62d6\u6b20\u5de5\u8d44\uff0c\u674e\u4e1c\u4eae\u7ed9\u529b\u3002"};
        CustomDictionary.add("\u4e2d\u56fd\u94c1\u5efa\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        String[] stringArray = testCase;
        int n = testCase.length;
        int n2 = 0;
        while (n2 < n) {
            String sentence = stringArray[n2];
            List<Term> termList = HanLP.segment(sentence);
            System.out.println(termList);
            ++n2;
        }
        DemoSegment.buildStopc();
    }

    public static void buildStopc() {
        String hanlpStopc = "D:\\work\\project\\java\\worker\\data\\dictionary\\stopwords.txt";
        String ourStopc = "D:\\work\\project\\java\\worker\\data\\stopc";
        List<String> osentenceList = DemoSegment.readFile(ourStopc);
        List<String> hsentenceList = DemoSegment.readFile(hanlpStopc);
        ArrayList<String> result = new ArrayList<String>();
        for (String sentence : hsentenceList) {
            if (result.contains(sentence)) continue;
            result.add(sentence);
        }
        for (String sentence : osentenceList) {
            if (result.contains(sentence)) continue;
            result.add(sentence);
        }
        for (String sentence : result) {
            System.out.println(sentence);
        }
    }

    public static List<String> readFile(String fileName) {
        ArrayList<String> sentenceList = new ArrayList<String>();
        try {
            File f = new File(fileName);
            if (f.isFile() && f.exists()) {
                String line;
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                BufferedReader reader = new BufferedReader(read);
                while ((line = reader.readLine()) != null) {
                    sentenceList.add(line);
                }
                read.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sentenceList;
    }
}

