package com.zzsn.search.yaooThread;

import com.zzsn.search.FileUtil;
import com.zzsn.search.entity.KeywordMsg;
import com.zzsn.utility.index.Constants;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 百度搜索
 * 1.根据关键词请求进入页面，
 * 2.将抓取到的内容信息保存到本地数据库表
 */
public class WebYahooSearch {

    public static void main(String[] args) throws IOException {
//        String filepath=args[0];

        String filepath= Constants.META_SEARCH_KEYWORDPATH;
        String startTime="2018-04-18";
        String endTime="2019-04-18";
        startTime=dateToStamp(startTime);
        endTime=dateToStamp(endTime);
        File f = new File(filepath);
        List<String> allLines = FileUtil.getFileLines(f, "utf-8");
        WebYahooSearchThread baiduSearchThread = new WebYahooSearchThread();
        paser(allLines,startTime,endTime);
    }
    public static String dateToStamp(String s)  {
        String res="";
        //设置时间模版
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = simpleDateFormat.parse(s);
            long ts = date.getTime()/1000;
            res = String.valueOf(ts);
        }catch (Exception e){

        }

        return res;
    }
    public static void paser(List<String> keywords,String startTime,String endTime){
        List<List<String>> splitList = splitList(keywords,5000);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Vector<WebYahooSearchThread> workers = new Vector<WebYahooSearchThread>();
        int index = 0;
        try {
            for (List<String> keywordList : splitList) {
                WebYahooSearchThread webYahooSearchThread = new WebYahooSearchThread();
                webYahooSearchThread.setThreadId(index++);
                webYahooSearchThread.setKeywords(keywordList);
                webYahooSearchThread.setStartTime(startTime);
                webYahooSearchThread.setEndTime(endTime);
                KeywordMsg keywordMsg=new KeywordMsg();
                keywordMsg.setId("123456");

                keywordMsg.setStartTime(Long.parseLong(startTime));
                keywordMsg.setEndTime(Long.parseLong(endTime));
                webYahooSearchThread.setKeywordMsg(keywordMsg);

                workers.add(webYahooSearchThread);
                threadPool.execute(webYahooSearchThread);
                Thread.sleep(1000);
            }
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        threadPool.shutdown();
        while (true) {
            boolean isfinished = threadPool.isTerminated();
            if (isfinished)
                break;
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                System.out.println(e.getMessage());
            }
        }

    }

    //  对list进行分割
    public static <T> List<List<T>>  splitList(List<T> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        List<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; i++) {
            List<T> subList = list.subList(i * len, ((i + 1) * len > size ? size : len * (i + 1)));
            result.add(subList);
        }
        return result;
    }

}
