package com.zzsn.util;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 发布日期匹配
 * 创建人：李东亮   
 * 创建时间：2016-7-29 下午1:54:35   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class PublishDateUtil {
    
    private static Pattern patDate0 = Pattern.compile("\\d+-\\d{1,2}-\\d{1,2}");

    private static Pattern patDate1 = Pattern.compile("\\d+[-\\s/年月日]\\d{1,2}-\\d{1,2}", Pattern.CASE_INSENSITIVE);

    private static Pattern patDate2 = Pattern.compile("\\d+\\s+[A-Z][a-z]+\\s+\\d{1,4}");

    private static Pattern patDate3 = Pattern.compile("[A-Z][a-z\\.]+\\s+\\d{1,2},\\s+\\d{1,4}");

    private static Pattern patDate4 = Pattern.compile("\\d+年[\\s|　]*\\d+月[\\s|　]*\\d{1,2}日");

    private static Pattern patDate5 = Pattern.compile("\\d+/\\d{1,2}/\\d{1,4}");

    private static Pattern patDate6 = Pattern.compile("\\d{4}\\.\\d{2}\\.\\d{2}");

    private static Pattern patDate7 = Pattern.compile("[A-Z][a-z\\.]+\\s+\\d{1,2}(st|nd|rd|th)?\\s*,\\s+\\d{1,4}");
    
    public static Pattern patDate8 = Pattern.compile("[A-Z][a-z\\.]+\\s+[A-Z][a-z\\.]+-\\d{1,2}\\s*\\d+\\s*(\\d{2}:\\d{2}:\\d{2})*");
    
    public static Pattern patDate9 = Pattern.compile("[A-Z][a-z\\.]+-\\d{1,2}\\s*\\d+\\s*(\\d{2}:\\d{2}:\\d{2})*");
   
    private static Pattern patDate10 = Pattern.compile("\\d{2}\\.\\d{2}\\.\\d{4}");
    public static Pattern patDate11 = Pattern.compile("\\d{2}\\s+[A-Za-z]+, \\s*\\d{4}");
    public static Pattern patDate11_1 = Pattern.compile("[A-Za-z]+\\s+\\d{2}, \\s*\\d{4}");
    //匹配01-Oct-2015 02:42 EDT
    private static Pattern patDate12 = Pattern.compile("\\d{2}-[A-Za-z]{3}-\\d{4}(\\s+\\d{2}:\\d{2})?");
    
    private static SimpleDateFormat formatter0 = new SimpleDateFormat("yyyy-MM-dd");

    private static SimpleDateFormat formatter0_1 = new SimpleDateFormat("yy-MM-dd");

    private static SimpleDateFormat formatter2 = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);

    private static SimpleDateFormat formatter3_1 = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);

    private static SimpleDateFormat formatter3_2 = new SimpleDateFormat("MMM. dd, yyyy", Locale.ENGLISH);

    private static SimpleDateFormat formatter4 = new SimpleDateFormat("yyyy年MM月dd");

    private static SimpleDateFormat formatter5_1 = new SimpleDateFormat("yyyy/MM/dd");

    private static SimpleDateFormat formatter5_2 = new SimpleDateFormat("dd/MM/yyyy");

    private static SimpleDateFormat formatter5_4 = new SimpleDateFormat("yy/MM/dd");

    private static SimpleDateFormat formatter5_3 = new SimpleDateFormat("dd/MM/yy");

    private static SimpleDateFormat formatter6 = new SimpleDateFormat("yyyy.MM.dd");
    
    private static SimpleDateFormat formatter7 =  new SimpleDateFormat("MMMM d'st', yyyy",Locale.ENGLISH);
    private static SimpleDateFormat formatter7_1 =  new SimpleDateFormat("MMMM d'nd', yyyy",Locale.ENGLISH);
    private static SimpleDateFormat formatter7_2 =  new SimpleDateFormat("MMMM d'rd', yyyy",Locale.ENGLISH);
    private static SimpleDateFormat formatter7_3 =  new SimpleDateFormat("MMMM d'th', yyyy",Locale.ENGLISH);
    private static SimpleDateFormat formatter7_4 =  new SimpleDateFormat("MMMM d, yyyy",Locale.ENGLISH);
    
    public static SimpleDateFormat formatter8 =  new SimpleDateFormat("EEEE MMM-dd yyyy HH:mm:ss",Locale.ENGLISH);
    public static SimpleDateFormat formatter8_1 =  new SimpleDateFormat("EEEE MMM-dd yyyy",Locale.ENGLISH);
    public static SimpleDateFormat formatter8_2 =  new SimpleDateFormat("MMM-dd yyyy",Locale.ENGLISH);
    public static SimpleDateFormat formatter10 =  new SimpleDateFormat("dd.MM.yyyy");
    public static SimpleDateFormat formatter11 =  new SimpleDateFormat("dd MMM, yyyy",Locale.ENGLISH);
    public static SimpleDateFormat formatter11_1 =  new SimpleDateFormat("MMM dd, yyyy",Locale.ENGLISH);
    public static SimpleDateFormat formatter12 =  new SimpleDateFormat("dd-MMM-yyyy HH:mm",Locale.ENGLISH);
    public static SimpleDateFormat formatter12_1 =  new SimpleDateFormat("dd-MMM-yyyy",Locale.ENGLISH);
    private static Date thresholdDate = null;
    
    
    /**
     * 获取标准的本地时间
     * 创建人:  李东亮  
     * 创建时间:  2015-7-2 上午10:32:25 
     * @version 1.0
     * @param raw
     * @return
     */
    public  static  String  getPublishDate(String raw){
        if(raw==null){
            return null;
        }
        Date date = PublishDateUtil.transDate(raw);
       if(date!=null){
           Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Asia/Shanghai"));
            c.setTime(date);
            Pattern p = Pattern.compile("(\\d{1,2})[:|：](\\d{1,2})([:|：]\\d{1,2}){0,1}");
            Matcher m = p.matcher(raw);
            while(m.find()){
                String hour = m.group(1);
                if(hour!=null){
                    c.set(Calendar.HOUR_OF_DAY, Integer.valueOf(hour));
                }
                String minute = m.group(2);
                if(minute!=null){
                    c.set(Calendar.MINUTE, Integer.valueOf(minute));
                }
                String second = m.group(3);
                if(second!=null){
                    c.set(Calendar.SECOND, Integer.valueOf(second.replaceAll(":|：", "")));
                }
            }
            
            Date now = new Date();
            if(c.getTimeInMillis()>now.getTime()){
                c.setTime(now);
            }
            return  DateUtil.format(c.getTime(),"yyyy-MM-dd HH:mm:ss");
       }else
       {
           return null;
       }
    }

    public static Date transDate(String content) {
        content = content.replaceAll("[\\s|　]+", " ");
        content = content.replaceAll("^[\\s|　]+|[\\s|　]+$", "");
        try {
            Matcher dateMatcher = null;
            Date date = null;
            if (((dateMatcher = patDate0.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 0)) != null))
                    || ((dateMatcher = patDate1.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 1)) != null))
                    || ((dateMatcher = patDate2.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 2)) != null))
                    || ((dateMatcher = patDate3.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 3)) != null))
                    || ((dateMatcher = patDate4.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 4)) != null))
                    || ((dateMatcher = patDate5.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 5)) != null))
                    || ((dateMatcher = patDate6.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 6)) != null))
                    || ((dateMatcher = patDate7.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 7)) != null))
                    || ((dateMatcher = patDate8.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 8)) != null))
                    || ((dateMatcher = patDate9.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 8)) != null))
                    || ((dateMatcher = patDate10.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 10)) != null))
                    || ((dateMatcher = patDate11.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 11)) != null))
                    || ((dateMatcher = patDate11_1.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 11)) != null))
                     || ((dateMatcher = patDate12.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 12)) != null))
                    ) {
                return date;
            }
            return null;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * 解析，不抛异常
     * 创建人:  李东亮  
     * 创建时间:  2016-7-29 下午3:31:15 
     * @version 1.0
     * @param sdf
     * @param content
     * @return
     */
    private static Date parse(SimpleDateFormat sdf,String content){
        try {
            return sdf.parse(content);
        } catch (ParseException e) {
            // TODO Auto-generated catch block
           return null;
        }
    }
    
    public static Date transDate(String source, int type) {
        try {

            if (thresholdDate == null) {
                thresholdDate = formatter0.parse("1970-01-01");
            }
            Date date = null;
            switch (type) {
            case 0:
                date =parse(formatter0,source);
                if (date.before(thresholdDate)) {
                    date =parse(formatter0_1,source);
                    if (date.before(thresholdDate)) {
                        return null;
                    }
                }

                break;
            case 1:
                //date = formatter1.parse(source);
                break;
            case 2:
                date =parse(formatter2,source);
                break;
            case 3:
                    date =parse(formatter3_1,source);
                if (date == null) {
                    date =parse(formatter3_2,source);
                }
                break;
            case 4:
                date =parse(formatter4,source);
                break;
            case 5:
                try {
                    date =parse(formatter5_1,source);
                } catch (Exception e) {
                    date = null;
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter5_2,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter5_3,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter5_4,source);
                }
                break;
            case 6:
                date =parse(formatter6,source);
                break;
            case 7:
                date =parse(formatter7,source);
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter7_1,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter7_2,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter7_3,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter7_4,source);
                }
                break;
            case 8:
                date =parse(formatter8,source); 
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter8_1,source);
                }
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter8_2,source);
                }
                break;
            case 10:
                date =parse(formatter10,source); 
                break;
            case 11:
                date =parse(formatter11,source); 
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter11_1,source);
                }
                break;
            case 12:
                date =parse(formatter12,source); 
                if ((date == null) || (date.before(thresholdDate))) {
                    date =parse(formatter12_1,source);
                }
                break;
            }

            if ((date != null) && (date.before(thresholdDate))) {
                return null;
            }

            return date;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * 格式化JANUARY 15TH, 2016这种类型的时间
     * 创建人:  李东亮  
     * 创建时间:  2016-5-12 上午10:52:09 
     * @version 1.0
     * @param dateStr
     * @return
     */
    public static  String formatUSDate(String  dateStr){
        Date date = null;
        SimpleDateFormat sdf1 =  new SimpleDateFormat("MMMM d'st', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf2 =  new SimpleDateFormat("MMMM d'nd', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf3 =  new SimpleDateFormat("MMMM d'rd', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf4 =  new SimpleDateFormat("MMMM d'th', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf6 =  new SimpleDateFormat("MMMM d, yyyy",Locale.ENGLISH);
        try {
            date = sdf1.parse(dateStr);
        } catch (ParseException e) {
            try {
                date = sdf2.parse(dateStr);
            } catch (ParseException e1) {
                try {
                    date = sdf3.parse(dateStr);
                } catch (ParseException e2) {
                    try {
                        date = sdf4.parse(dateStr);
                    } catch (ParseException e3) {
                        try {
                            date = sdf6.parse(dateStr);
                        } catch (ParseException e4) {
                            // TODO Auto-generated catch block
                            e4.printStackTrace();
                        }
                    }
                }
            }
        }
        if(date!=null){
            SimpleDateFormat sdf5 = new SimpleDateFormat("yyyy-MM-dd");
            return  sdf5.format(date);
        }
        return null;
    }
    
    public static void main(String[] args) throws ParseException {
//        Pattern p =Pattern.compile("\\d{1,2}月\\d{1,2}日（[\u4e00-\u9fa5]）\\d{1,2}時\\d{1,2}分");
//        Matcher m = p.matcher("8月31日（水）14時25分");
//        if(m.find()){
//            System.out.println(m.group());
//            String str = m.group().replaceAll("（[\u4e00-\u9fa5]）", "");
//            SimpleDateFormat sdf = new SimpleDateFormat("MM月dd日HH時mm分");
//            System.out.println(sdf.parse(str));
//        }
    	//  || ((dateMatcher = patDate11_1.matcher(content)).find() && ((date = PublishDateUtil.transDate(dateMatcher.group(), 11)) != null))
        String str1= PublishDateUtil.getPublishDate("September 2nd, 2016");
        System.out.println(str1);
        String str2= PublishDateUtil.getPublishDate("Jan 10, 2020 - 12:50 am");
        System.out.println(str2);
        Matcher p=patDate11.matcher("10 Jan, 2020 - 12:50 am");
        boolean b=p.find();
        System.out.println(b);
        Pattern patDate11 = Pattern.compile("\\d{2}\\s+[A-Za-z]+, \\s*\\d{4}");
       Pattern patDate11_11 = Pattern.compile("[A-Za-z]+\\s+\\d{2}, \\s*\\d{4}");
        Pattern s = patDate11_11;
        Matcher ss=s.matcher("Jan 10, 2020 - 12:50 am");
        boolean sss=ss.find();
        System.out.println(sss);
        Pattern patDate7 = Pattern.compile("[A-Z][a-z\\.]+\\s+\\d{1,2}(st|nd|rd|th)?\\s*,\\s+\\d{1,2}");
    }
    
}
