package com.zzsn.orc;

import com.baidu.aip.ocr.AipOcr;
import com.jayway.jsonpath.JsonPath;
import org.json.JSONObject;


import javax.xml.xpath.XPathExpressionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * 使用百度OCR能力
 */

public class BaiduOCR {
	public static AipOcr client;
	private static Config config = Config.getInstance();

	private static void getClinet() {
		String appID = config.getBAIDU_APP_ID();
		String apiKey = config.getBAIDU_API_KEY();
		String secretKey = config.getBAIDU_SECRET_KEY();
		client = new AipOcr(appID, apiKey, secretKey);
	}

	public static List<List<String>> ocr() {
		if (client == null)
			getClinet();

		return null;
	}

	public static void pasemsgOut(List<String> resList) {
		for (int i = 0; i < resList.size(); i++) {
			pasermsgJson(resList.get(i));
		}

	}

	/**
	 * 解析API返回json结果
	 * 
	 * @param pageBody
	 * @return
	 */
	public static List<String> pasermsgJson(String pageBody) {
		List<String> reslist = new ArrayList<String>();
		if (pageBody.contains("\"words_result\":[")) {
			Iterator<? extends Object> jsonBooks;
			try {
				jsonBooks = JsonPageParser.parserJsonObjIterator(pageBody, "$.words_result[*]");
				while (jsonBooks.hasNext()) {
					Object jsonBook = jsonBooks.next();
					String m_s_name = JsonPath.read(jsonBook, "$.words");
					reslist.add(m_s_name);
				}

			} catch (XPathExpressionException e) {
				e.printStackTrace();
			}
		}

		return reslist;
	}

	public static String imageOcr(String imagePath, AipOcr client) {
		HashMap<String, String> options = new HashMap<String, String>();
		options.put("detect_direction", "false");
		options.put("probability", "false");
		JSONObject res = client.basicAccurateGeneral(imagePath, options);
		String rest = paserJson(res.toString());
		return rest;
	}
	public static String imageOcr(byte[] imageByte) {
		BaiduOCR.getClinet();
		HashMap<String, String> options = new HashMap<String, String>();
		options.put("detect_direction", "false");
		options.put("probability", "false");
		JSONObject res = client.basicAccurateGeneral(imageByte, options);
//		System.out.println(res.toString(2));
	//	String rest = paserJson(res.toString());
		return res.toString();
	}
	//通用识别
	public static String imageBasicGeneralOcr(byte[] imageByte) {
		BaiduOCR.getClinet();
		HashMap<String, String> options = new HashMap<String, String>();
		options.put("detect_direction", "false");
		options.put("probability", "false");
		JSONObject res = client.basicGeneral(imageByte, options);
//		System.out.println(res.toString(2));
		//	String rest = paserJson(res.toString());
		return res.toString();
	}

	/**
	 * 解析API返回json结果
	 * 
	 * @param pageBody
	 * @return
	 */
	public static String paserJson(String pageBody) {
		StringBuffer ress = new StringBuffer();
		if (pageBody.contains("\"words_result\":[")) {
			Iterator<? extends Object> jsonBooks;
			try {
				jsonBooks = JsonPageParser.parserJsonObjIterator(pageBody, "$.words_result[*]");
				while (jsonBooks.hasNext()) {
					Object jsonBook = jsonBooks.next();
					String m_s_name = JsonPath.read(jsonBook, "$.words");
					ress.append(m_s_name);
				}

			} catch (XPathExpressionException e) {
				e.printStackTrace();
			}
		}

		return ress.toString();
	}

}
