package com.zzsn.cache;

import com.zzsn.util.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.util.Set;

public class JedisFactory {

	private static final Logger Log = LoggerFactory.getLogger(JedisFactory.class);
	private static final Logger logger = LoggerFactory.getLogger(JedisUtil.class);
	private static JedisPool jedisPool = null;

	public static void  init(){
        String host = Constants.REDIS_LOCALHOST;
        String port = Constants.REDIS_PORT;
        String pass = Constants.REDIS_PASS;
        String timeout = Constants.REDIS_TIMEOUT;
        String maxIdle = Constants.REDIS_MAXIDLE;
        String maxTotal = Constants.REDIS_MAXIDLE;
        String maxWaitMillis = Constants.REDIS_MAXWAITMILLIS;
        String testOnBorrow = Constants.REDIS_TESTONBORROW;
 
        JedisPoolConfig config = new JedisPoolConfig();
        //控制一个pool可分配多少个jedis实例，通过pool.getResource()来获取；
        //如果赋值为-1，则表示不限制；如果pool已经分配了maxActive个jedis实例，则此时pool的状态为exhausted(耗尽)。
        config.setMaxTotal(Integer.parseInt(maxTotal));
        //控制一个pool最多有多少个状态为idle(空闲的)的jedis实例。
        config.setMaxIdle(Integer.parseInt(maxIdle));
        //表示当borrow(引入)一个jedis实例时，最大的等待时间，如果超过等待时间，则直接抛出JedisConnectionException；
        config.setMaxWaitMillis(Long.parseLong(maxWaitMillis));
        //在borrow一个jedis实例时，是否提前进行validate操作；如果为true，则得到的jedis实例均是可用的；
        config.setTestOnBorrow(Boolean.valueOf(testOnBorrow));
        jedisPool = new JedisPool(config, host, Integer.parseInt(port), Integer.parseInt(timeout));
	}
	

	
    
    
  
    public  static String getKeyStr(String key) {
    	Jedis jedis=getJedis();
    	try {
    		if (StringUtils.isEmpty(key)) {
                return null;
            }
            return jedis.get( key);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		}
    	return null;
    }
    
    private static Jedis getJedis() {
        return jedisPool.getResource();
    }
    /**
     * 设置缓存  永不过期，（一个月后会自动过期）
     * @param key
     * @return
     */
    public static boolean setKeyStr(String key, String value) {
    	Jedis jedis=getJedis();
    	boolean result = false;
    	try {
    		
    		 if (StringUtils.isEmpty(key)) {
    	           return false;
    	        }
    	 
    		 jedis.set(key, value);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		/*	if (!client.isShutdown()) {
				try {
					client.shutdown();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}*/
		}
    	return result;
    }
    
    
    public static boolean setKeyStrtime(String key, String value,Integer time) {
    	Jedis jedis=getJedis();
    	boolean result = false;
    	try {
    		
    		 if (StringUtils.isEmpty(key)) {
    	           return false;
    	        }
    	 
    		jedis.set(key, value);
    		 
    		 if (time > 0) {
    	            /**
    	             * 如果设置了 expireTime， 那么这个 finalKey会在expireTime秒后过期,那么该键会被自动删除
    	             * 这一功能配合出色的性能让Redis可以作为缓存系统来使用，成为了缓存系统Memcached的有力竞争者
    	             */
    			 jedis.expire(key,  time);
    	        }
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		}
    	return result;
    }
    public  static Set<String> getKeySet(String key) {
    	Jedis jedis=getJedis();
    	try {
    		Set<String> obj = jedis.smembers(key);
			if("null".equals(obj)){
			    return null;
			}
			return obj;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		}
    	return null;
    }
    
    
    /**
     * 设置缓存  永不过期，（一个月后会自动过期）
     * @param key
     * @return
     */
    public static boolean setKeySet(String key, Set<String> value) {
    	Jedis jedis=getJedis();
    	boolean result = false;
    	try {
    		if(value==null){
    			return false;
    		}
    		jedis.sadd(key, value.toArray(new String[value.size()]));
		} catch (Exception e){
			e.printStackTrace();
		} finally {
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		}
    	return result;
    }
    public static void del(String key)  {
    	Jedis jedis=getJedis();
        try {
			if (StringUtils.isEmpty(key)) {
			    logger.error("key is null");
			    return;
			}
			jedis.del(key);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			if (jedis != null) {

				// 如果使用 JedisPool ， close 操作不是关闭连接，代表归还连接池

				jedis.close();

				}
		}
		
        
    }

}
