package com.zzsn.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 日期帮助类
 * @author 李东亮
 * @date 2014-7-16 上午10:03:38
 * @company 郑州怡晟电子商务有限公司
 */
public class DateUtil
{
	private static String defDtPtn = "yyyy-MM-dd HH:mm:ss";// 缺省日期格式
	
	public static String getFirstDayOfMonth(Date date){
		String str = "";    
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");        
		Calendar lastDate = Calendar.getInstance();
		lastDate.setTime(date);
		lastDate.set(Calendar.DATE,1);//设为当前月的1号    
		str=sdf.format(lastDate.getTime());    
		return str;
	}
	public static String tiemString2String(String string, boolean withtime)
	{
		if (string == null || string.equals(""))
			return null;
		try {
			Long timeL=Long.parseLong(string);
		} catch (NumberFormatException e1) {
			return null;
		}
		Date d=new Date(Long.parseLong(string));
		String ts = null;
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			try
			{
				return 	sdf.format(d);
			} catch (Exception e)
			{

			}
			return null;
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			try
			{
				return 	sdf.format(d);
			} catch (Exception e)
			{

			}
			return null;
		}
	}

	public static String formatString(Date value, String format)
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat(format);//格式化时间 
 	  
	   String nowtime=sdf.format(value);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
    // 根据身份证号获取生日
    public static Date getBirthDay(String IDStr) {
    	String Ai = "";
    	Date date = null;
    	if (IDStr.length() == 18) {
            Ai = IDStr.substring(0, 17);
        } else if (IDStr.length() == 15) {
            Ai = IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
        }
	    String strYear  = Ai.substring(6, 10);// 年份
        String strMonth = Ai.substring(10, 12);// 月份
        String strDay   = Ai.substring(12, 14);// 月份 
         try {
			SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
			date = s.parse(strYear+"-"+strMonth+"-"+strDay);
		} catch (Exception e) { 
			e.printStackTrace();
		}
    	return date;
    }
    
    public static String format(String value) throws Exception
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");//格式化时间 
 	   Date date = sdf.parse(value);
	   String nowtime=sdf.format(date);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
    
    public static int getGL(String strDate){ 
    	int gl = 0;
    	Date cjYear = null;
    	 try {
 			SimpleDateFormat s = new SimpleDateFormat("yyyy/MM/dd"); 
 			cjYear = s.parse(strDate);
 			Calendar cal = Calendar.getInstance();
 	        cal.setTime(cjYear); 
 			gl = Calendar.getInstance().get(Calendar.YEAR)-cal.get(Calendar.YEAR)+1;
 		} catch (Exception e) { 
 			e.printStackTrace();
 		} 
    	return gl;
    }
	public static String getNextMonthFirst(Date date){
	      String str = "";    
	      SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");        
	      Calendar lastDate = Calendar.getInstance();
	      lastDate.setTime(date);
	      lastDate.add(Calendar.MONTH,1);//减一个月    
	      lastDate.set(Calendar.DATE, 1);//把日期设置为当月第一天     
	      str=sdf.format(lastDate.getTime());    
	      return str;      
	}
	public static int compareTime(String time1, String time2)
	{
		int result = 0;
		try
		{
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
			Date date1 = df.parse(time1);
			Date date2 = df.parse(time2);
			result = date1.compareTo(date2);
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return result;
	}

	public static String format(String time, String from_format, String to_format)
	{
		SimpleDateFormat sdf = null;
		Date date = null;
		if (time != null && !"".equals(time))
		{
			sdf = new SimpleDateFormat(from_format);
			try
			{
				date = sdf.parse(time);
			} catch (ParseException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (date != null)
			{
				sdf = new SimpleDateFormat(to_format);
			}
		}
		return sdf.format(date);
	}

	 /**
	  * 获取当前年
	  * @return
	  */
	public static String getCurrentYear(){
         String format = "yyyy";
		return DateUtil.format(new Date(), format);
	}
	
	 /**
	  * 获取当前月份
	  * @return
	  */
	public static String getCurrentMonth(){
		Calendar cal = Calendar.getInstance();
		int month = cal.get(Calendar.MONTH) + 1;
		return String.valueOf(month);
	}
	
	 /**
	  * 获取当前年月份
	  * @return
	  */
	public static String getCurrentYearMonth(){
		String format = "yyyy";
		String year = DateUtil.format(new Date(), format);
		
		Calendar cal = Calendar.getInstance();
		int month = cal.get(Calendar.MONTH) + 1;
		return year + "-" + month;
	}
	
	/**
	 * 获取当前日期
	 * @return
	 */
	public static String getCreateDate(){
		
		String format = "yyyy-MM-dd HH:mm:ss";
		
		return DateUtil.format(new Date(), format);
	}
	public static String format(Date d )
	{
		String format = "yyyy-MM-dd HH:mm:ss";
	
		return DateUtil.format(d, format);
	}
	public static String format(Date d, String format)
	{
		if (d == null)
			return "";
		SimpleDateFormat myFormatter = new SimpleDateFormat(format);
		return myFormatter.format(d);
	}
    public static String formatString(Date value)
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");//格式化时间 
 	  
	   String nowtime=sdf.format(value);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
	/**
	 * 格式化给定时间
	 * 
	 * @param date
	 *            需要格式化的时间
	 * @return 给定时间的格式化字符串(如：2008-11-22)
	 */
	public static String formatDate(Date date)
	{
		return new Date(date.getTime()).toString();
	}
	public final static String getDayOfWeekCn1(String dateStr) {
		Calendar cal = Calendar.getInstance();
		String weekCn = null;
		Timestamp time = getTimeOfDateStr(dateStr);
		if (time != null) {
			cal.setTime(time);
			int day = cal.get(Calendar.DAY_OF_WEEK);
			switch (day) {
			case 1:
				weekCn = "日";
				break;
			case 2:
				weekCn = "一";
				break;
			case 3:
				weekCn = "二";
				break;
			case 4:
				weekCn = "三";
				break;
			case 5:
				weekCn = "四";
				break;
			case 6:
				weekCn = "五";
				break;
			case 7:
				weekCn = "六";
				break;
			default:
				weekCn = "";
			}
		}
		return weekCn;
	}
	public final static Timestamp getTimeOfDateStr(String dateStr) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Timestamp time = null;
		try {
			Date da = df.parse(dateStr);
			time = new Timestamp(da.getTime());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return time;
	}
	public final static int getDayOfWeek(Date dateStr)
	{
		Calendar cal = Calendar.getInstance();
		@SuppressWarnings("unused")
		String weekCn = null;
		int day = 0;
		cal.setTime(dateStr);
		day = cal.get(Calendar.DAY_OF_WEEK);
		return day;
	}
    /**
     * 将字符串按指定格式解析成日期对象
     * 
     * @since 1.1
     * @param dateStr
     *            需要进行转换的日期字符串
     * @param pattern
     *            日期字符串的格式
     * @return "yyyy-MM-dd HH:mm:ss"形式的日期对象
     */
    public static Date parseDate(String dateStr, String pattern) {
        SimpleDateFormat DATEFORMAT = new SimpleDateFormat(defDtPtn);
        DATEFORMAT.applyPattern(pattern);
        Date ret = null;
        try {
            ret = DATEFORMAT.parse(dateStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DATEFORMAT.applyPattern(defDtPtn);
        return ret;
    }
	public static String formatDate(Date d, int format, Locale locale, TimeZone timeZone)
	{
		if (d == null)
			return "";
		DateFormat df = DateFormat.getDateInstance(format, locale);
		df.setTimeZone(timeZone);
		return df.format(d);
	}

	public static String formatDateTime(Date d, int format1, int format2, Locale locale, TimeZone timeZone)
	{
		if (d == null)
			return "";
		DateFormat df = DateFormat.getDateTimeInstance(format1, format2, locale);
		df.setTimeZone(timeZone);
		return df.format(d);
	}

	/**
	 * 根据字符串返回指定格式的日期
	 * 
	 * @param dateStr
	 *            日期(字符串)
	 * @param format
	 *            日期格式
	 * @return 日期(Date)
	 * @throws ParseException
	 */
	public static Date convertDate(String dateStr, String format) throws ParseException
	{
		Date date = null;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
		date = simpleDateFormat.parse(dateStr);
		return date;
	}

	public static long toLong(Date d)
	{
		if (d == null)
			return 5338979352082120704L;
		return d.getTime();
	}

	public static String toLongString(Date d)
	{
		return "" + toLong(d);
	}

	public static int getYear(Date date)
	{
		if (date == null)
			return 0;
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		return cal.get(1);
	}

	public static Date parse(String timeMillis)
	{
		Date d = null;
		try
		{
			d = new Date(Long.parseLong(timeMillis.trim()));
		} catch (Exception e)
		{
		}
		return d;
	}

	public static Date parse(String time, String format)
	{
		Date d = null;
		try
		{
			d = parse(time, format, Locale.CHINA);
		} catch (Exception e)
		{
		}
		return d;
	}

	public static Date parse(String time, String format, Locale locale) throws Exception
	{
		if (time == null)
			return null;
		SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
		Date d = null;
		d = sdf.parse(time);
		return d;
	}

	public static String format(Calendar cal, String format)
	{
		if (cal == null)
			return "";
		SimpleDateFormat myFormatter = new SimpleDateFormat(format);
		return myFormatter.format(cal.getTime());
	}

	public static Calendar add(Date d, int day)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(5, day);
		return cal;
	}

	public static Date addDate(Date d, int day)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(5, day);
		return cal.getTime();
	}
	public static Date addMonth(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(2, m);
		return cal.getTime();
	}
	   public static Date addYear(Date d, int m)
	    {
	        if (d == null)
	            return null;
	        Calendar cal = Calendar.getInstance();
	        cal.setTime(d);
	        cal.add(Calendar.YEAR, m);
	        return cal.getTime();
	    }
	public static Date addHourDate(Date d, int h)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(10, h);
		return cal.getTime();
	}

	public static Calendar addHour(Date d, int h)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(10, h);
		return cal;
	}

	public static Date addMinuteDate(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(12, m);
		return cal.getTime();
	}

	public static Calendar addMinute(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(12, m);
		return cal;
	}

	public static int compare(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTimeInMillis() - c2.getTimeInMillis();
		if (r > 5338979730039242752L)
			return 1;
		if (r == 5338979730039242752L)
			return 0;
		return 2;
	}

	public static int compare(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTime() - c2.getTime();
		if (r > 5338979730039242752L)
			return 1;
		if (r == 5338979730039242752L)
			return 0;
		return 2;
	}

	public static boolean isSameDay(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return false;
		return ((c1.get(1) == c2.get(1)) && (c1.get(2) == c2.get(2)) && (c1.get(5) == c2.get(5)));
	}

	public static boolean isSameDay(Date d1, Date d2)
	{
		if ((d1 == null) || (d2 == null))
			return false;
		Calendar c1 = Calendar.getInstance();
		c1.setTime(d1);
		Calendar c2 = Calendar.getInstance();
		c2.setTime(d2);
		return ((c1.get(1) == c2.get(1)) && (c1.get(2) == c2.get(2)) && (c1.get(5) == c2.get(5)));
	}

	public static int datediff(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 86400000L;
		return (int) r;
	}

	public static int datediff(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTime() - c2.getTime();
		r /= 86400000L;
		return (int) r;
	}

	public static int datediffMinute(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTime() - c2.getTime();
		r /= 60000.0D;
		return (int) r;
	}

	public static int datediffMinute(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 60000.0D;
		return (int) r;
	}

	public static int datediffHour(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTime() - c2.getTime();
		r /= 3600000.0D;
		return (int) r;
	}

	public static int datediffHour(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 3600000.0D;
		return (int) r;
	}

	@SuppressWarnings("deprecation")
	public static int[] dateDiffDHMS(Date d1, Date d2)
	{
		int diffDay = datediff(d1, d2);
		int h1 = d1.getHours();
		int h2 = d2.getHours();
		int m1 = d1.getMinutes();
		int m2 = d2.getMinutes();
		int s1 = d1.getSeconds();
		int s2 = d2.getSeconds();
		int s = s1 - s2;
		int m = m1 - m2;
		if (s < 0)
		{
			s += 60;
			--m;
		}
		int h = h1 - h2;
		if (m < 0)
		{
			m += 60;
			--h;
		}
		if (h < 0)
		{
			h += 24;
		}
		int[] r =
		{ diffDay, h, m, s };
		return r;
	}

	public static int getDayCount(int year, int month)
	{
		int[] daysInMonth =
		{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
		if (1 == month)
		{
			return ((((0 == year % 4) && (0 != year % 100)) || (0 == year % 400)) ? 29 : 28);
		}
		return daysInMonth[month];
	}

	public static int getDaysOfYear(int year)
	{
		GregorianCalendar now = new GregorianCalendar();
		return ((now.isLeapYear(year)) ? 366 : 365);
	}

	/**
	 * 转换时间类型时间变字符
	 * 
	 * @param ts
	 * @param withtime
	 * @return
	 */
	public static String Timestamp2String(Timestamp ts, boolean withtime) //
	{
		if (ts == null)
			return "";
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return sdf.format(ts);
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			return sdf.format(ts);
		}
	}

	/**
	 * 转换时间类型字符变时间
	 * 
	 * @param string
	 * @param withtime
	 * @return
	 */
	public static Timestamp String2Timestamp(String string, boolean withtime)
	{
		Timestamp ts = null;
		if (string == null || string.equals(""))
			return ts;
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			try
			{
				ts = new Timestamp(sdf.parse(string).getTime());
			} catch (Exception e)
			{
			}
			return ts;
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			try
			{
				ts = new Timestamp(sdf.parse(string).getTime());
			} catch (Exception e)
			{
			}
			return ts;
		}
	}

	/**
	 * 把Long型字符转换成字符串时间
	 * 
	 * @param string
	 * @param withtime
	 * @return
	 */
	public static String longToString(String format, long l_time)
	{
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		Date dt = new Date(l_time * 1000);
		String time = sdf.format(dt);
		return time;
	}

	/**
	 * 在YM的基础上增加count个月
	 * 
	 * @param ym
	 * @param count
	 * @return
	 */
	public static String addMonth(String ym, int count)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		try
		{
			Date date = sdf.parse(ym);
			Calendar c = Calendar.getInstance();
			c.setTime(date);
			c.add(2, count);
			return sdf.format(c.getTime());
		} catch (ParseException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 格式化EXCEL导入时获取的日期
	 * 
	 * @param date
	 * @return
	 */
	public static Date formatExcelDate(String date)
	{
		Calendar cld = Calendar.getInstance();
		cld.set(1899, 11, 30);
		cld.add(Calendar.DAY_OF_YEAR, Float.valueOf(date).intValue());
		return cld.getTime();
	}

	/**
	 * 获取当前月第一天
	 * 
	 * @return
	 */
	public static String firstDay()
	{
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar c = Calendar.getInstance();
		c.add(Calendar.MONTH, 0);
		c.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
		String first = format.format(c.getTime());
		return first;
	}

	/**
	 * 获取当前月最后天
	 * 
	 * @return
	 */
	public static String lastDay()
	{
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
		String last = format.format(ca.getTime());
		return last;
	}

	public static String getWeekDayString(Date date)
	{
		String weekString = "";
		final String dayNames[] =
		{ "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六" };
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
		weekString = dayNames[dayOfWeek - 1];
		return weekString;
	}

	/**
	 * 转换日期格式
	 * @param source
	 * @param sourceFormat
	 * @param targetFormat
	 * @return
	 * @throws ParseException
	 */
	public static String convertDate(String source,String sourceFormat,String targetFormat) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat(sourceFormat);
		Date date = sdf.parse(source);
		sdf.applyPattern(targetFormat);
		return sdf.format(date);
	}
	
	
	/*  *//**
     * 获取标准的本地时间
     * 创建人:  李东亮  
     * 创建时间:  2015-7-2 上午10:32:25 
     * @version 1.0
     * @param raw
     * @return
     *//*
    public  static  String  getPublishDate(String raw){
        if(raw==null){
            return null;
        }
        Date date = PublishDateUtil.transDate(raw);
       if(date!=null){
           Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Asia/Shanghai"));
            c.setTime(date);
            Pattern p = Pattern.compile("(\\d{1,2})[:|：](\\d{1,2})([:|：]\\d{1,2}){0,1}");
            Matcher m = p.matcher(raw);
            while(m.find()){
                String hour = m.group(1);
                if(hour!=null){
                    c.set(Calendar.HOUR_OF_DAY, Integer.valueOf(hour));
                }
                String minute = m.group(2);
                if(minute!=null){
                    c.set(Calendar.MINUTE, Integer.valueOf(minute));
                }
                String second = m.group(3);
                if(second!=null){
                    c.set(Calendar.SECOND, Integer.valueOf(second.replaceAll(":|：", "")));
                }
            }
            
            Date now = new Date();
            if(c.getTimeInMillis()>now.getTime()){
                c.setTime(now);
            }
            return  DateUtil.format(c.getTime(),"yyyy-MM-dd HH:mm:ss");
       }else
       {
           return null;
       }
    }*/
    
    /**
     * 格式化JANUARY 15TH, 2016这种类型的时间
     * 创建人:  李东亮  
     * 创建时间:  2016-5-12 上午10:52:09 
     * @version 1.0
     * @param dateStr
     * @return
     */
    public static String formatUSDate(String  dateStr){
        Date date = null;
        SimpleDateFormat sdf1 =  new SimpleDateFormat("MMMM d'st', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf2 =  new SimpleDateFormat("MMMM d'nd', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf3 =  new SimpleDateFormat("MMMM d'rd', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf4 =  new SimpleDateFormat("MMMM d'th', yyyy",Locale.ENGLISH);
        SimpleDateFormat sdf6 =  new SimpleDateFormat("MMMM d, yyyy",Locale.ENGLISH);
        try {
            date = sdf1.parse(dateStr);
        } catch (ParseException e) {
            try {
                date = sdf2.parse(dateStr);
            } catch (ParseException e1) {
                try {
                    date = sdf3.parse(dateStr);
                } catch (ParseException e2) {
                    try {
                        date = sdf4.parse(dateStr);
                    } catch (ParseException e3) {
                        try {
                            date = sdf6.parse(dateStr);
                        } catch (ParseException e4) {
                            // TODO Auto-generated catch block
                            e4.printStackTrace();
                        }
                    }
                }
            }
        }
        if(date!=null){
            SimpleDateFormat sdf5 = new SimpleDateFormat("yyyy-MM-dd");
            return  sdf5.format(date);
        }
        return null;
    }
    
    /**
     * 
     * 创建人:  李东亮  
     * 创建时间:  2016-8-15 下午3:09:14 
     * @version 1.0
     * @param format
     * @param date
     * @return
     */
    public static String convertStandardFormat(String sourceFormat,Date date){
        String standFormat = "yyyy-MM";
        if(sourceFormat.contains("dd")){
            standFormat = "yyyy-MM-dd";
        }else if(sourceFormat.contains("HH")){
            standFormat = "yyyy-MM-dd HH";
        }else if(sourceFormat.contains("mm")){
            standFormat = "yyyy-MM-dd HH:mm";
        }
        SimpleDateFormat standardSdf = new SimpleDateFormat(standFormat);
        return  standardSdf.format(date);
    }
    
	public static String getDateBeforeDays(Date day, int days) {
		Calendar now = Calendar.getInstance();  
		now.setTime(day);  
		now.set(Calendar.DATE,now.get(Calendar.DATE) - days);  
		return format(now.getTime(), "yyyy-MM-dd HH:mm:ss");  
	}
	
	public static Long getDateid(){
		Calendar now = Calendar.getInstance();  
		String id=format(now.getTime(), "yyMMdd"); 
		return Long.parseLong(id+"00000000");
		
	}
	public static void main(String[] args) throws ParseException
	{
		//System.out.println(convertDate("2014年7月","yyyy年MM月","yyyyMM"));
		System.out.println(getDateid());
	}
}