package com.zzsn.util;


import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentUtility {

    static Pattern divNoneP = Pattern.compile("(?s)<div[^>]*display:none[^>]*>.*?</div>", Pattern.CASE_INSENSITIVE);

    static Pattern divP = Pattern.compile("<div>", Pattern.CASE_INSENSITIVE);

    static Pattern divRP = Pattern.compile("</div>", Pattern.CASE_INSENSITIVE);

    static Pattern brP = Pattern.compile("<br />", Pattern.CASE_INSENSITIVE);

    static Pattern br2P = Pattern.compile("<br>", Pattern.CASE_INSENSITIVE);

    static Pattern spaceP = Pattern.compile("&nbsp;", Pattern.CASE_INSENSITIVE);

    static Pattern strongP = Pattern.compile("<strong>", Pattern.CASE_INSENSITIVE);

    static Pattern strongRP = Pattern.compile("</strong>", Pattern.CASE_INSENSITIVE);

    static Pattern pP = Pattern.compile("<p>", Pattern.CASE_INSENSITIVE);

    static Pattern pRP = Pattern.compile("</p>", Pattern.CASE_INSENSITIVE);

    static Pattern centerP = Pattern.compile("<center[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern centerRP = Pattern.compile("</center>", Pattern.CASE_INSENSITIVE);

    static Pattern removeAttrP = Pattern.compile("<([a-zA-Z0-9]+)[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern commentP = Pattern.compile("(?s)<!--[^>]*>.*?<![^>]*-->", Pattern.CASE_INSENSITIVE);

    static Pattern inputP = Pattern.compile("<input[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern formP = Pattern.compile("<form[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern formRP = Pattern.compile("</form>", Pattern.CASE_INSENSITIVE);

    static Pattern buttonP = Pattern.compile("(?s)<button[^>]*>.*?</button>", Pattern.CASE_INSENSITIVE);

    static Pattern iframeP = Pattern.compile("(?s)<iframe[^>]*>.*?</iframe>", Pattern.CASE_INSENSITIVE);

    static Pattern noscriptP = Pattern.compile("(?s)<noscript>.*?</noscript>", Pattern.CASE_INSENSITIVE);

    static Pattern objectP = Pattern.compile("(?s)<object[^>]*>.*?</object>", Pattern.CASE_INSENSITIVE);

    static Pattern linkP = Pattern.compile("(?s)<link[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern imgReplaceP = Pattern.compile("<img([^>]*)>", Pattern.CASE_INSENSITIVE);

    static Pattern imgRevReplaceP = Pattern.compile("<_img([^>]*)>", Pattern.CASE_INSENSITIVE);

    static Pattern imgP = Pattern.compile("<img[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern imgRP = Pattern.compile("</img>", Pattern.CASE_INSENSITIVE);

    public static Pattern aRemoveP = Pattern.compile("(?s)<a[^>]*>.*?</a>", Pattern.CASE_INSENSITIVE);

    static Pattern legendRemoveP = Pattern.compile("(?s)<legend[^>]*>.*?</legend>", Pattern.CASE_INSENSITIVE);

    static Pattern aP = Pattern.compile("<a[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern aRP = Pattern.compile("</a>", Pattern.CASE_INSENSITIVE);

    static Pattern fontP = Pattern.compile("<font[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern fontRP = Pattern.compile("</font>", Pattern.CASE_INSENSITIVE);

    static Pattern hP = Pattern.compile("<h\\d[^>]*>", Pattern.CASE_INSENSITIVE);

    static Pattern hRP = Pattern.compile("</h\\d>", Pattern.CASE_INSENSITIVE);

    static Pattern ulRP = Pattern.compile("</ul>", Pattern.CASE_INSENSITIVE);

    static Pattern liRP = Pattern.compile("</li>", Pattern.CASE_INSENSITIVE);

    static Pattern trRP = Pattern.compile("</tr>", Pattern.CASE_INSENSITIVE);

    static Pattern tdRP = Pattern.compile("</td>", Pattern.CASE_INSENSITIVE);

    static Pattern textareaRemoveP = Pattern.compile("(?s)<textarea[^>]*>.*?</textarea>", Pattern.CASE_INSENSITIVE);

    static Pattern selectRemoveP = Pattern.compile("(?s)<select[^>]*>.*?</select>", Pattern.CASE_INSENSITIVE);

    static Pattern optionRemoveP = Pattern.compile("(?s)<option[^>]*>.*?</option>", Pattern.CASE_INSENSITIVE);

    static Pattern labelRemoveP = Pattern.compile("(?s)<label[^>]*>.*?</label>", Pattern.CASE_INSENSITIVE);

    static String regHTMLNumcode = "&#(\\d{4,5});";

    static Pattern patHTMLNumCode = Pattern.compile(regHTMLNumcode);

    public static String convertHtmlToUtf8(String html, Header contentTypeHeader)
    {
      String charset = "utf-8";
      Document jsoupDoc = Jsoup.parse(html);
      html = jsoupDoc.html();
      return html;
    }
    /**
     * 去掉无用的HTML标签，包括a等
     * @param htmlText
     * @return
     */
    public static String RemoveUselessHTMLTagX(String htmlText) {
        try {
            htmlText = ContentUtility.RemoveStyleCode(htmlText);

            htmlText = htmlText.replaceAll("&nbsp;", " ");

            htmlText = divNoneP.matcher(htmlText).replaceAll("");

            htmlText = textareaRemoveP.matcher(htmlText).replaceAll("");
            htmlText = selectRemoveP.matcher(htmlText).replaceAll("");
            htmlText = optionRemoveP.matcher(htmlText).replaceAll("");
            htmlText = labelRemoveP.matcher(htmlText).replaceAll("");
            htmlText = inputP.matcher(htmlText).replaceAll("");
            htmlText = formP.matcher(htmlText).replaceAll("");
            htmlText = buttonP.matcher(htmlText).replaceAll("");
            htmlText = formRP.matcher(htmlText).replaceAll("");

            //    htmlText = imgReplaceP.matcher(htmlText).replaceAll("<_img$1>");
            htmlText = removeUselessAtt(htmlText);
            //  htmlText = removeAttrP.matcher(htmlText).replaceAll("<$1>");
            //    htmlText = imgRevReplaceP.matcher(htmlText).replaceAll("<img$1>");

            htmlText = commentP.matcher(htmlText).replaceAll("");
            htmlText = legendRemoveP.matcher(htmlText).replaceAll("");

            // htmlText = aP.matcher(htmlText).replaceAll("<sapn>");
            //  htmlText = aRP.matcher(htmlText).replaceAll("</sapn>");
            htmlText = iframeP.matcher(htmlText).replaceAll("");
            htmlText = noscriptP.matcher(htmlText).replaceAll("");
            htmlText = objectP.matcher(htmlText).replaceAll("");
            //htmlText = imgP.matcher(htmlText).replaceAll("");
            //htmlText = imgRP.matcher(htmlText).replaceAll("");

            htmlText = centerP.matcher(htmlText).replaceAll("");
            htmlText = centerRP.matcher(htmlText).replaceAll("");

            htmlText = htmlText.replaceAll("<cufontext>", "");
            htmlText = htmlText.replaceAll("</cufontext>", "");
            htmlText = htmlText.replaceAll("<cufon>", "");
            htmlText = htmlText.replaceAll("</cufon>", "");

            //htmlText = htmlText.replaceAll("(?s)<([a-zA-Z0-9]+)[^>]*>\\s*(</$1>)", "");

            htmlText = htmlText.replaceAll("(?s)<ul[^>]*>\\s*</ul>", "");
            htmlText = htmlText.replaceAll("(?s)<div[^>]*>\\s*</div>", "");
            htmlText = htmlText.replaceAll("(?s)<p[^>]*>\\s*</p>", "");
            htmlText = htmlText.replaceAll("(?s)<li[^>]*>\\s*</li>", "");
            htmlText = htmlText.replaceAll("(?s)<canvas[^>]*>\\s*</canvas>", "");

            return htmlText;
        } catch (Exception e) {
            e.printStackTrace();
            return htmlText;
        }
    }

    public static String RemoveHTMLCode(String src) {
        src = src.replaceAll("(<[^>]*>)\\s*(<[^>]*>)", "$1$2");
        src = divP.matcher(src).replaceAll("\n\n");
        src = divRP.matcher(src).replaceAll("\n\n");
        src = brP.matcher(src).replaceAll("\n\n");
        src = br2P.matcher(src).replaceAll("\n\n");
        src = spaceP.matcher(src).replaceAll(" ");
        src = src.replaceAll("&#8226;", "??");
        src = strongP.matcher(src).replaceAll("");
        src = strongRP.matcher(src).replaceAll("");
        src = pP.matcher(src).replaceAll("\n\n");
        src = pRP.matcher(src).replaceAll("\n\n");
        src = aP.matcher(src).replaceAll("");
        src = aRP.matcher(src).replaceAll("");
        src = imgP.matcher(src).replaceAll("");
        src = fontP.matcher(src).replaceAll("");
        src = fontRP.matcher(src).replaceAll("");
        src = hRP.matcher(src).replaceAll("\n\n");
        src = ulRP.matcher(src).replaceAll("\n\n");
        src = liRP.matcher(src).replaceAll("\n\n");
        src = trRP.matcher(src).replaceAll("\n\n");
        src = tdRP.matcher(src).replaceAll("\n\n");

        src = src.replaceAll("<[^>]*>", "");

        return src.trim();
    }

    /**
     * 去除除table的td外的无用的html标签属性
     * 创建人:  李东亮  
     * 创建时间:  2016-7-14 下午5:01:20 
     * @version 1.0
     * @param htmlText
     * @return
     */
    public static String removeUselessAtt(String htmlText) {
        Matcher m = removeAttrP.matcher(htmlText);
        Map<String, String> replaceMap = new HashMap<String, String>();
        String tagPre;
        while (m.find()) {
            tagPre = m.group();
            if (!tagPre.startsWith("<td ") && !tagPre.startsWith("<TD ") && !tagPre.startsWith("<th ") && !tagPre.startsWith("<TH ")
                    && !tagPre.startsWith("<img ") && !tagPre.startsWith("<IMG ") && !tagPre.startsWith("<a ") && !tagPre.startsWith("<A ")) {
                replaceMap.put(tagPre, removeAttrP.matcher(tagPre).replaceAll("<$1>"));
            }
        }

        String replaceTagPre;
        for (String key : replaceMap.keySet()) {
            replaceTagPre = replaceMap.get(key);
            while (htmlText.contains(key) && !key.equals(replaceTagPre)) {
                htmlText = htmlText.replace(key, replaceTagPre);
            }
        }

        return htmlText;
    }

    public static String HTMLDecode(String str) {
        //
        // 去掉一些HTML编码
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&nbsp;", " ");
        str = str.replaceAll("&middot;", "·");
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&ldquo;", "“");
        str = str.replaceAll("&rdquo;", "”");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&raquo;", "??");
        str = str.replaceAll("&times;", "×");
        str = str.replaceAll("&ccedil;", "??");
        str = str.replaceAll("&atilde;", "??");
        str = str.replaceAll("&ecirc;", "ê");

        // 去掉<>
        //
        str = str.replaceAll("<\\?[^>]*>", "");

        Matcher matcher = patHTMLNumCode.matcher(str);
        while (matcher.find()) {
            str = matcher.replaceFirst(String.valueOf((char) Integer.parseInt(matcher.group(1))));
            matcher = patHTMLNumCode.matcher(str);
        }

        String[] tmp = str.split(";&#|&#|;");
        StringBuffer sb = new StringBuffer("");

        for (int i = 0; i < tmp.length; i++) {
            if (tmp[i].matches("\\d{4,5}")) {
                sb.append((char) Integer.parseInt(tmp[i]));
            } else {
                sb.append(tmp[i]);
            }
        }
        str = sb.toString();

        return str;
    }

    public static String RemoveHTMLReturnCode(String src) {
        //src = src.replaceAll("(<[^>]*>)[\r\n]+(<[^>]*>)", "$1$2");
        src = src.replaceAll("\r", "");
        src = src.replaceAll("\n", "");
        return src;
    }
    /**
     * 提取html字符串转中的普通文本，注意处理其中的回车符 
     * @param htmlText
     * @return
     */
    public static String TransferHTML2Text(String htmlText) {
        if(htmlText==null){
            return null;
        }
        String text = ContentUtility.HTMLDecode(ContentUtility.RemoveHTMLCode(ContentUtility.RemoveStyleCode(ContentUtility.RemoveHTMLReturnCode(htmlText))));
		text = text.replaceAll(" 　　", "\r\n");

		text = text.replaceAll(" +\r\n", "\r\n");
		text = text.replaceAll(" +", " ");
		text = text.replaceAll("[\\u00A0\\u3000]", "");
		text = text.replaceAll("　", "");

		return text;

    }

    public static String RemoveStyleCode(String content) {

        try {
            Pattern p1 = Pattern.compile("(?s)<script\\s*.*?>(.*?)</script>", Pattern.CASE_INSENSITIVE);
            Matcher m1 = p1.matcher(content);
            content = m1.replaceAll("");

            Pattern p2 = Pattern.compile("(?s)<style\\s*.*?>(.*?)</style>", Pattern.CASE_INSENSITIVE);
            Matcher m2 = p2.matcher(content);
            content = m2.replaceAll("");

            Pattern p11 = Pattern.compile("(?s)<script\\s*.*?/>", Pattern.CASE_INSENSITIVE);
            Matcher m11 = p11.matcher(content);
            content = m11.replaceAll("");

            Pattern p21 = Pattern.compile("(?s)<style\\s*.*?/>", Pattern.CASE_INSENSITIVE);
            Matcher m21 = p21.matcher(content);
            content = m21.replaceAll("");

            content = noscriptP.matcher(content).replaceAll("");
            content = objectP.matcher(content).replaceAll("");
            content = linkP.matcher(content).replaceAll("");

            Pattern p22 = Pattern.compile("(?s)<img\\s*.*?/>", Pattern.CASE_INSENSITIVE);
            Matcher m22 = p22.matcher(content);
            content = m22.replaceAll("");

            // 去除注释
            // Pattern p3 = Pattern.compile("(?s)<!--\\s*.*?>(.*?)-->");
            Pattern p3 = Pattern.compile("(?s)<!--.*?-->");
            Matcher m3 = p3.matcher(content);
            content = m3.replaceAll("");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return content;

    }

    
//    /**
//     * 获取类型
//     * 创建人:  李东亮  
//     * 创建时间:  2016-9-14 下午2:44:21 
//     * @version 1.0
//     * @param getMethod
//     * @return
//     */
//    public static String getContentType(GetMethod getMethod){
//        Header contentTypeHeader  = getMethod.getResponseHeader("Content-Type");
//        String contentType = "";
//        if (contentTypeHeader!=null) {
//        	contentType = contentTypeHeader.getValue();
//        }
//        
//     // TODO Auto-generated method stub
//        if (contentType.startsWith("text/html")) {
//            return Constants.TYPE_HTML;
//        }else if(contentType.startsWith("image/")){
//            return Constants.TYPE_IMG;
//        }else
//        if (contentType.startsWith("application/pdf")) {
//            return Constants.TYPE_PDF;
//        }else
//        //word抽取，ppt抽取等。。。
//        if (contentType.startsWith("application/msword") 
//                || contentType.startsWith("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
//            return Constants.TYPE_WORD;
//        }else
//        if (contentType.startsWith("application/vnd.ms-powerpoint")
//                || contentType.startsWith("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
//            return Constants.TYPE_PPT;
//        }else
//        if (contentType.startsWith("application/vnd.ms-excel")
//                || contentType.startsWith("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
//            return Constants.TYPE_EXCEL;
//        }
//        return  Constants.TYPE_HTML;
//        
//    }
    /**
     * 获取类型
     * 创建人:  李东亮  
     * 创建时间:  2016-9-14 下午2:44:21 
     * @version 1.0
     * @param getMethod
     * @return
     */
    public static String getContentType(HttpResponse getMethod){
        Header contentTypeHeader  = getMethod.getFirstHeader("Content-Type");
        String contentType = "";
        if (contentTypeHeader!=null) {
        	contentType = contentTypeHeader.getValue();
        }
        
     // TODO Auto-generated method stub
        if (contentType.startsWith("text/html")) {
            return Constants.TYPE_HTML;
        }else
        if (contentType.startsWith("application/pdf")) {
            return Constants.TYPE_PDF;
        }else
        //word抽取，ppt抽取等。。。
        if (contentType.startsWith("application/msword") 
                || contentType.startsWith("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return Constants.TYPE_WORD;
        }else
        if (contentType.startsWith("application/vnd.ms-powerpoint")
                || contentType.startsWith("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return Constants.TYPE_PPT;
        }else
        if (contentType.startsWith("application/vnd.ms-excel")
                || contentType.startsWith("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return Constants.TYPE_EXCEL;
        }
        return  Constants.TYPE_HTML;
        
    }
    public static void main(String[] args) {
		String s="<div>\r\n" + 
				"  　　2019年4月1日起发布施行的新修订的《 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定办法》（以下简称“办法”）规定， \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定分为推广鉴定和专项鉴定。作为已经开展多年的鉴定工作，专项鉴定被赋予了全新的内涵，鉴定对象主要针对 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>创新产品，鉴定内容为创新性评价、安全性检查和适用地区性能试验等三项内容。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　对于从事 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定工作多年的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>试验鉴定机构来说，推广鉴定工作是其一直以来的主要工作，制度要求和工作流程是非常清晰及熟悉的，但是对于专项鉴定，认识还相对比较模糊。就鉴定产品如何确定、鉴定依据如何制定、鉴定工作如何开展以及鉴定证书颁发和后期管理都还处在积累经验阶段。从目前了解的情况看，已经有几个省在专项鉴定工作中走在了前面，福建省农业农村厅于2019年2月率先发布实施2个产品的专项鉴定大纲，黑龙江省农业农村厅于2019年5月发布实施1个产品的专项鉴定大纲，湖南省、内蒙古自治区、山东省和江苏省已经分别审定通过部分产品的专项鉴定大纲，正在报批发布过程中。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　自办法发布半年多来的专项鉴定工作实践来看，从大纲制定到鉴定实施还有一些问题需要澄清和解决，下面谈一下个人的思考与理解。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　一、鉴定机构资质问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　办法明确了 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定是由 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定机构通过科学试验、检测和考核，对 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>的适用性、安全性和可靠性作出技术评价，为 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>的选择和推广提供依据和信息的活动。办法第六条确定了 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定的公益性服务属性。在第二章鉴定机构中则进一步明确了鉴定工作主体，第八条明确规定， \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定由省级以上人民政府 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>化行政主管部门所属或者指定的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构实施。所以说办法从法律角度确定了 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构的专项鉴定主体地位。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　由于目前国内各 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>试验鉴定机构情况有所不同，所以对开展专项鉴定工作还有些疑问，比如，农业农村部 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定总站能否开展专项鉴定？总站各专业站能否开展专项鉴定？从办法规定的逻辑关系来看，本不存在疑问， \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定包括推广鉴定和专项鉴定，农业农村部 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定总站属于农业农村部所属的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构，符合第八条规定，所以总站是可以开展专项鉴定的。各总站专业站属于由原农业部认可的由总站进行业务管理的专业 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定站，属于鉴定总站业务的延伸，应该也符合本条规定，所以也是可以开展专项鉴定的。就像数年前的选型鉴定，鉴定总站可以在全国范围内作选型鉴定，各省区市也可以根据自身情况在本省区市开展选型鉴定。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　问题出在办法第四条，即农业农村部主管全国 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定工作，制定并公布推广鉴定大纲。省、自治区、直辖市人民政府 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>化行政主管部门主管本行政区域的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定工作，制定并公布专项鉴定大纲，报农业农村部备案。对该条的直观解读造成大家的理解偏差，就是农业农村部负责发布推广鉴定大纲，连带着鉴定总站及专业站只能做推广鉴定而不能做其他，各省负责发布专项鉴定大纲，各省级鉴定站就可以做专项鉴定。正确的理解是农业农村部负责发布推广鉴定大纲，推广鉴定工作由全系统共同做，也就是鉴定总站及专业站和各省级鉴定机构共同承担。同样各省负责发布专项鉴定大纲，专项鉴定工作由本省及有需求的省区市分别来做，当然也就是鉴定总站及专业站和有关省级鉴定机构分别承担。如果从法律授权的角度看，这样的理解也是符合办法规定的，并未超出法律授权范围。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　如果说还有操作上的问题，那就是专项鉴定大纲的制定发布问题，办法虽然没有限制鉴定总站及专业站作专项鉴定，但总站开展专项鉴定产品的大纲如何制定、发布呢，我觉得按照办法规定，各省制定并公布各省的，农业农村部组织鉴定总站及各专业站可使用有关省的专项鉴定大纲开展鉴定。关于这点，《农业农村部关于印发&lt; \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定工作规范&gt;的通知》（ \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>发〔2019〕3号）有相关要求，该工作规范第七条规定，大纲全国通用。各省在采用其他省专项鉴定大纲时，可以结合实际调整适用地区性能试验内容，以大纲修改单的形式公布，由本省鉴定机构实施。另外鉴定总站及专业站还可发挥更大组织协调作用，并与有关省站合作，制定适用于更大地域范围的专项鉴定大纲，既有利于统一规范，又可减少和避免各省站重复作业。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　另外对于由于机构改革，鉴定机构的原上级主管机关业务调整甚至取消了主管机关的，该鉴定站如果想开展专项鉴定，但其主管部门职能被取消，没有办法为其发布鉴定大纲了。此种情况，我认为，一种方式是争取取得该站所在省 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>化主管部门认可，成为其指定鉴定机构，承担一定范围内的专项鉴定工作，此方法与办法第八条规定并不相悖。据了解，福建省在这方面做出了一些探索，为了扩大 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定的有效供给，福建省在既保留原来鉴定机构的基础上，另外又指定了二家第三方鉴定机构来承担鉴定工作。其次还可以在办法允许的范围内，采用合作鉴定的方式，承担部分鉴定工作。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　二、鉴定机构检验检测资质问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构开展专项鉴定是否需要取得该产品的实验室资质认定呢？也就是说将来出具的专项鉴定报告是否需要加盖CMA标志呢？对于这个问题我觉得应该分情况区别对待，对于有产品标准试验方法的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>产品，还是应该按照资质认定管理相关规定，取得相应产品的实验室检验检测能力认可，这样开展工作出具检验检测报告可以加盖CMA标志，避免所谓超范围检验检测。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　但是对于创新型 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>产品可能比较难取得资质认定，因为创新型产品没有产品标准，最多有可能有一个企业标准或者技术要求，而企业标准又不能作为检测依据申请资质认定。专项鉴定大纲制定时可能参考了企业标准内容或实际产品的技术要求，没有现有国标或行标可供借鉴，其内容及要求也与现在的推广鉴定大纲不同。虽然原部级推广鉴定大纲可以被认可具有行业标准的作用，作为检测方法取得实验室资质认定，但是专项鉴定大纲是分别由各省发布实施，因为大纲检验检测内容少而非检测内容多以及其他各种各样的原因，可能较难甚至不会被各省作为检测方法认可，通过不了资质认定认可。各 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构也因为担心与《计量法》及实验室资质管理有关规定相抵触而心存疑虑，不敢放手开展专项鉴定工作。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　办法第九条对 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构应当具备的条件规定了三条，一是不以赢利为目的的公益性事业组织；二是具有与鉴定工作相适应的工作人员、场所和设施设备；三是具有符合鉴定工作要求的工作制度和操作规范。作为目前 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>试验鉴定系统来说，全系统各鉴定机构都已经具备相应条件，不存在软硬件上的缺失，需要的只是完善和提高。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　对于已经取得实验室资质认定的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>鉴定机构，开展工作有所顾虑的有两方面问题。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　一是《中华人民共和国计量法》和《中华人民共和国计量法实施细则》有关规定，计量法第二十一条规定，为社会提供公证数据的产品质量检验机构，必须经省级以上人民政府计量行政部门对其计量检定、测试的能力和可靠性考核合格。实施细则第二十九条规定，为社会提供公证数据的产品质量检验机构，必须经省级以上人民政府计量行政部门计量认证。第三十一条规定，……未取得计量认证合格证书的，不得开展产品质量检验工作。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　二是《检验检测机构资质认定管理办法》有关要求，其中第二十五条规定，检验检测机构应当在资质认定证书规定的检验检测能力范围内，依据相关标准或者技术规范规定的程序和要求，出具检验检测数据、结果。检验检测机构出具检验检测数据、结果时，应当注明检验检测依据，并使用符合资质认定基本规范、评审准则规定的用语进行表述。检验检测机构对其出具的检验检测数据、结果负责，并承担相应法律责任。另外第二十八条规定，检验检测机构向社会出具具有证明作用的检验检测数据、结果的，应当在其检验检测报告上加盖检验检测专用章，并标注资质认定标志。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　对于以上第一个问题，据掌握的情况，凡是开展有 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>检验检测业务的 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>试验鉴定各机构，均通过相应计量认证考核，取得了计量认证合格证书，是有资质的鉴定机构，开展工作不存在问题。比较有争议的是对第二个问题的理解。主要是，鉴定机构必须在资质认定证书规定的检验检测能力范围内开展检测鉴定工作，超过该范围的就不能做，因为出具的检验检测报告要标注资质认定标志，也就是加盖CMA标志，没有CMA标志的检验检测报告不能作为向社会出具的具有证明作用的检验检测数据、结果。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　其实这只是从问题的一个方面去进行阐述，要求规范检验检测机构的职业行为，但是却忽略了更多可能存在的市场需求和发展需要。在以产品试验方法标准作为资质认定检验检测能力确认依据的当下，各实验室在质量、成本、效益以及效率等因素下，恐怕都有相当多的产品标准进入不了实验室资质能力认定范围，更何况尚无标准的新产品呢！如果各检验检测机构只能在检验检测能力范围内开展工作，那么大量的创新产品和尚无检测方法的产品将无法获得检验检测的机会，社会将如何获取这些产品的技术和质量等信息呢？所以为了弥补以上制度未规定的情况，《&lt;检验检测机构资质认定管理办法&gt;释义》对该办法第二十五条进行解释时对超出检验检测能力范围开展检验检测给出了解决办法。也就是如果检验检测机构具备某些检验检测能力，但这些检验检测能力尚未取得资质认定（如尚无国家标准、行业标准、地方标准，从而无法取得资质认定），而检验检测机构根据特定委托方的合同约定，又需要实施相关检验检测并出具检验检测报告时，该报告不能使用资质认定标志（CMA标志），且必须在其检验检测报告的显着位置（如扉页、备注栏）注明相关检验检测依据不在资质认定范围内，检验检测数据和结果仅供特定委托方使用，不具有对社会的证明作用。此种情形，不属于超范围出具检验检测数据、结果。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　通过以上解释可以看出，检验检测机构不是不能做检验检测，只要特定委托方（比如 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>化主管部门、生产企业等）委托，就可以依据双方认可的检验检测方法开展检验检测，只要特定委托方认可，该机构出具的检验检测结果就可以服务于特定委托方。当然在开展工作之前，要按照实验室管理体系要求，对检验检测依据、检验检测人员、检验检测设备、环境等进行评估，达到一定要求后才可进行工作，出具报告时只要不使用资质认定标志（CMA标志）并在报告中注明检验检测数据和结果仅供特定委托方使用即可，这也不违反资质认定对实验室管理的要求。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　另外，鉴定机构出具的是专项鉴定报告，不是检验检测报告，其中仅有一小部分为检测或验证内容，鉴定结论是评价各方面技术内容后给出的综合结论，本身也不应该加盖实验室资质认定标志，更无必要在报告中作出限制性声明。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　基于以上分析，专项鉴定应根据实际需要，该检测的就进行检测，该评价的就进行评价，不能为规避检测能力问题该检测的也不检测，有意识删减检测项目。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　三、采信检验检测结果的问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　TZ 6?2019《 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>专项鉴定大纲编写规则》6.9.2安全性检查规定：“可以采信检验检测机构依据相关国家标准、行业标准、地方标准、团体标准或企业标准出具的安全性检查报告。”6.9.3适用地区性能试验规定：“可以采信县级以上 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>主管部门、鉴定、推广、科研等单位开展的实地试验验证报告。”就目前发布或审定的专项鉴定大纲中可以看到，在安全性检查中规定，可采信具有资质的检验检测机构依据相关国家标准、行业标准、地方标准、团体标准、或企业标准出具的符合本大纲要求的安全性检查报告。在适用地区性能试验中规定，可采信县级以上 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>主管部门、鉴定、推广、科研等单位开展的实地试验验证报告，或具有资质的检验检测机构依据相关国家标准、行业标准、地方标准、团体标准或企业标准出具的检验检测报告。大纲的规定与编写规则基本一致，只是有的在适用地区性能试验中增加了检验检测机构的报告。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　对于要开展专项鉴定的新产品，一般尚无标准可依据，那么就没有检验检测机构能取得资质认定能力，既然没有具备资质的机构，又谈何采信有资质机构的报告呢？而作为新产品，如无政策引导，生产企业可能不会主动为产品做检验检测，检验检测机构也不会主动扩充能力，承担新产品的检验检测。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　如果专项鉴定大纲可被引入资质认定范围，那最先可能取得资质认定能力的也只能是作为大纲起草单位的鉴定机构自己，社会第三方检验检测机构如未发现有实质性收益前景的话，一般不会主动去获取检验检测能力的，由此看来，采信报告的办法在专项鉴定开展初期不一定靠得住。如果社会上没有具备资质的检验检测机构，也就是没有相应的有效社会资源提供检测服务而仍然要求企业提供可采信的有资质机构的检验检测报告，相当于用这种方式拒绝了企业鉴定要求。所以各鉴定机构要有充分的思想准备，立足自身独立开展专项鉴定。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　另外，对采信检验检测机构报告也要有一定的审查要求，首先是采信报告的真实性问题，这是最重要的，采信报告如果是虚假的，所形成的的专项鉴定结论的基础就不存在了。其次还有采信报告的产品信息与专项鉴定产品信息的一致性问题、检验检测依据与专项鉴定大纲的符合性问题等。这些都需要在采信时重点关注。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　四、创新性评价问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　目前已发布的专项鉴定大纲中，对于创新性评价规定是要求制造商提供创新性证明材料，这些材料包括整机或部件的发明专利、实用新型专利、科技成果评价证书、科技成果查新报告等材料中的一种即可。也即大纲的规定是采信其他机构出具的相应证明材料，不管是整机还是部件，只要上述材料能提供其中的一种就认为符合要求，审核评价的工作显然做得不够。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　我觉得，创新性评价要有一个评审的过程，一是要对试验鉴定人员或者是评审专家要有一定要求，二是对制造商提供的材料要有一定要求，三是要有评审的原则把握和程序要求。对于试验鉴定人员或者评审专家，一般要求要了解鉴定工作，熟悉专项鉴定产品所处行业的基本现状，了解行业发展所存在的问题，具备客观评价行业和产品的经验，这样才能保证对专项鉴定产品做出较为中肯合理的评价而不至过于偏颇。对于用于提供评价信息的材料，可能不至一份，比如企业提供了发明专利和实用新型专利各一份，那么就要选出最能体现产品独特性、创新性的那份材料，兼顾其他进行综合评价。另外，应该要求制造商作为第一方对自己产品的创新性和区别于其他产品的显着特点提供说明。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　专项鉴定产品，因为是刚开发出来的产品，或者是在比较小地域范围内使用的产品，生产企业较少，使用用户应该也不会很多，为了保证评价结果的客观性、时效性，因此在评审原则的把握上，我觉得应注意以下几点，一是控制在一定的地域范围（或者生产作业条件下）内进行评价，根据产品试验验证情况及使用地域范围（或作业条件），进行评价，既不扩大也不缩小评价范围，保证既不要对产品太苛刻，使企业吃亏，又不要过于宽松夸大，而使评价者自身承担过度风险。二是控制在一定的时间范围内进行评价，保证产品创新性的现时适应性，一个产品或一项技术在过去某时是先进的，现在不一定仍然先进，所以评价时一定要说明产品在现在这个时期是否具有创新性。三是控制在一定的行业领域内进行评价，与同行业的同类产品比较，评价其是否开拓出新的生产方式，是否采用新材料、新工艺等等。四是要结合农时、农艺的特定要求进行评价，产品是否适应农时的紧迫性、连续性和持久性等要求，产品是否解决了农艺的关键性问题或产品对农艺要求的适应性是否适宜。五是如有可能，可以与国际同行业情况进行对照比较，进一步突出产品的特点。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　五、适用地区性能试验问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　目前有一种观点，专项鉴定在性能试验方面要减少内容，试验项目和指标不能多，尤其是出检测数据的指标不能多，最好都是定性的指标。我觉得这还是头脑中关于检测能力资质问题的外化反映，专项鉴定要成为一个科学合理的鉴定，一定不是刻意淡化某方面的鉴定内容，而是根据实际情况抓住关键性能，确定考核指标和试验方法，以体现新产品特点。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　六、鉴定通过后产品的变更问题 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　按照办法第二十一条规定， \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>专项鉴定证书的有效期为3年，有效期满仍符合现行鉴定大纲要求的，实行注册管理；不再符合鉴定大纲要求的，证书失效。专项鉴定对象为新产品，既是新产品，那么面对市场，产品出现变化的几率就大，有可能还是较大的变化，所以给出其鉴定证书较短的有效期。如果给出产品变更的限制要求，企业就会围绕或受限于这个限制范围，就有非常大的可能会限制产品的改进发展。另外专项鉴定大纲一致性控制的产品参数一般都是关键性参数，变化了可能产品结构就变了，就成为另一产品了。基于此，我认为大纲中不应有产品变更的章节，也就是不规定产品变更内容，只要大纲规定的关键参数发生变化，证书就失效，就需要将新产品重新做鉴定，重新获取证书。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　《农业农村部关于印发&lt; \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>试验鉴定工作规范&gt;的通知》（ \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>发〔2019〕3号），将推广鉴定与专项鉴定的关系做了说明。在工作规范第七条中规定，专项鉴定大纲具备条件后应列入推广鉴定大纲制修订计划，转化为推广鉴定大纲。也就是说，经过专项鉴定以后的产品，如果市场需要，将逐步转化为推广鉴定，然后在推广鉴定证书有效期管理中按照推广鉴定大纲的产品变更要求进行管理。 \r\n" + 
				" <br> \r\n" + 
				" <br> 　　 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农业机械</a>专项鉴定工作正处于起步阶段，专项鉴定规则的确立、工作程序的规范以及鉴定结果的使用工作等，还需要各方参与者的共同努力，不断改进和完善，希望逐步使其发挥出推动创新产品发展的作用，支持中国 \r\n" + 
				" <a href=\"http://www.nyjx.cn\" target=\"_blank\">农机</a>化事业顺利发展。 \r\n" + 
				" <br> \r\n" + 
				"</div>";
		
		String ss=ContentUtility.TransferHTML2Text(s);
    	System.out.println(ss);
    	
	}
    
}
