package com.zzsn.job;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.*;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.zzsn.tmpurl.oracledb.OracleDBManager;
import com.zzsn.tmpurl.oracledb.OracleDataTable;
import lombok.SneakyThrows;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import shade.kotlin.random.Random;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SouGouSearch {

    @SneakyThrows
    public static void main(String[] args)  {
        int msgTime = getMsgTime("观点中国");
        System.out.println("+++++"+msgTime);
//        getCookie2("https://weixin.sogou.com/weixin?type=1&s_from=input&query=观点中国");
//        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
//        String sd = simpleFormat.format(new Date(Long.parseLong("1660657216")*1000));   // 时间戳转换成时间
//        System.out.println(sd);
//        String s = get("https://weixin.sogou.com/weixin?type=1&s_from=input&query=观点中国");
//        Document document = Jsoup.parse(s);
//        Elements elements = document.select("div[class=\"news-box\"]>ul[class=\"news-list2\"]>li");
//        for (Element element :elements) {
//            String name = element.select("p[class=\"tit\"]>a>em").text();
//            String wxhao = element.select("label[name=\"em_weixinhao\"]").text();
//            String title = element.select("dd>a").text();
//            String index  = element.select("span>script").outerHtml();
//            String time="";
//            String matchUrl="\\d{1,}";
//            Pattern pattern = Pattern.compile(matchUrl);
//            Matcher matcher = pattern.matcher(index);
//            if(matcher.find()){
//                time=matcher.group();
//            }
//            if(name.equals("观点中国")) {
//                System.out.println(name);
//                System.out.println(wxhao);
//                System.out.println(title);
//                System.out.println(time);
//                System.out.println(System.currentTimeMillis());
//                System.out.println(getBeforeTime(time));
//            }
//        }
    }

    public static int getTime(String siteName){
        String url="http://49.4.24.191:8005/sougou_wechart/?query="+siteName;
        //这个属于发起请求并获取json数据（得引入hutool，即上面引入的第二个依赖）
        String json= HttpUtil.createGet(url).execute().body();
        //转化请求的 json 数据
        JSONObject jsonObject = JSONObject.parseObject(json);
        //获取 error 返回状态码
        String latestNewsTime = jsonObject.getString("latestNewsTime");
        int hours=0;
        if(!latestNewsTime.contains("None")) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            String sd = simpleFormat.format(new Date(Long.parseLong(latestNewsTime) * 1000));
            System.out.println(siteName + "————资讯最新发布时间：" + sd);
             hours = SouGouSearch.getBeforeTime(latestNewsTime);
        }
        return 0;
    }
    public static int getMsgTime(String wxname){
        int hours=0;
        wxname=wxname.replace(" ","");
        String url="https://weixin.sogou.com/weixin?type=1&s_from=input&query="+wxname;
        String s = connect(url);
        System.out.println(wxname+"搜狗搜索的内容长度："+s.length());
        Document document = Jsoup.parse(s);
        Elements elements;
        try {
             elements = document.select("div[class=\"news-box\"]>ul[class=\"news-list2\"]>li");
            System.out.println(wxname+"搜狗搜索到内容个数："+elements.size());
            if(elements.size()<1){
                Thread.sleep(10000);
                getCookie3();
                String connect = connect(url);
                document = Jsoup.parse(connect);
                elements = document.select("div[class=\"news-box\"]>ul[class=\"news-list2\"]>li");
            }
        }catch (Exception e){
            String connect = get(url);
            document = Jsoup.parse(connect);
            elements = document.select("div[class=\"news-box\"]>ul[class=\"news-list2\"]>li");
            if(elements.size()<1){
                return hours;
            }
        }
        try {
        for (Element element :elements) {
            String name = element.select("p[class=\"tit\"]>a>em").text();
            String wxhao = element.select("label[name=\"em_weixinhao\"]").text();
            String title = element.select("dd>a").text();
            String index  = element.select("span>script").outerHtml();
            String time="";
            String matchUrl="\\d{1,}";
            Pattern pattern = Pattern.compile(matchUrl);
            Matcher matcher = pattern.matcher(index);
            if(matcher.find()){
                time=matcher.group();

            }
            if(name.equals(wxname)) {
                hours=getBeforeTime(time);
                System.out.println(wxname+"最新资讯发布时间"+hours);
            }
        }
        }catch (Exception e){
            return hours;
        }
        return hours;
    }
    public static int getBeforeTime( String oldTime){
        long old = Long.parseLong(oldTime)*1000;
        long now=System.currentTimeMillis();
        int hours = (int) ((now - old)/(1000 * 60*60));
        return hours;
    }

    public static int getHours( String oldTime,String nowTime){
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        long from = 0;
        long to=0;
        try {
            from = simpleFormat.parse(oldTime).getTime();
            to = simpleFormat.parse(nowTime).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int hours = (int) ((to - from)/(1000 * 60*60));
        return hours;
    }

    public static Map<String,String> paser(String content,String keyword) {
        Document document = Jsoup.parse(content);
        Map<String, String> map = new HashMap<>();
        Elements elements = document.select("div[class=\"news-box\"]>ul[class=\"news-list2\"]>li");
        for (Element element : elements) {
            String wxname = element.select("p[class=\"tit\"]>a>em").text();
            String wxhao = element.select("label[name=\"em_weixinhao\"]").text();
            String title = element.select("dl:eq(2)>dd>a").text();
            String index = element.select("dl:eq(2)>dd>span>script").outerHtml();
            String time = "";
            String matchUrl = "\\d{1,}";
            Pattern pattern = Pattern.compile(matchUrl);
            Matcher matcher = pattern.matcher(index);
            if (matcher.find()) {
                time = matcher.group();
            }
            if(wxname.contains(keyword)) {
                map.put("wxname", wxname);
                map.put("wxhao", wxhao);
                map.put("title", title);
                map.put("time", time);
            }
        }
        return map;
    }

    public static String connect(String  url) {
        // 创建httpget.
        HttpGet httpget = new HttpGet(url);
//            httpget.addHeader("token"," token");
        httpget.addHeader("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
        httpget.addHeader("Accept-Encoding","gzip, deflate, br");
        httpget.addHeader("Accept-Language","zh-CN,zh;q=0.9");
        httpget.addHeader("Cache-Control","no-cache");
        httpget.addHeader("Connection","keep-alive");
        httpget.addHeader("Host","weixin.sogou.com");
        httpget.addHeader("Pragma","no-cache");
        httpget.addHeader("sec-ch-ua","\".Not/A)Brand\";v=\"99\", \"Google Chrome\";v=\"103\", \"Chromium\";v=\"103\"");
        httpget.addHeader("sec-ch-ua-mobile","?0");
        httpget.addHeader("sec-ch-ua-platform","Windows");
        httpget.addHeader("Sec-Fetch-Dest","document");
        httpget.addHeader("Sec-Fetch-Mode","navigate");
        httpget.addHeader("Sec-Fetch-Site","none");
        httpget.addHeader("Sec-Fetch-User","?1");
        httpget.addHeader("Upgrade-Insecure-Requests","1");
        httpget.addHeader("User-Agent","ozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36");
        try {
            String wxcookies = JedisUtil.getString("wxcookies");
            httpget.addHeader("Cookie", wxcookies);
        }catch (Exception e){
            httpget.addHeader("Cookie", "ABTEST=0|1660717633|v1; IPLOC=CN1100; SUID=31A373722583A20A0000000062FC8A41; SUID=31A373727050A00A0000000062FC8A41; JSESSIONID=aaaTAV1wUSPUH8_i9Czjy; SUV=00B7E8BD7273A33162FC8A437C13A967; PHPSESSID=4kh8ifemsbo3o9picgb43uot52; weixinIndexVisited=1; ariaDefaultTheme=undefined; seccodeErrorCount=1|Thu, 18 Aug 2022 03:51:16 GMT; SNUID=2FBD6E6F1D18FB66CD8E1E051E83C0CB; seccodeRight=success; successCount=1|Thu, 18 Aug 2022 03:51:28 GMT; refresh=1");
        }
        //            System.out.println("executing request " + httpget.getURI());

        String content="";//返回结果
        CloseableHttpResponse response = null;
        try {
            //1、创建httpClient
            CloseableHttpClient client = null;
            try {
                String proxyIP = getProxyIP();
                System.out.println("代理IP ："+proxyIP);
                String[] proxys=proxyIP.split("-");
                String proxyHost = proxys[0];
                int proxyPort = Integer.parseInt(proxys[1]);
                String userName = proxys[2];
                String password = proxys[3];
                //把代理设置到请求配置        代理IP     端口
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                //超时时间单位为毫秒
                RequestConfig defaultRequestConfig = RequestConfig.custom()
                        .setConnectTimeout(600).setSocketTimeout(600)
                        .setProxy(proxy).build();
                client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();

                response = client.execute(httpget);
            } catch (UnknownHostException hostEx) {
                hostEx.printStackTrace();
            }
            //2、获取实体
            HttpEntity entity = response.getEntity();
            //将实体装成字符串
            content = EntityUtils.toString(entity,"utf-8");
//            System.out.println("返回结果---" + str);
            response.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }
    public static String getProxyIP(){
        int r = RandomUtil.randomInt(1, 5);
        String searchSql = "select proxy from CIS_sys_Proxy where ID = "+r;
        String proxy="";
        OracleDBManager dm = new OracleDBManager();
        String[] coulmn = null;
        int[] type = null;
        try {
            OracleDataTable dt = dm.getResultData(coulmn, type, searchSql);
            if(dt != null && dt.getRowCount()> 0){
                for(int i = 0; i<dt.getRowCount(); i++){
                    for(int j = 0; j<dt.getColCoun(); j++)
                        if(dt.getRow()[i][j].length()>5){
                            proxy=dt.getRow()[i][j];
                        }
                }
            }else
                System.out.println("查询失败");
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return proxy;
    }
    /**
     * 发送 get请求
     */
    public static String  get(String url) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String content="";
        try {
            // 创建httpget.
            HttpGet httpget = new HttpGet(url);
//            httpget.addHeader("token"," token");
//            httpget.addHeader("Connection","keep-alive");
//            httpget.addHeader("Cache-Control","max-age=0");
//            httpget.addHeader("Upgrade-Insecure-Requests","1");
//            httpget.addHeader("User-Agent","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36");
//            httpget.addHeader("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
//            httpget.addHeader("Sec-Fetch-Site","none");
//            httpget.addHeader("Sec-Fetch-Mode","navigate");
//            httpget.addHeader("Sec-Fetch-User","?1");
//            httpget.addHeader("Sec-Fetch-Dest","document");
//            httpget.addHeader("Accept-Language","zh-CN,zh;q=0.9");
//            httpget.addHeader("Cookie","IPLOC=CN4101; SUV=001D46FC7D29AE7D61163051AB952530; SUID=D381343DC830A40A0000000061163173; GOTO=Af121011; SNUID=FD28FF2CF0F53E5DB8F35ED0F18CD145; ABTEST=0|1634614242|v1; weixinIndexVisited=1; JSESSIONID=aaaa12QKYfTMweWDxHhUx; ld=Kyllllllll2Pb6lklllllpVmyjllllllKvum1kllll9lllll9Zlll5@@@@@@@@@@");
//
            httpget.addHeader("Accept"," text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
            httpget.addHeader("Accept-Encoding"," gzip, deflate, br");
            httpget.addHeader("Accept-Language"," zh-CN,zh;q=0.9");
            httpget.addHeader("Cache-Control"," no-cache");
            httpget.addHeader("Connection"," keep-alive");
//            httpget.addHeader("Cookie"," IPLOC=CN4101; SUID=F13BC1017050A00A0000000062F5A954; SUV=0031B52401C13BF162F5A957A7627723; ABTEST=7|1660267032|v1; SNUID=E02AD1101015F72D8DD7445011AFD22F; JSESSIONID=aaazx-kvMzR_vhM3OCzjy; ariaDefaultTheme=undefined");
            httpget.addHeader("Host"," weixin.sogou.com");
            httpget.addHeader("Pragma"," no-cache");
            httpget.addHeader("sec-ch-ua","\".Not/A)Brand\";v=\"99\", \"Google Chrome\";v=\"103\", \"Chromium\";v=\"103\"");
            httpget.addHeader("sec-ch-ua-mobile"," ?0");
            httpget.addHeader("sec-ch-ua-platform"," Windows");
            httpget.addHeader("Sec-Fetch-Dest"," document");
            httpget.addHeader("Sec-Fetch-Mode"," navigate");
            httpget.addHeader("Sec-Fetch-Site"," none");
            httpget.addHeader("Sec-Fetch-User"," ?1");
            httpget.addHeader("Upgrade-Insecure-Requests"," 1");
            httpget.addHeader("User-Agent"," Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36");
            //            System.out.println("executing request " + httpget.getURI());
            // 执行get请求.
            CloseableHttpResponse response = httpclient.execute(httpget);
            try {
                // 获取响应实体
//                HttpEntity entity = response.getEntity();
//                System.out.println("--------------------------------------");
                // 打印响应状态
//                System.out.println(response.getStatusLine());
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    String message = EntityUtils.toString(entity, "utf-8");
//                    System.out.println(message);
                    content=message;
                } else {
                    System.out.println("请求失败");
                }
//                System.out.println("------------------------------------");
            } finally {
                response.close();
            }
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        }  catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 关闭连接,释放资源
            try {
                httpclient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
            return content;
        }

    }

    /**
     * 获取cookie
     *
     * @param url
     *            发送请求的URL
     * @return key=value;key=value;...
     */
    public static Map<String,String> getCookie2(String url) {
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            conn = (HttpURLConnection) realUrl.openConnection();
            conn.setRequestProperty("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Encoding","gzip, deflate, sdch");
            conn.setRequestProperty("Accept-Language","zh-CN,zh;q=0.8");
            conn.setRequestProperty("Cache-Control","max-age=0");
            conn.setRequestProperty("connection", "Keep-Alive");
            //conn.setRequestProperty("Host","www.zjtax.gov.cn");
            conn.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            //是否自动执行 http 重定向，默认为true
            //如果实际操作中，不存在重定向问题，不需要设置此行。
            conn.setInstanceFollowRedirects(false);

            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String sessionId = "";
        String cookieVal = "";
        String key = null;

      Map<String, List<String>> map2 = conn.getHeaderFields();
//      for (String key1 : map2.keySet()) {
//          System.out.println(key1 + "--->" + map2.get(key1));
//      }
        //取cookie
        Map<String,String> map=new HashMap<>();
        for(int i = 1; (key = conn.getHeaderFieldKey(i)) != null; i++){
            if(key.equalsIgnoreCase("set-cookie")){
                cookieVal = conn.getHeaderField(i);
                System.out.println("cookieVal"+cookieVal);
                cookieVal = cookieVal.substring(0, cookieVal.indexOf(";"));
                if(cookieVal.contains("SUID")||cookieVal.contains("SNUID")){
                    String keys = cookieVal.substring(0,cookieVal.indexOf("="));
                    String val = cookieVal.substring(cookieVal.indexOf("=")+1);
                    map.put(keys,val);
                }
            }
        }
        //如果实际操作中，不存在重定向问题，不需要以下四行
//        String location= conn.getHeaderField("Location");//获取 重定向地址
//        List<String> list = getCookie3(location,sessionId);
//        List<String> list2 = getCookie3(list.get(1),sessionId+list.get(0));
//        sessionId = sessionId + list2.get(0);

        return map;
    }

    public static String getCookie3() {
        HttpURLConnection conn = null;
        try {
            String url="https://v.sogou.com/?forceredirect=2&ie=utf8";
            URL realUrl = new URL(url);
            conn = (HttpURLConnection) realUrl.openConnection();
            conn.setRequestProperty("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Encoding","gzip, deflate, sdch");
            conn.setRequestProperty("Accept-Language","zh-CN,zh;q=0.8");
            conn.setRequestProperty("Cache-Control","max-age=0");
            conn.setRequestProperty("connection", "Keep-Alive");
            //conn.setRequestProperty("Host","www.zjtax.gov.cn");
            conn.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            //是否自动执行 http 重定向，默认为true
            //如果实际操作中，不存在重定向问题，不需要设置此行。
            conn.setInstanceFollowRedirects(false);

            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String sessionId = "";
        String cookieVal = "";
        String key = null;

        Map<String, List<String>> map2 = conn.getHeaderFields();
//      for (String key1 : map2.keySet()) {
//          System.out.println(key1 + "--->" + map2.get(key1));
//      }
        //取cookie
        Map<String,String> map=new HashMap<>();
        for(int i = 1; (key = conn.getHeaderFieldKey(i)) != null; i++){
            if(key.equalsIgnoreCase("set-cookie")){
                cookieVal = conn.getHeaderField(i);
            }
        }
        //如果实际操作中，不存在重定向问题，不需要以下四行
//        String location= conn.getHeaderField("Location");//获取 重定向地址
//        List<String> list = getCookie3(location,sessionId);
//        List<String> list2 = getCookie3(list.get(1),sessionId+list.get(0));
//        sessionId = sessionId + list2.get(0);
        try {
            JedisUtil.setString("wxcookies",cookieVal,0);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return cookieVal;
    }
}
