package com.zzsn.utility.index;

import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * 系统变量
 * 创建人：李东亮   
 * 创建时间：2015-5-12 上午11:52:07   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
@Slf4j
public class Constants {

    private static Properties prop = getConfig();
//    private static Properties prop = new Properties();
//    static {
//        try {
//            prop.load(Constants.class.getResourceAsStream("constants.properties"));
//        } catch (IOException e) {
//            // TODO Auto-generated catch block
//            log.error("错误", e);
//            e.printStackTrace();
//        }
//    }

    public static Properties getConfig() {
        Properties properties = new Properties();
        InputStream is = null;
        String location = "constants.properties";
        try {
            Resource resource = new DefaultResourceLoader().getResource(location);
            is = resource.getInputStream();
            properties.load(is);
            log.debug("constants config: {}", properties.toString());
        } catch (IOException ex) {
            log.error("Could not load property file:" + location, ex);
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (IOException ioe) {
                // ignore
            }
        }
        return properties;
    }

    //爬取到的网页类型
    public static final String TYPE_HTML = "HTML";

    public static final String TYPE_EXCEL = "EXCEL";

    public static final String TYPE_WORD = "WORD";

    public static final String TYPE_PPT = "PPT";

    public static final String TYPE_PDF = "PDF";

    public static final String TYPE_IMG = "IMG";
    
    public static final String DEFAULT_LANG="cn";

    public static final String WORK_URL = prop.getProperty("WORK_URL");

    public static final String LOCAL_URL = prop.getProperty("LOCAL_URL");
    public static final String ORGS = prop.getProperty("ORGS");
    public static final String TID = prop.getProperty("TID");
    public static final Integer PROXYFLAG = Integer.parseInt(prop.getProperty("PROXY"));
    public static final long PROXYID = Long.parseLong(prop.getProperty("PROXYID"));
    public static final String CHROMEDRIVE = prop.getProperty("CHROMEDRIVE");
	public static final String CHROMEBIN = prop.getProperty("CHROMEBIN");

    public static final String  KAFKA_CONSUMER_SERVERS= prop.getProperty("KAFKA_CONSUMER_SERVERS");
    public static final String  KAFKA_CONSUMER_TOPIC= prop.getProperty("KAFKA_CONSUMER_TOPIC");
    public static final String  KAFKA_CONSUMER_GROUP_ID= prop.getProperty("KAFKA_CONSUMER_GROUP_ID");
    public static final String  KAFKA_CONSUMER_AUTO_OFFSET_RESET= prop.getProperty("KAFKA_CONSUMER_AUTO_OFFSET_RESET");

    public static final String  PROXY= prop.getProperty("PROXY");
    public static final String  KAFKA_PRODUCT_TOPIC= prop.getProperty("KAFKA_PRODUCT_TOPIC");

    public static final String  KAFKA_PRODUCT_URLLIST_TOPIC= prop.getProperty("KAFKA_PRODUCT_URLLIST_TOPIC");
    public static final String  KAFKA_PRODUCT_GOOGLE_URLLIST_TOPIC= prop.getProperty("KAFKA_PRODUCT_GOOGLE_URLLIST_TOPIC");
//    public static final String  KAFKA_PRODUCT_PASERURL_TOPIC= prop.getProperty("KAFKA_PRODUCT_PASERURL_TOPIC");

    public static final String  SOURCEADDRESS="SOURCEADDRESS_";

    public static final String  META_SEARCH_URL= prop.getProperty("META_SEARCH_URL");
    public static final String  META_SEARCH_KEYWORDPATH= prop.getProperty("META_SEARCH_KEYWORDPATH");

    //    redis
    public static final String  REDIS_LOCALHOST= prop.getProperty("redis.host");
    public static final String  REDIS_PORT= prop.getProperty("redis.port");
    public static final String  REDIS_PASS= prop.getProperty("redis.pass");
    public static final String  REDIS_TIMEOUT= prop.getProperty("redis.timeout");
    public static final String  REDIS_MAXIDLE= prop.getProperty("redis.maxIdle");
    public static final String  REDIS_MAXTOTAL= prop.getProperty("redis.maxTotal");
    public static final String  REDIS_MAXWAITMILLIS= prop.getProperty("redis.maxWaitMillis");
    public static final String  REDIS_TESTONBORROW= prop.getProperty("redis.testOnBorrow");


    public static final Integer THREAD_SIZE =Integer.valueOf(prop.getProperty("THREAD_SIZE"));
}
