package com.zzsn.test;
 
 
 
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class GetPostTest {

    public static String sendGet(String url) {
        String result = "";
        String urlName = url;
        try {
            URL realURL = new URL(urlName);
            URLConnection conn = realURL.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36");
            conn.connect();
            Map<String, List<String>> map = conn.getHeaderFields();
            for (String s : map.keySet()) {
                System.out.println(s + "-->" + map.get(s));
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += "\n" + line;
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
    public static String sendGet2(String url) {
        String result = "";
        String urlName = url;
        try {
            URL realURL = new URL(urlName);
            URLConnection conn = realURL.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36");
            conn.connect();
            Map<String, List<String>> map = conn.getHeaderFields();
            for (String s : map.keySet()) {
                if(s!=null && s.contains("Location")){
                    if(map.get(s).size()>0){
                        result=map.get(s).get(0);
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String sendPost(String url,String param){
        String result = "";
        HttpURLConnection conn = null;  
        try {
            URL realUrl = new URL(url);
            conn =    (HttpURLConnection) realUrl.openConnection();
             
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36");
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Connection", "Keep-Alive");// 维持长连接
            conn.setInstanceFollowRedirects(true);
             
            conn.setInstanceFollowRedirects(false);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            //post设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);//这一行必须要写，因为要将参数放在outputStream中输出
            //PrintWriter out = new PrintWriter(conn.getOutputStream());
            //out.print(param);
            PrintWriter out =new PrintWriter(conn.getOutputStream());
            //out.write(param);
            out.print(param);  //写入缓存
            out.flush();
                    
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(),"utf-8"));// 发送请求参数
            String line;
            while((line = in.readLine()) != null){
                result +="\n" + line;
                    }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 向指定 URL 发送POST方法的请求
     *
     * @param url
     *            发送请求的 URL
     * @param param
     *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @param encode
     *            请求页面的字符编码
     * @param cookie
     *            cookie
     * @return 所代表远程资源的响应结果
     */
    public static String sendPost1(String url, String param, String encode,String cookie) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection conn = realUrl.openConnection();
            // 设置通用的请求属性
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Language","zh-CN,zh;q=0.8");
            conn.setRequestProperty("Cache-Control","max-age=0");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Cookie",cookie);
            //conn.setRequestProperty("Host","www.zjtax.gov.cn");
            conn.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            // 获取URLConnection对象对应的输出流
            out = new PrintWriter(conn.getOutputStream());
            // 发送请求参数
            out.print(param);
            // flush输出流的缓冲
            out.flush();
            // 定义BufferedReader输入流来读取URL的响应
            in = new BufferedReader(
                    new InputStreamReader(conn.getInputStream(),encode));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            System.out.println("发送 POST 请求出现异常！"+e);
            e.printStackTrace();
        }
        //使用finally块来关闭输出流、输入流
        finally{
            try{
                if(out!=null){
                    out.close();
                }
                if(in!=null){
                    in.close();
                }
            }
            catch(IOException ex){
                ex.printStackTrace();
            }
        }
        return result;
    }
    /**
     * 获取cookie
     *
     * @param url
     *            发送请求的URL
     * @return key=value;key=value;...
     */
    public static Map<String,String> getCookie2(String url) {
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            conn = (HttpURLConnection) realUrl.openConnection();
            conn.setRequestProperty("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Encoding","gzip, deflate, sdch");
            conn.setRequestProperty("Accept-Language","zh-CN,zh;q=0.8");
            conn.setRequestProperty("Cache-Control","max-age=0");
            conn.setRequestProperty("connection", "Keep-Alive");
            //conn.setRequestProperty("Host","www.zjtax.gov.cn");
            conn.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            //是否自动执行 http 重定向，默认为true
            //如果实际操作中，不存在重定向问题，不需要设置此行。
            conn.setInstanceFollowRedirects(false);

            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String sessionId = "";
        String cookieVal = "";
        String key = null;

//      Map<String,List<String>> map = conn.getHeaderFields();
//      for (String key1 : map.keySet()) {
//          System.out.println(key1 + "--->" + map.get(key1));
//      }
        //取cookie
        Map<String,String> map=new HashMap<>();
        for(int i = 1; (key = conn.getHeaderFieldKey(i)) != null; i++){
            if(key.equalsIgnoreCase("set-cookie")){
                cookieVal = conn.getHeaderField(i);
                cookieVal = cookieVal.substring(0, cookieVal.indexOf(";"));
                if(cookieVal.contains("SUID")||cookieVal.contains("SNUID")){
                    String keys = cookieVal.substring(0,cookieVal.indexOf("="));
                    String val = cookieVal.substring(cookieVal.indexOf("=")+1);
                    map.put(keys,val);
                }
            }
        }
        //如果实际操作中，不存在重定向问题，不需要以下四行
//        String location= conn.getHeaderField("Location");//获取 重定向地址
//        List<String> list = getCookie3(location,sessionId);
//        List<String> list2 = getCookie3(list.get(1),sessionId+list.get(0));
//        sessionId = sessionId + list2.get(0);

        return map;
    }
    /**
     * 获取 cookie
     * @param url
     *          发送请求的URL
     * @param cookie
     *          cookie
     */
    public static List<String> getCookie3(String url,String cookie) {
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            conn = (HttpURLConnection) realUrl.openConnection();
            conn.setRequestProperty("Accept","text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Encoding","gzip, deflate, sdch");
            conn.setRequestProperty("Accept-Language","zh-CN,zh;q=0.8");
            conn.setRequestProperty("Cache-Control","max-age=0");
            conn.setRequestProperty("connection", "Keep-Alive");
            //conn.setRequestProperty("Host","www.zjtax.gov.cn");
            conn.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Cookie",cookie);

            conn.setInstanceFollowRedirects(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String sessionId = "";
        String cookieVal = "";
        String key = null;
        String location= conn.getHeaderField("Location");

        for(int i = 1; (key = conn.getHeaderFieldKey(i)) != null; i++){
            if(key.equalsIgnoreCase("set-cookie")){
                cookieVal = conn.getHeaderField(i);
                cookieVal = cookieVal.substring(0, cookieVal.indexOf(";"));
                sessionId = sessionId + cookieVal + ";";
            }
        }
        List<String> list = new ArrayList<String>();
        list.add(sessionId);//存放cookie
        list.add(location);//存放重定向地址
        return list;
    }

    public static void main(String[] args) {
//        String param = "Search%2FAirlineMode=false&Search%2FcalendarCacheSearchDays=60&Search%2FcalendarSearched=false&dropOffLocationRequired=false&Search%2FsearchType=F&searchTypeValidator=F&xSellMode=false&Search%2FflightType=oneway&destinationLocationSearchBoxType=L&Search%2FisUserPrice=1&Search%2FOriginDestinationInformation%2FOrigin%2Flocation=CITY_BJS_CN&Search%2FOriginDestinationInformation%2FOrigin%2Flocation_input=%E5%8C%97%E4%BA%AC&Search%2FOriginDestinationInformation%2FDestination%2Flocation=CITY_CTU_CN&Search%2FOriginDestinationInformation%2FDestination%2Flocation_input=%E6%88%90%E9%83%BD&Search%2FDateInformation%2FdepartDate_display=2018-09-06&Search%2FDateInformation%2FdepartDate=2018-09-06&Search%2FDateInformation%2FreturnDate=2018-09-05&Search%2FcalendarSearch=false&Search%2FPassengers%2Fadults=1&Search%2FPassengers%2Fchildren=0&Search%2FpromotionCode=";
//        //String param = "";
//        String sendRecvPost =GetPostTest.sendPost("http://flights.sichuanair.com/3uair/ibe/common/processSearchForm.do",param);
//        System.out.println(sendRecvPost);
        String s = GetPostTest.sendGet("https://news.search.yahoo.com/search?p=camila+cabello&ei=UTF-8&b=11&pz=10&bct=0&xargs=0");
        System.out.println("++++++++++++++");
        System.out.println(s);
//        String s = GetPostTest.sendGet2("https://r.search.yahoo.com/cbclk2/dWU9Rjc1RjcxOTJGRTNDNDIxNCZ1dD0xNjUyNzU2NzU5NzgwJnVvPTcxNjc0NTA5NzMwMTM0Jmx0PTImcz0xJmVzPWlFQU4uX3dHUFMuMDhuTWZfRzF0UWs1c0NEcGRFX3JDOVJZRTVhYTk2a19NMWpRLQ--/RV=2/RE=1652785559/RO=10/RU=https%3a%2f%2fwww.bing.com%2faclick%3fld%3de8fQ3skeVyCmtdkXvJyer7lDVUCUyhmNmibXcU1g8Hhd8ZTP9yVbfAq5pNRMZ_6fHx8vQlszU4iyBnCrBPhJkkzdfcQjSK1zSIRvAuckKG1yLbotUiY-nz2v9wutjIGsfPzL1L_eSvC27hY1k4hD4Qxo_Rmg_G_1Q1KbJPdoZKtAY13AUSbO7IqFUetTg2hQpVKAISYw%26u%3daHR0cCUzYSUyZiUyZnd3dy5hdXRvbWV0YWxkaXJlY3QuY29tJTJmaW5kZXgucGhwJTNmbXNjbGtpZCUzZDJiNDZkMDcwOTQ1YzE2YjBiMmNkYjJmMzg1NGI5ZDkzJTI2dXRtX3NvdXJjZSUzZGJpbmclMjZ1dG1fbWVkaXVtJTNkY3BjJTI2dXRtX2NhbXBhaWduJTNkU0MlMjUyMC0lMjUyMFRyYWRlbWFyayUyNTIwQnJhbmRlZCUyNTIwLSUyNTIwRXhhY3QlMjZ1dG1fdGVybSUzZGh0dHAlMjUyMHd3dyUyNTIwJTI1MkJhbWQlMjUyMGNvbSUyNnV0bV9jb250ZW50JTNkQU1EJTI1MjBQYXJ0cw%26rlid%3d2b46d070945c16b0b2cdb2f3854b9d93/RK=2/RS=oav4rOCFRVacozG5vDOB2Ug99Ik-;_ylt=AwrXnCIXEYNig1EAyiTQtDMD;_ylu=Y29sbwNncTEEcG9zAzIEdnRpZAMEc2VjA292LXRvcA--?IG=0ad79c22e5134c6b9000000000e0df0b");
//        System.out.println("++++++++++++++");
//        System.out.println(s);
        //        Pattern pattern = Pattern.compile("URL=\\'(.{1,})\\'");
//        Matcher matcher = pattern.matcher(s);
//        StringBuffer buffer = new StringBuffer();
//        while(matcher.find()){
//            buffer.append(matcher.group(1));
//            buffer.append("\r\n");
//        }
//        System.out.println(buffer.toString());

//        Map<String, String> cookie2 = getCookie2("https://www.sogou.com/sogou?interation=1728053249&query=intitle:Intel%20%E5%88%9B%E6%96%B0&tsn=0&page=2&ie=utf8&dp=1");
//        System.out.println(cookie2);
    }
     
}
