package com.zzsn.utility.util;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class TestExcel {
	 
    public static void main(String[] args) {
        String filePath = "D:\\test1\\2.xls";
        InputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            Workbook workbook = null;
            if (filePath.endsWith(".xlsx")) {
                workbook = new XSSFWorkbook(fis);
            } else if (filePath.endsWith(".xls") || filePath.endsWith(".et")) {
                workbook = new HSSFWorkbook(fis);
            }
            fis.close();
            /* 读EXCEL文字内容 */
            // 获取第一个sheet表，也可使用sheet表名获取
            Sheet sheet = workbook.getSheetAt(0);
            // 获取行
            Iterator<Row> rows = sheet.rowIterator();
            Row row;
            Cell cell;
            Integer i=0;
            while (rows.hasNext()) {
            	i++;
            	row = rows.next();
            	if(i<=200) {
            		continue;
            	}
            	if(i>343) {
            		break;
            	}
                // 获取单元格
                cell=row.getCell(6);
                Cell cell1=row.getCell(2);
                Cell cell2=row.getCell(5);
                String name=cell1.getStringCellValue();
                String path=cell2.getStringCellValue();
                    String cellValue =cell.getStringCellValue();
                    System.out.print(cellValue + " ");
                System.out.println();
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (null != fis) {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
 
    }
}

