package com.zzsn.util;


import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SplitKeyword {

    //关键词处理
    public static List<String> transForm(String keyWords) {
        if (keyWords == null) {
            return null;
        }
        //（*备注：或：用“，”号表示，与：用“+”号表示，非：用“-”号表示）
        keyWords = keyWords.replaceAll("[,，;；]", "|");
        keyWords = keyWords.replace("（", "(");
        keyWords = keyWords.replace("）", ")");

        List<String> keyWordsList = new ArrayList<>();

        if (!keyWords.contains("+")) { //不含有+  形式：A|B|C
            keyWords = keyWords.replace("(", "");
            keyWords = keyWords.replace(")", "");
            keyWordsList = Arrays.asList(keyWords.split("\\|"));

        } else if (keyWords.contains(")+(")) { //含有+ 形式：(A|B)+(C|D)+(E|F)
            String[] cronArray = keyWords.split("\\+");
            List<List<String>> list = new ArrayList<>();
            for (int i = 0; i < cronArray.length; i++) {
                cronArray[i] = cronArray[i].replace("(", "");
                cronArray[i] = cronArray[i].replace(")", "");
                cronArray[i] = cronArray[i].replace("|", ",");
                list.add(Arrays.asList(cronArray[i].split(",")));
            }
            List<String> stringList = getPermutations(list);
            for (String str : stringList) {
                keyWordsList.add(str.substring(0, str.length() - 1));
            }
        }else if (keyWords.contains(")+")) { //含有+ 形式：(A|B)+(C|D)+(E|F)
            String[] cronArray = keyWords.split("\\+");
            List<List<String>> list = new ArrayList<>();
            for (int i = 0; i < cronArray.length; i++) {
                cronArray[i] = cronArray[i].replace("(", "");
                cronArray[i] = cronArray[i].replace(")", "");
                cronArray[i] = cronArray[i].replace("|", ",");
                list.add(Arrays.asList(cronArray[i].split(",")));
            }
            List<String> stringList = getPermutations(list);
            for (String str : stringList) {
                keyWordsList.add(str.substring(0, str.length() - 1));
            }
        }
        return keyWordsList;
    }


    /**
     * 多个数组排列组合
     * @param list 原始list
     * @param <T> 数据类型
     * @return
     */
    private static <T> List<List<T>> getDescartes(List<List<T>> list) {
        List<List<T>> returnList = new ArrayList<>();
        descartesRecursive(list, 0, returnList, new ArrayList<T>());
        return returnList;
    }

    /**
     * 递归实现
     * 原理：从原始list的0开始依次遍历到最后
     *
     * @param originalList 原始list
     * @param position     当前递归在原始list的position
     * @param returnList   返回结果
     * @param cacheList    临时保存的list
     */
    private static <T> void descartesRecursive(List<List<T>> originalList, int position, List<List<T>> returnList, List<T> cacheList) {
        List<T> originalItemList = originalList.get(position);
        for (int i = 0; i < originalItemList.size(); i++) {
            //最后一个复用cacheList，节省内存
            List<T> childCacheList = (i == originalItemList.size() - 1) ? cacheList : new ArrayList<>(cacheList);
            childCacheList.add(originalItemList.get(i));
            if (position == originalList.size() - 1) {//遍历到最后退出递归
                returnList.add(childCacheList);
                continue;
            }
            descartesRecursive(originalList, position + 1, returnList, childCacheList);
        }
    }

    /**
     * 多个数组排列组合
     * @param list 原始list
     * @return
     */
    private static List<String> getPermutations(List<List<String>> list) {
        List<String> resultList = new ArrayList<>();
        List<List<String>> list1 = getDescartes(list);
        if(!CollectionUtils.isEmpty(list1)){
            list1.forEach(temp->{
                String str = listToStr(temp);
                if (!org.springframework.util.StringUtils.isEmpty(str)) {
                    resultList.add(listToStr(temp));
                }
            });
        }
        return resultList;
    }

    private static String listToStr(List<String> list){
        StringBuffer str = new StringBuffer();
        if(!CollectionUtils.isEmpty(list)){
            list.forEach(temp->{
                str.append(temp).append("+");
            });
        }
        return str.toString();
    }

    public static void main(String[] args) {
        String kwords="(超微半导体|英特尔|高通公司|日本电信电话株式会社|爱立信|东芝|LG电子|三星|泰科电子|苹果|富士通|日本电气|奥林巴斯|索尼|通用电气|日立|艾默生电气|霍尼韦尔|波音|3M公司|陶氏公司|圣戈班|信越化学|LS电气|本田|丰田|微软|诺顿LifeLock|罗氏公司|AMD|Intel|Qualcomm|NTT|Ericsson|Toshiba|LG Electronics|Samsung Electronics|TE Connectivity|Apple|Fujitsu|NEC|Panasonic|Sony|GE|Hitachi|Emerson|Honeywell|Boeing|Dow|Saint-Gobain|LS Electric|Honda|Toyota|Microsoft|NortonLifeLock|Roche)+(重大战略|国家战略|科技资源|科技攻关|科技创新|技术创新|创新发展|协同创新|人工智能|自主创新|知识产权|关键核心技术|科技创新能力|竞争力|高新技术|科技成果|创新能力|产业创新|创新驱动|核心技术|创新引领|关键技术|制度创新|研发投入|技术研发|人才队伍|人才创新|科技人才)";
        List<String> strings = transForm(kwords);
        for (String key :strings) {
            System.out.println(key);
        }
    }
}
