package com.zzsn.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 常用方法
 * 创建人：李东亮   
 * 创建时间：2015-5-14 下午6:19:59   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class FileUtil {
	private static final Logger Log = LoggerFactory.getLogger(FileUtil.class);
	static int NAME= 0 ;
	/**
	 * 正则获取匹配内容
	 * 创建人:  李东亮  
	 * 创建时间:  2015-5-14 下午5:26:25 
	 * @version 1.0
	 * @param html
	 * @param reg
	 * @return
	 */
	public static String reg(String html,String reg){
		Pattern p = Pattern.compile(reg);//"(<[^>]*>)"
		Matcher m = p.matcher(html);
		List<String> result = new ArrayList<String>();
		while(m.find()){
			result.add(m.group());
		}
		StringBuffer sb = new StringBuffer();
		for(String str : result){
			sb.append(str);
			sb.append("  ");
		}
		return sb.toString();
	}
	
	public static String readContent(InputStream inputstream){
	    StringBuffer content = new StringBuffer();
	    byte[] bytes = new byte[512];
	    try {
            while(inputstream.read(bytes)!=-1){
                content.append(new String(bytes));
            }
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
	    
	    return content.toString();
	}
	

	/**
	 * 读取文章
	 * 创建人:  李东亮  
	 * 创建时间:  2015-5-25 下午1:42:14 
	 * @version 1.0
	 * @param inputstream
	 * @return
	 */
	public static String readHtml(InputStream inputstream,String chartset)throws Exception{
		StringBuffer sb = new StringBuffer();
		BufferedReader br  = null;
		try {
			 br = new BufferedReader(new InputStreamReader(inputstream,chartset));
		  //  String buffer ;
		    char[] cbuf = new char[512];
		    int count;
			while (( count = br.read(cbuf))!=-1){
			     sb.append(new String(cbuf,0,count));
			}
		//	w.close();
		}finally{
				br.close();
		}
		return sb.toString();
	}
	/**
	 * 文件内容读入到字符串
	 * 创建人:  李东亮  
	 * 创建时间:  2015-5-14 下午5:22:38 
	 * @version 1.0
	 * @param file
	 * @return
	 */
	public static  String readFile(File file,String chartset){
		StringBuffer sb = new StringBuffer();
		BufferedReader br  = null;
		try {
			 br = new BufferedReader(new InputStreamReader(new FileInputStream(file),chartset));
		    char[] buffer = new char[512];
		    int index;
			while ((index = br.read(buffer))!=-1){
			//	sb.append(" ");
				sb.append(new String(buffer,0,index));
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				br.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return sb.toString();
	}
	
	/**
	 * 把字符串写入文件
	 * 创建人:  李东亮  
	 * 创建时间:  2015-5-14 下午5:40:21 
	 * @version 1.0
	 * @param file
	 * @param str
	 */
	public static void writeUTF8File(File file,String str,String charset){
		
		FileOutputStream fos = null;
		try {
			 fos = new FileOutputStream(file);
			 fos.write(("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset="+charset+"\">").getBytes());
			 fos.write(str.getBytes(charset));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				fos.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}
	/**
	 * 将响应流写出到文件
	 * 创建人:  杨海龙  
	 * 创建时间:  2015年7月10日 上午11:46:00 
	 * @version 1.0
	 * @param file
	 * @param str
	 * @param charset
	 */
	public static void writeFile(File file,InputStream ips){
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(file);
			byte[] b = new byte[1024];
			int i;
			while ((i = ips.read(b)) != -1) {
				fos.write(b,0,i);
			}
		} catch (FileNotFoundException e2) {
			e2.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(fos!= null){
				try {
					fos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}		
	}
	
	/**
	 * 删除文件及文件夹的方法
	 * 创建人:  杨海龙  
	 * 创建时间:  2015年6月12日 下午3:42:28 
	 * @version 1.0
	 * @param file
	 */
	public static void deleteFile(File file){
		if (file.isFile()) { 
			// 判断是否是文件
			file.delete(); // delete()方法 你应该知道 是删除的意思;
		} else if (file.isDirectory()) { 
			// 否则如果它是一个目录
			File files[] = file.listFiles(); 
			// 声明目录下所有的文件 files[];
			for (int i = 0; i < files.length; i++) { 
				// 遍历目录下所有的文件
				deleteFile(files[i]); // 把每个文件 用这个方法进行迭代
			}
			file.delete();
		}
	}
}
