package com.zzsn.api;

import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class SiteService {

    public static String getParambyname(String url,String name) {

        Map<String,String> map=parse(url);
        return map.get(name);
    }
    public static Map<String,String> parse(String url) {
        Map<String,String> map=new HashMap<String,String>();
        if (url == null) {
            return map;
        }
        url = url.trim();
        if (url.equals("")) {
            return map;
        }
        String[] urlParts = url.split("\\?");
        String uri = urlParts[0];
        //没有参数
        if (urlParts.length == 1) {
            return map;
        }
        //有参数
        String[] params = urlParts[1].split("&");
        for (String param : params) {
            String[] keyValue = param.split("=");
            map.put(keyValue[0], keyValue[1]);
        }

        return map;
    }
}
