package com.zzsn.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


/**
 * 系统变量
 *
 */
@Slf4j
public class Constants {
	public static final String READ_CHARSET = "ISO8859-1";
	public static String DEFAULT_CHARSET = "UTF-8";

	private static Properties prop =getConfig();

	public static Properties getConfig() {
		Properties properties = new Properties();
		InputStream is = null;
		String location = "constants.properties";
		try {
			Resource resource = new DefaultResourceLoader().getResource(location);
			is = resource.getInputStream();
			properties.load(is);
			log.debug("constants config: {}", properties.toString());
		} catch (IOException ex) {
			log.error("Could not load property file:" + location, ex);
		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} catch (IOException ioe) {
				// ignore
			}
		}
		return properties;
	}

	public static final Integer DEV_MODEL =Integer.valueOf(prop.getProperty("DEV_MODEL"));

	//微信爬虫相关的常量
	public static final String WXSENDNAME =prop.getProperty("WXSENDNAME");
	public static final String KAFKA_WXCONSUMER_TOPIC =prop.getProperty("KAFKA_WXCONSUMER_TOPIC");
	public static final String KAFKA_WXDETAILURL_TOPIC =prop.getProperty("KAFKA_WXDETAILURL_TOPIC");
	public static String path=prop.getProperty("path");

	public static final String  KAFKA_CONSUMER_PARTITION= prop.getProperty("KAFKA_CONSUMER_PARTITION");
	//输出目录,仅此处需要修改
	//public static final String DEST_DIR = prop.getProperty("DEST_DIR");
	   //正文目录
    public static final  String CONTENT_DIR =prop.getProperty("CONTENT_DIR");
    //图片目录
    public static final  String IMG_DIR = prop.getProperty("IMG_DIR");
	//保存临界值
	public static final Integer SAVE_LIMIT_SIZE = Integer.valueOf(prop.getProperty("SAVE_LIMIT_SIZE"));
	//保存LIST时间间隔
	public static final Integer SAVE_TIME_INTERVAL_MINUTE = Integer.valueOf(prop.getProperty("SAVE_TIME_INTERVAL_MINUTE"));
	//缓存更新间隔时间
	public static final Integer CACHE_UPDATE_INTERVAL = Integer.valueOf(prop.getProperty("CACHE_UPDATE_INTERVAL"));
	//自动关键词数量
	public static final Integer AUTO_KEYWORDS_SIZE = 10;
	//Lucence 索引保存路径
	public static final String LUCENE_INDEX_DIR = prop.getProperty("LUCENE_INDEX_DIR");
	//Lucence 索引保存路径
	public static final String LUCENE_TASK_INDEX_DIR = prop.getProperty("LUCENE_TASK_INDEX_DIR");
	//爬取内容小于此大小的不保存
	public static final Integer MIN_CONTENT_SIZE = 4;
    //应用北大算法的分类id
    public static final String FILTERTID = prop.getProperty("FILTERTID");
    //相关性过滤算法URl（XGBOOST）
    public static final String RELEVANCE_XGBOOST_URL = prop.getProperty("RELEVANCE_XGBOOST_URL");
    //相关性过滤算法URl（LOGISTIC）
    public static final String RELEVANCE_LOGISTIC_URL = prop.getProperty("RELEVANCE_LOGISTIC_URL");
    //情感判断算法URl
    public static final String SENTIMENT_ANALYSIS_URL = prop.getProperty("SENTIMENT_ANALYSIS_URL");
    
    public static final String CHILDMODEID = prop.getProperty("CHILDMODEID");

	//摘要最小长度
	public static final Integer SUMMARY_MAX_LENGTH =350;
	public static final Integer AUTO_TYPE_WEIGHT =Integer.valueOf(prop.getProperty("AUTO_TYPE_WEIGHT"));
	//抽取
	public static final String EXTRACTOR = "EXTRACTOR";
	//噪音过滤
    public static final String NOISEFILTER = "NOISEFILTER";
	//黑名单	
	public static final String EXCLUDEWORD = "EXCLUDEWORD";
	//排重
	public static final String SIMILARITY = "SIMILARITY";

	//分词
	public static final String SEGMENT = "SEGMENT";
	
	//自动摘要，自动关键词
    public static final String GENERATION = "GENERATION";
    
    //自动分类
    public static final String AUTO_TYPE = "AUTO_TYPE";
    //过滤分类
    public static final String SYSTEMTYPEFILTER = "SYSTEMTYPEFILTER";
    //企业识别
    public static final String COMPANYFIND = "COMPANYFIND";
    //过滤分类
    public static final String SUBJECTKEYWORDSFILTER = "SUBJECTKEYWORDSFILTER";
    //过滤信息源
    public static final String SITEFILTER = "SITEFILTER";
    
    //情感分析	
  	public static final String EMOTION = "EMOTION";
    //命名实体提取（特征词提取）
  	public static final String ENTITY = "ENTITY"; 
  	
    //爬取到的网页类型
    public static final String TYPE_PDF = "PDF";
    public static final String TYPE_WORD = "WORD";
    public static final String TYPE_PPT = "PPT";
    public static final String TYPE_EXCEL = "EXCEL";
	public static final String TYPE_HTML = "HTML";
	
	//缓存设置key
	public static final String SYSTEMTYPE_CACHE_KEY = "systemtype";
	public static final String KEYWORDS_CACHE_KEY = "keywords";
	public static final String SYSTEMTYPEURL_CACHE_KEY = "systemtypeurl";
	public static final String SYSTEMFILTER_CACHE_KEY = "systemfilter";
	public static final String EXCLUDWWORD_CACHE_KEY = "excludword";
	//打分分类
	public static final String SCORE_ORGIN = "orgin";
	public static final String SCORE_MEDIACOUNT = "MediaCount";
	public static final String SCORE_INFOLENGTH = "InfoLength";

	
	//Hash存放memcache中，单独一个key的最大数量
	public static final int HASH_MEMCACHE_SIZE = Integer.valueOf(prop.getProperty("HASH_MEMCACHE_SIZE"));
	//判断重复的rate
	public static final double HASH_SIMILARITY_RATE = Double.valueOf(prop.getProperty("HASH_SIMILARITY_RATE"));
	
	//专题分析OrgId
	public static final Long SUBJECT_ANALYSIS_ORGID = Long.parseLong(prop.getProperty("SUBJECT_ANALYSIS_ORGID"));
	//专题分析带评论的信息源的域名字符串
	public static final String SUBJECT_COMMENT_URL = prop.getProperty("SUBJECT_COMMENT_URL");

	//关键词过滤内容读url
    public static final String CONTENT_EXCLE_URL = prop.getProperty("CONTENT_EXCLE_URL");
    //关键词过滤关键词读url
    public static final String KEYWORDS_EXCLE_URL = prop.getProperty("KEYWORDS_EXCLE_URL");
    //关键词过滤输出url
    public static final String RESULT_EXCLE_URL = prop.getProperty("RESULT_EXCLE_URL");
    //关键词过滤执行线程数
    public static final String THREAD_NUM = prop.getProperty("THREAD_NUM");
    
    
    //专题去重处理  历史数据缓存 天数
    public static final Integer SUBJECT_MEMCACHED_DAYS =  Integer.valueOf(prop.getProperty("SUBJECT_MEMCACHED_DAYS"));
    //境外央企监测去重处理  历史数据缓存 天数
    public static final Long JWYQJC_MEMCACHED_DAYS =   Long.parseLong(prop.getProperty("JWYQJC_MEMCACHED_DAYS"));
    //境外央企监测输入文件url
    public static final String JWYQJC_INFILE_URL = prop.getProperty("JWYQJC_INFILE_URL");
	//判断重复的rate
	public static final Double TITLE_SIMILARITY_RATE = Double.valueOf(prop.getProperty("TITLE_SIMILARITY_RATE"));
	public static final String MODEL_SCORE_URL = prop.getProperty("MODEL_SCORE_URL");
	public static final Integer CACHE_UPDATE = Integer.valueOf(prop.getProperty("CACHE_UPDATE")); 
	//国资监管评价中心相关性过滤算法URl（XGBOOST）
    public static final String RELEVANCE_GZJG_XGBOOST_URL = prop.getProperty("RELEVANCE_GZJG_XGBOOST_URL");
//	public static final boolean CRAL_TYPE = Integer.valueOf(prop.getProperty("CRAW_TYPE")).equals(1);


	public static final Integer PROXYFLAG = Integer.parseInt(prop.getProperty("PROXY"));
	public static final long PROXYID = Long.parseLong(prop.getProperty("PROXYID"));
	public static final String CHROMEDRIVE = prop.getProperty("CHROMEDRIVE");
	public static final String CHROMEBIN = prop.getProperty("CHROMEBIN");

	public static final String  KAFKA_CONSUMER_SERVERS= prop.getProperty("KAFKA_CONSUMER_SERVERS");
	public static final String  KAFKA_CONSUMER_TOPIC= prop.getProperty("KAFKA_CONSUMER_TOPIC");
	public static final String  KAFKA_CONSUMER_GROUP_ID= prop.getProperty("KAFKA_CONSUMER_GROUP_ID");
	public static final String  KAFKA_CONSUMER_AUTO_OFFSET_RESET= prop.getProperty("KAFKA_CONSUMER_AUTO_OFFSET_RESET");

	public static final String  PROXY= prop.getProperty("PROXY");
	public static final String  KAFKA_PRODUCT_TOPIC= prop.getProperty("KAFKA_PRODUCT_TOPIC");
	/*统计信息发送的topic*/
	public static final String  KAFKA_COLLECT_TOPIC= prop.getProperty("KAFKA_COLLECT_TOPIC");

	public static final String  SOURCEADDRESS="SOURCEADDRESS_";

	public static final String  META_SEARCH_URL= prop.getProperty("META_SEARCH_URL");

	//    redis
	public static final String  REDIS_LOCALHOST= prop.getProperty("redis.host");
	public static final String  REDIS_PORT= prop.getProperty("redis.port");
	public static final String  REDIS_PASS= prop.getProperty("redis.pass");
	public static final String  REDIS_TIMEOUT= prop.getProperty("redis.timeout");
	public static final String  REDIS_MAXIDLE= prop.getProperty("redis.maxIdle");
	public static final String  REDIS_MAXTOTAL= prop.getProperty("redis.maxTotal");
	public static final String  REDIS_MAXWAITMILLIS= prop.getProperty("redis.maxWaitMillis");
	public static final String  REDIS_TESTONBORROW= prop.getProperty("redis.testOnBorrow");



	public static final String  HUAWEICLOUD_END_POINT= prop.getProperty("HUAWEICLOUD_END_POINT");
	public static final String  HUAWEICLOUD_BUCKET_NAME= prop.getProperty("HUAWEICLOUD_BUCKET_NAME");
	public static final String  HUAWEICLOUD_AK= prop.getProperty("HUAWEICLOUD_AK");
	public static final String  HUAWEICLOUD_SK= prop.getProperty("HUAWEICLOUD_SK");

}
