package com.zzsn.util;

import org.apache.http.Header;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * 判断html文档字符集帮助类
 * 创建人：李东亮   
 * 创建时间：2016-5-27 上午10:44:48   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class CharsetUtil {


    /**
     * 获取字符集
     * 创建人:  李东亮  
     * 创建时间:  2016-5-13 下午4:15:48 
     * @version 1.0
     * @return
     */
    public static String getCharset(String html,Header contentTypeheader){
        Charset charset =null ;
        if(contentTypeheader!=null){
            charset = CharsetUtil.matchCharset(contentTypeheader.getValue());
        }
        //如果html文档内不包含字符集声明，从http协议中获取
        if(charset==null){
            charset = CharsetUtil.getContentDeclaredCharset(html);
        }
        //如果还没有获取到字符集则用默认字符集
        if(charset==null){
            return Constants.READ_CHARSET;
        }
        return charset.toString();
    }
    /**
     * 获取文本中声明的字符集
     * 创建人:  李东亮  
     * 创建时间:  2016-5-24 下午2:26:00 
     * @version 1.0
     * @param content
     * @return
     */
    public static Charset matchCharset(String content) {
		  String charsetName = null;
		  Matcher matcher = Pattern.compile("charset=([^'\";\\s>]+)").matcher(content);
	        if(matcher.find())
	        {
	            charsetName = matcher.group(1);
	            if(charsetName.equals("2312"))
	                charsetName = "gb2312";
	        }
	        try
	        {
	            return Charset.forName(charsetName);
	        }
	        catch(IllegalArgumentException iae)
	        {
	            return null;
	        }
	    }
    /**
     * 获取文本中声明的字符集
     * 创建人:  李东亮  
     * 创建时间:  2016-5-24 下午2:26:00 
     * @version 1.0
     * @param content
     * @return
     */
    public static Charset getContentDeclaredCharset(String content) {
		  String contentPrefix = "";
	        if(contentPrefix.length() > 3000)
	            contentPrefix = content.substring(0, 3000);
	        else
	            contentPrefix = content;
	        String charsetName = null;
	        Matcher matcher = Pattern.compile("(?is)<meta\\s+[^>]*http-equiv\\s*=\\s*['\"]*content-type['\"]*[^>]*>").matcher(contentPrefix);
	        if(matcher.find())
	        {
	            Charset charset = matchCharset(matcher.group());
	            if(charset != null)
	                return charset;
	        }
	        if(charsetName == null)
	        {
	            matcher = Pattern.compile("(?si)<meta\\s+[^>]*charset=['\"]([^'\";\\s>]+)['\"]").matcher(contentPrefix);
	            if(matcher.find())
	            {
	                charsetName = matcher.group(1);
	            } else
	            {
	                matcher = Pattern.compile("(?is)<\\?xml\\s+[^>]*encoding=['\"]([^'\"]+)['\"]").matcher(contentPrefix);
	                if(matcher.find())
	                {
	                    charsetName = matcher.group(1);
	                    return Charset.forName(charsetName);
	                } else
	                {
	                    return null;
	                }
	            }
	        }
	        try
	        {
	            return Charset.forName(charsetName);
	        }
	        catch(IllegalArgumentException iae)
	        {
	            return null;
	        }
	    }
    
    
    
    
    /**
     * 获取html文本内容，并把乱码文本转换为UTF-8
     * 创建人:  李东亮  
     * 创建时间:  2016-4-7 下午2:15:54 
     * @version 1.0
     * @param html
     * @param targetCharset
     * @return
     */
    public static String convertCorrectCharset(String html,String targetCharset) {
        if(targetCharset==null){
            return html;
        }
        if(!Constants.READ_CHARSET.equals(targetCharset.toString())){
            try {
                html = new String(html.getBytes(Constants.READ_CHARSET),targetCharset.toString());
            } catch (UnsupportedEncodingException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        if (html != null) {
            html = preProcessHtml(html);
        }
        return html;
    }
    
    /**
     * 预处理html文字
     * 创建人:  李东亮  
     * 创建时间:  2015-6-15 下午2:51:43 
     * @version 1.0
     * @param htm
     * @return
     */
    private static String preProcessHtml(String html) {
        html = html.replaceAll("<\\!DOCTYPE\\s+html>", "<html>");
        return html;
    }
    
    /**
     * 转换为UTF-8
     * 创建人:  李东亮  
     * 创建时间:  2016-5-13 下午4:24:18 
     * @version 1.0
     * @param html
     * @param sourceCharset
     * @return
     */
    public static String converCharsetToUTF8(String html,String sourceCharset){
        //统一转换为"UTF-8"字符集
        if (!sourceCharset.matches("(?i)UTF8|(?i)utf-8")) {
            try {
                html = CharsetUtil.convertCharset(html, sourceCharset.toString(),Constants.DEFAULT_CHARSET);
            } catch (UnsupportedEncodingException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return html;
    }
    
    /**
     * 
     * 创建人:  李东亮  
     * 创建时间:  2015-10-28 上午9:35:01 
     * @version 1.0
     * @return
     */
    public static String convertCharset(String content, String sourceCharset, String targetCharset) throws UnsupportedEncodingException {
        byte[] newtemp = new String(content.getBytes(sourceCharset), sourceCharset).getBytes(targetCharset);
        String result = new String(newtemp, targetCharset);
        return result;
    }

    
}
