package com.zzsn.tmpurl;


import com.zzsn.awx.service.SiteService;
import com.zzsn.job.JedisUtil;
import com.zzsn.tmpurl.db.DBManager;
import com.zzsn.tmpurl.db.DataTable;
import com.zzsn.util.WeixinUtil;
import org.apache.commons.lang3.StringUtils;

import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 1.从表中读取资讯数据 id，url
 * 2.调用发送接口将临时url发送到手机
 * 3.fiddler抓取操作手机获取到的永久url并将信息发送到接口
 * 4.对接收的数据进行处理并保存
 *
 *
 */
public class TmpUrl {
    public static void main(String[] args) throws Exception{
        List<Map<String, String>> searchData = searchData();
        for (Map<String, String> map : searchData) {

            String tmpurl=map.get("url");
            String zxid=map.get("id");
            String count = searchDataID(zxid);
            if(Integer.parseInt(count)>0) {
                continue;
            }
            String foreverUrl1 = getForeverUrl(tmpurl);
            if(StringUtils.isNotEmpty(foreverUrl1)){
                intsertData(zxid, tmpurl, foreverUrl1);
                continue;
            }
//            Thread.sleep(1000);
//            sendUrl(tmpurl);
//            Thread.sleep(8000);
//            for (int i = 0; i < 15; i++) {
//                Thread.sleep(1000);
//                String foreverUrl = getForeverUrl(tmpurl);
//                System.out.println(i);
//                if(StringUtils.isNotEmpty(foreverUrl)){
//                        intsertData(zxid, tmpurl, foreverUrl);
//                        break;
//                }
//            }
        }
    }

    //从redis中获取信息
    public static String getForeverUrl(String tmpurl){
        String forurl="";
        try {
            String keyid= SiteService.getParambyname(tmpurl, "signature");
             forurl = JedisUtil.getString("sg_"+keyid);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return forurl;
    }
    //发送信息
    public static void sendUrl(String url){
        WeixinUtil.sendWxMessage("lwg",
					"点击链接: "+url,
					1000002, "ww6bef1e81aacbf27a",
					"ttZJ_KbO3QABs5Z7IDHNa_X4CZizaojherzwzfQ7wl0");
    }
    //1.获取链接
    private static List<Map<String,String>> searchData()
    {
        List<Map<String,String>> mapList=new ArrayList<>();
        String searchSql="select id,SOURCEADDRESS from cis_ans_processitem where sid='2022060801' ";
        DBManager dm = new DBManager();
        String[] coulmn = null;
        int[] type = null;

        try {
            DataTable dt = dm.getResultData(coulmn, type, searchSql);
            if(dt != null && dt.getRowCount()> 0){
                for(int i = 0; i<dt.getRowCount(); i++)
                {
                    Map<String, String> map = new HashMap<>();
                    if(dt.getRow()[i][0].length()>64){
                        map.put("url",dt.getRow()[i][0]);
                    }else{
                        map.put("id",dt.getRow()[i][0]);
                    }
                    if(dt.getRow()[i][1].length()>64){
                        map.put("url",dt.getRow()[i][1]);
                    }else{
                        map.put("id",dt.getRow()[i][1]);
                    }

                    mapList.add(map);
//                    for(int j = 0; j<dt.getColCoun(); j++) {
//                        System.out.printf(dt.getRow()[i][j] + "\t");
//                    }
                    System.out.println();
                }
            }
            else
                System.out.println("查询失败");
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return mapList;
    }

    private static void intsertData(String zxid,String tmpurl,String foreverurl)
    {
        String insertSql = "insert into tmp_forever_url (zxid, tmpurl, foreverurl) values (?,?,?) ";
        DBManager dm = new DBManager();
        String[] coulmn = new String[]{zxid,  tmpurl, foreverurl};
        int[] type = new int[]{Types.CHAR, Types.CHAR, Types.CHAR};

        try {
            boolean flag = dm.updateOrAdd(coulmn, type, insertSql);
            if(flag)
                System.out.println("插入成功");
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static String searchDataID(String zxid)
    {
        String searchSql="select count(*) from tmp_forever_url where zxid='"+zxid+"' ";
        DBManager dm = new DBManager();
        String[] coulmn = null;
        int[] type = null;
        String count="0";
        try {
            DataTable dt = dm.getResultData(coulmn, type, searchSql);
            if(dt != null && dt.getRowCount()> 0){
                for(int i = 0; i<dt.getRowCount(); i++)
                {
                     count = dt.getRow()[i][0];
//                    for(int j = 0; j<dt.getColCoun(); j++) {
//                        System.out.printf(dt.getRow()[i][j] + "\t");
//                    }
                    System.out.println();
                }
            }else {
                System.out.println("查询失败");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }
}
