package com.zzsn.awx.controller;


import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.zzsn.configuration.SpringContextUtil;
import com.zzsn.crawler.WeixinDetailThread;
import com.zzsn.entity.SiteMsgRecord;
import com.zzsn.entity.SiteMsgTemple;
import com.zzsn.entity.Wxurl;
import com.zzsn.job.JedisUtil;
import com.zzsn.awx.service.ApiService;
import com.zzsn.awx.service.SiteService;
import com.zzsn.util.Constants;
import com.zzsn.util.WeixinUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * 后台跳转控制类
 * 创建人：李东亮   
 * 创建时间：2015-5-7 下午6:52:37   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
@Slf4j
@Controller
@RequestMapping("/wxt")
//@RequestMapping("/aawxt")
public class WeixinController {

//	http://localhost:8079/wxt/dofiddlerback?wxurl=1
	@RequestMapping(value ="/test", method = RequestMethod.GET)
	@ResponseBody
	public String  test(){
		return "hello!";
	}
	
	@RequestMapping("dofiddlerback")
	public @ResponseBody String doFiddlerback(String wxurl,String weixinxml) throws Exception
	{
		KafkaTemplate kafkaTemplate= SpringContextUtil.getBean(KafkaTemplate.class);

//		System.out.println(wxurl);
//		System.out.println(weixinxml);
		String patt = "http:.{200,300}#wechat_redirect";
		Pattern p=Pattern.compile(patt);
		Matcher m=p.matcher(weixinxml);
		int count=0;
		Date collectTime=null;
		String infoSourceId="";
		while (m.find()) {
			String weixinurl=m.group(0).replaceAll("\\\\","").replaceAll("amp;","");
			
			//判断是否爬取
//			String keyanv= JedisUtil.getString(weixinurl);
//			if(StringUtils.isEmpty(keyanv)){
				SiteMsgTemple site=new SiteMsgTemple();
				site.setSiteUri(weixinurl);
				ObjectMapper mapper = new ObjectMapper();
				String docjson = mapper.writeValueAsString(site);
//				kafkaTemplate.send(Constants.KAFKA_WXDETAILURL_TOPIC, "key", docjson);
				WeixinDetailThread weixinDetailThread=new WeixinDetailThread();
				String weixinid=weixinDetailThread.getParam(weixinurl);
				String siteStr = JedisUtil.getString(":"+weixinid);
				SiteMsgTemple siteMsgTemple = JSON.parseObject(siteStr, SiteMsgTemple.class);
				siteMsgTemple.setSiteUri(weixinurl);
				weixinDetailThread.siteMsgTemple=siteMsgTemple; //如何取到对应的微信公众号信息
				collectTime= DateTime.now();
				infoSourceId=siteMsgTemple.getId();
				//根据链接请求下载资讯并发送到kafka
				boolean flag = weixinDetailThread.detailCrawler();
				if(flag) {
					count++;
				}
			    log.info("提取公众号详情信息url："+weixinurl);
//			}else{
//				log.info("公众号详情url已爬取："+weixinurl);
//			}
		}
		if(count>0){
			ObjectMapper mapper = new ObjectMapper();
			try {
				SiteMsgRecord siteMsgRecord =new SiteMsgRecord();
				siteMsgRecord.setInfoSourceId(infoSourceId);
				siteMsgRecord.setNum(count);
				siteMsgRecord.setSource("1");
				siteMsgRecord.setCollectTime(collectTime);

				String docjson = mapper.writeValueAsString(siteMsgRecord);
				System.out.println(docjson);
				kafkaTemplate.send(Constants.KAFKA_COLLECT_TOPIC, "key", docjson);
				log.info("发送到kafka成功。");
			} catch (JsonProcessingException e) {
//                    e.printStackTrace();
				log.info("发送到kafka失败。");
			}
		}

		return "ok";
	}

	@RequestMapping("dofiddlerbackurl")
	public @ResponseBody String doFiddlerbackforurl(String wxurl,String oldurl) throws Exception
	{
		String keyid= SiteService.getParambyname(oldurl, "signature");
//		String wxid= JedisUtil.getString(keyid);
//
//		if(StringUtils.isNotEmpty(wxid)&&StringUtils.isNotEmpty(wxurl)) {
//			JedisUtil.setString("sg_"+oldurl,wxurl,0);
//		}
		System.out.println(oldurl);
		JedisUtil.setString("sg_"+keyid,wxurl,0);
		return "123";
	}
//	@RequestMapping("dofiddlerbackurl")
//	public @ResponseBody String doFiddlerbackforurl(String wxurl,String oldurl) throws Exception
//	{
//		System.out.println(wxurl);
//		System.out.println(oldurl);
//		String keyid=SiteService.getParambyname(oldurl, "signature");
//		String wxid=JedisUtil.getString(keyid);
//		String wxidflag=JedisUtil.getString("apiflag"+keyid);
//
//		if(StringUtils.isNotEmpty(wxid)&&StringUtils.isNotEmpty(wxidflag)&&StringUtils.isNotEmpty(wxurl)) {
//			Wxurl wxurl1=new Wxurl();
//			wxurl1.setId(Long.valueOf(wxid));
//			wxurl1.setNurl(wxurl);
//			JedisUtil.setString(oldurl,wxurl,0);
//		}
//
//		return "123";
//	}


	@RequestMapping("dofiddlerbackurl111")
	public @ResponseBody String doFiddlerbackforurl111(String wxurl,String oldurl) throws Exception
	{
		System.out.println(wxurl);
		System.out.println(oldurl);
		String keyid=SiteService.getParambyname(oldurl, "signature");
		String wxid=JedisUtil.getString(keyid);
//		siteService.updateBasedata(wxid, wxurl);
		return "123";
	}

	public static void main(String[] args) {
		 String patt = "http:.{200,300}#wechat_redirect";
		String html="etime&quot;:1562742531,&quot;fakeid&quot;:&quot;3008169006&quot;,&quot;status&quot;:2,&quot;content&quot;:&quot;&quot;},&quot;app_msg_ext_info&quot;:{&quot;title&quot;:&quot;孩子，爸爸没有双手，依然可以抱你长大！&quot;,&quot;digest&quot;:&quot;一场意外事故，让他在13岁时失去了双臂。如今他照顾着九个月大的儿子。&quot;,&quot;content&quot;:&quot;&quot;,&quot;fileid&quot;:504808950,&quot;content_url&quot;:&quot;http:\\/\\/mp.weixin.qq.com\\/s?__biz=MzAwODE2OTAwNg==&amp;amp;mid=2652292603&amp;amp;idx=1&amp;amp;sn=7f49e032fab2b1df15ca01a4add8e968&amp;amp;chksm=809096bab7e71fac1bec47b17d37314c0948dd1ed61aea09abaa823f498f17e8511ce5bb08f2&amp;amp;scene=27#wechat_redirect&quot;,&quot;source_url&quot;:&quot;https:\\/\\/sina.cn\\/&quot;,&quot;cover&quot;:&quot;http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/x6iaHWKibUzk0J1dOiccqkceSyM6n6SngTicJyaUo7N7zGAtz7pzJOZ8PibUyibgEvQKIWzV5I0yLAiaeHPrLTEU9nW6A\\/0?wx_fmt=jpeg&quot;,&quot;subtype&quot;:9,&quot;is_multi&quot;:1,&quot;multi_app_msg_item_list&quot;:[{&quot;title&quot;:&quot;捉谣记&nbsp;|&nbsp;官方公布酒驾玛莎拉蒂女车主有间歇性精神病？消息不靠谱&quot;,&quot;digest&quot;:&quot;目前并没有任何在调查和处置该案的“官方”公布酒驾女车主有间歇性精神病。&quot;,&quot;content&quot;:&quot;&quot;,&quot;fileid&quot;:504808954,&quot;content_url&quot;:&quot;http:\\/\\/mp.weixin.qq.com\\/s?__biz=MzAwODE2OTAwNg==&amp;amp;mid=2652292603&amp;amp;idx=2&amp;amp;sn=ef7a35347bc9dceb79c0fa42f8840f79&amp;amp;chksm=809096bab7e71fac9e77e6a1521f64c58e919be1522f4a1dccdad5aa75be3a787346a46e1667&amp;amp;scene=27#wechat_redirect&quot;,&quot;source_url&quot;:&quot;https:\\/\\/sina.cn\\/&quot;,&quot;cover&quot;:&quot;http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/x6iaHWKibUzk0J1dOiccqkceSyM6n6SngTicPeCnYPoIzGSvXISGLQFdRIkV0ZrOODuczz0bxCFXXqfTIv6IOqVPtg\\/0?";
		Pattern p=Pattern.compile(patt);
		Matcher m=p.matcher(html);
		while (m.find()) {
			System.out.println(1);
			System.out.println(m.group(0));
			System.out.println(m.group(0).replaceAll("\\\\","").replaceAll("amp;",""));
			System.out.println(m.group(0).length());
		}
		
		
		WeixinUtil.sendWxMessage("lwg2468741258", "点击链接:"+"http://mp.weixin.qq.com/s?__biz=MzAwODE2OTAwNg==&mid=2652292603&idx=2&sn=ef7a35347bc9dceb79c0fa42f8840f79&chksm=809096bab7e71fac9e77e6a1521f64c58e919be1522f4a1dccdad5aa75be3a787346a46e1667&scene=27#wechat_redirect", 1000002, "ww6bef1e81aacbf27a",
				 "ttZJ_KbO3QABs5Z7IDHNa_X4CZizaojherzwzfQ7wl0");
	}

	
	@RequestMapping("dofiddlerbackapp")
	public @ResponseBody String doFiddlerbackapp(String wxurl,String weixinxml) throws Exception
	{
		System.out.println(wxurl);
		System.out.println(weixinxml);
		String patt = "http://m.toutiao.com.{10,30}\"";
		Pattern p=Pattern.compile(patt);
		Matcher m=p.matcher(weixinxml);
		while (m.find()) {
			String weixinurl=m.group(0).replaceAll("\\\\","").replaceAll("amp;","");
			
			//判断是否爬取
			//String keyanv=MemcachedFactory.getKeyStr(weixinurl);
			String keyanv=null;
			if(StringUtils.isEmpty(keyanv)){
				SiteMsgTemple site=new SiteMsgTemple();
				site.setSiteUri(weixinurl);
				//mqSender.sendSite(site);
				System.out.println("录入mq"+weixinurl);
			}else{
				System.out.println("yipaqu:"+weixinurl);
			}
		}
		return "123";
	}
	
}
